/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.message.boards.model.MBSuspiciousActivity;
import com.liferay.message.boards.service.MBSuspiciousActivityLocalServiceUtil;

/**
 * The extended model base implementation for the MBSuspiciousActivity service. Represents a row in the &quot;MBSuspiciousActivity&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBSuspiciousActivityImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBSuspiciousActivityImpl
 * @see MBSuspiciousActivity
 * @generated
 */
public abstract class MBSuspiciousActivityBaseImpl
	extends MBSuspiciousActivityModelImpl implements MBSuspiciousActivity {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message boards suspicious activity model instance should use the <code>MBSuspiciousActivity</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			MBSuspiciousActivityLocalServiceUtil.addMBSuspiciousActivity(this);
		}
		else {
			MBSuspiciousActivityLocalServiceUtil.updateMBSuspiciousActivity(
				this);
		}
	}

}