/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBMailingList;
import com.liferay.message.boards.model.MBMailingListModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MBMailingList service. Represents a row in the &quot;MBMailingList&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MBMailingListModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBMailingListImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBMailingListImpl
 * @generated
 */
public class MBMailingListModelImpl
	extends BaseModelImpl<MBMailingList> implements MBMailingListModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message boards mailing list model instance should use the <code>MBMailingList</code> interface instead.
	 */
	public static final String TABLE_NAME = "MBMailingList";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"mailingListId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"categoryId", Types.BIGINT}, {"emailAddress", Types.VARCHAR},
		{"inProtocol", Types.VARCHAR}, {"inServerName", Types.VARCHAR},
		{"inServerPort", Types.INTEGER}, {"inUseSSL", Types.BOOLEAN},
		{"inUserName", Types.VARCHAR}, {"inPassword", Types.VARCHAR},
		{"inReadInterval", Types.INTEGER}, {"outEmailAddress", Types.VARCHAR},
		{"outCustom", Types.BOOLEAN}, {"outServerName", Types.VARCHAR},
		{"outServerPort", Types.INTEGER}, {"outUseSSL", Types.BOOLEAN},
		{"outUserName", Types.VARCHAR}, {"outPassword", Types.VARCHAR},
		{"allowAnonymous", Types.BOOLEAN}, {"active_", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("mailingListId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("categoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("emailAddress", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("inProtocol", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("inServerName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("inServerPort", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("inUseSSL", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("inUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("inPassword", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("inReadInterval", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("outEmailAddress", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("outCustom", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("outServerName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("outServerPort", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("outUseSSL", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("outUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("outPassword", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("allowAnonymous", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table MBMailingList (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,mailingListId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,categoryId LONG,emailAddress VARCHAR(254) null,inProtocol VARCHAR(75) null,inServerName VARCHAR(75) null,inServerPort INTEGER,inUseSSL BOOLEAN,inUserName VARCHAR(75) null,inPassword VARCHAR(75) null,inReadInterval INTEGER,outEmailAddress VARCHAR(254) null,outCustom BOOLEAN,outServerName VARCHAR(75) null,outServerPort INTEGER,outUseSSL BOOLEAN,outUserName VARCHAR(75) null,outPassword VARCHAR(75) null,allowAnonymous BOOLEAN,active_ BOOLEAN,primary key (mailingListId, ctCollectionId))";

	public static final String TABLE_SQL_DROP = "drop table MBMailingList";

	public static final String ORDER_BY_JPQL =
		" ORDER BY mbMailingList.mailingListId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY MBMailingList.mailingListId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CATEGORYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MAILINGLISTID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public MBMailingListModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _mailingListId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setMailingListId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _mailingListId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MBMailingList.class;
	}

	@Override
	public String getModelClassName() {
		return MBMailingList.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MBMailingList, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MBMailingList, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMailingList, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((MBMailingList)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MBMailingList, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MBMailingList, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MBMailingList)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MBMailingList, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MBMailingList, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<MBMailingList, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<MBMailingList, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<MBMailingList, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", MBMailingList::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", MBMailingList::getCtCollectionId);
			attributeGetterFunctions.put("uuid", MBMailingList::getUuid);
			attributeGetterFunctions.put(
				"mailingListId", MBMailingList::getMailingListId);
			attributeGetterFunctions.put("groupId", MBMailingList::getGroupId);
			attributeGetterFunctions.put(
				"companyId", MBMailingList::getCompanyId);
			attributeGetterFunctions.put("userId", MBMailingList::getUserId);
			attributeGetterFunctions.put(
				"userName", MBMailingList::getUserName);
			attributeGetterFunctions.put(
				"createDate", MBMailingList::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", MBMailingList::getModifiedDate);
			attributeGetterFunctions.put(
				"categoryId", MBMailingList::getCategoryId);
			attributeGetterFunctions.put(
				"emailAddress", MBMailingList::getEmailAddress);
			attributeGetterFunctions.put(
				"inProtocol", MBMailingList::getInProtocol);
			attributeGetterFunctions.put(
				"inServerName", MBMailingList::getInServerName);
			attributeGetterFunctions.put(
				"inServerPort", MBMailingList::getInServerPort);
			attributeGetterFunctions.put(
				"inUseSSL", MBMailingList::getInUseSSL);
			attributeGetterFunctions.put(
				"inUserName", MBMailingList::getInUserName);
			attributeGetterFunctions.put(
				"inPassword", MBMailingList::getInPassword);
			attributeGetterFunctions.put(
				"inReadInterval", MBMailingList::getInReadInterval);
			attributeGetterFunctions.put(
				"outEmailAddress", MBMailingList::getOutEmailAddress);
			attributeGetterFunctions.put(
				"outCustom", MBMailingList::getOutCustom);
			attributeGetterFunctions.put(
				"outServerName", MBMailingList::getOutServerName);
			attributeGetterFunctions.put(
				"outServerPort", MBMailingList::getOutServerPort);
			attributeGetterFunctions.put(
				"outUseSSL", MBMailingList::getOutUseSSL);
			attributeGetterFunctions.put(
				"outUserName", MBMailingList::getOutUserName);
			attributeGetterFunctions.put(
				"outPassword", MBMailingList::getOutPassword);
			attributeGetterFunctions.put(
				"allowAnonymous", MBMailingList::getAllowAnonymous);
			attributeGetterFunctions.put("active", MBMailingList::getActive);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map<String, BiConsumer<MBMailingList, Object>>
			_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<MBMailingList, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap<String, BiConsumer<MBMailingList, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<MBMailingList, Long>)MBMailingList::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<MBMailingList, Long>)
					MBMailingList::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<MBMailingList, String>)MBMailingList::setUuid);
			attributeSetterBiConsumers.put(
				"mailingListId",
				(BiConsumer<MBMailingList, Long>)
					MBMailingList::setMailingListId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<MBMailingList, Long>)MBMailingList::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<MBMailingList, Long>)MBMailingList::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<MBMailingList, Long>)MBMailingList::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<MBMailingList, String>)MBMailingList::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<MBMailingList, Date>)MBMailingList::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<MBMailingList, Date>)
					MBMailingList::setModifiedDate);
			attributeSetterBiConsumers.put(
				"categoryId",
				(BiConsumer<MBMailingList, Long>)MBMailingList::setCategoryId);
			attributeSetterBiConsumers.put(
				"emailAddress",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setEmailAddress);
			attributeSetterBiConsumers.put(
				"inProtocol",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setInProtocol);
			attributeSetterBiConsumers.put(
				"inServerName",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setInServerName);
			attributeSetterBiConsumers.put(
				"inServerPort",
				(BiConsumer<MBMailingList, Integer>)
					MBMailingList::setInServerPort);
			attributeSetterBiConsumers.put(
				"inUseSSL",
				(BiConsumer<MBMailingList, Boolean>)MBMailingList::setInUseSSL);
			attributeSetterBiConsumers.put(
				"inUserName",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setInUserName);
			attributeSetterBiConsumers.put(
				"inPassword",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setInPassword);
			attributeSetterBiConsumers.put(
				"inReadInterval",
				(BiConsumer<MBMailingList, Integer>)
					MBMailingList::setInReadInterval);
			attributeSetterBiConsumers.put(
				"outEmailAddress",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setOutEmailAddress);
			attributeSetterBiConsumers.put(
				"outCustom",
				(BiConsumer<MBMailingList, Boolean>)
					MBMailingList::setOutCustom);
			attributeSetterBiConsumers.put(
				"outServerName",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setOutServerName);
			attributeSetterBiConsumers.put(
				"outServerPort",
				(BiConsumer<MBMailingList, Integer>)
					MBMailingList::setOutServerPort);
			attributeSetterBiConsumers.put(
				"outUseSSL",
				(BiConsumer<MBMailingList, Boolean>)
					MBMailingList::setOutUseSSL);
			attributeSetterBiConsumers.put(
				"outUserName",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setOutUserName);
			attributeSetterBiConsumers.put(
				"outPassword",
				(BiConsumer<MBMailingList, String>)
					MBMailingList::setOutPassword);
			attributeSetterBiConsumers.put(
				"allowAnonymous",
				(BiConsumer<MBMailingList, Boolean>)
					MBMailingList::setAllowAnonymous);
			attributeSetterBiConsumers.put(
				"active",
				(BiConsumer<MBMailingList, Boolean>)MBMailingList::setActive);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getMailingListId() {
		return _mailingListId;
	}

	@Override
	public void setMailingListId(long mailingListId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mailingListId = mailingListId;
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public long getCategoryId() {
		return _categoryId;
	}

	@Override
	public void setCategoryId(long categoryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_categoryId = categoryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCategoryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("categoryId"));
	}

	@Override
	public String getEmailAddress() {
		if (_emailAddress == null) {
			return "";
		}
		else {
			return _emailAddress;
		}
	}

	@Override
	public void setEmailAddress(String emailAddress) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_emailAddress = emailAddress;
	}

	@Override
	public String getInProtocol() {
		if (_inProtocol == null) {
			return "";
		}
		else {
			return _inProtocol;
		}
	}

	@Override
	public void setInProtocol(String inProtocol) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inProtocol = inProtocol;
	}

	@Override
	public String getInServerName() {
		if (_inServerName == null) {
			return "";
		}
		else {
			return _inServerName;
		}
	}

	@Override
	public void setInServerName(String inServerName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inServerName = inServerName;
	}

	@Override
	public int getInServerPort() {
		return _inServerPort;
	}

	@Override
	public void setInServerPort(int inServerPort) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inServerPort = inServerPort;
	}

	@Override
	public boolean getInUseSSL() {
		return _inUseSSL;
	}

	@Override
	public boolean isInUseSSL() {
		return _inUseSSL;
	}

	@Override
	public void setInUseSSL(boolean inUseSSL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inUseSSL = inUseSSL;
	}

	@Override
	public String getInUserName() {
		if (_inUserName == null) {
			return "";
		}
		else {
			return _inUserName;
		}
	}

	@Override
	public void setInUserName(String inUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inUserName = inUserName;
	}

	@Override
	public String getInPassword() {
		if (_inPassword == null) {
			return "";
		}
		else {
			return _inPassword;
		}
	}

	@Override
	public void setInPassword(String inPassword) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inPassword = inPassword;
	}

	@Override
	public int getInReadInterval() {
		return _inReadInterval;
	}

	@Override
	public void setInReadInterval(int inReadInterval) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_inReadInterval = inReadInterval;
	}

	@Override
	public String getOutEmailAddress() {
		if (_outEmailAddress == null) {
			return "";
		}
		else {
			return _outEmailAddress;
		}
	}

	@Override
	public void setOutEmailAddress(String outEmailAddress) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outEmailAddress = outEmailAddress;
	}

	@Override
	public boolean getOutCustom() {
		return _outCustom;
	}

	@Override
	public boolean isOutCustom() {
		return _outCustom;
	}

	@Override
	public void setOutCustom(boolean outCustom) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outCustom = outCustom;
	}

	@Override
	public String getOutServerName() {
		if (_outServerName == null) {
			return "";
		}
		else {
			return _outServerName;
		}
	}

	@Override
	public void setOutServerName(String outServerName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outServerName = outServerName;
	}

	@Override
	public int getOutServerPort() {
		return _outServerPort;
	}

	@Override
	public void setOutServerPort(int outServerPort) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outServerPort = outServerPort;
	}

	@Override
	public boolean getOutUseSSL() {
		return _outUseSSL;
	}

	@Override
	public boolean isOutUseSSL() {
		return _outUseSSL;
	}

	@Override
	public void setOutUseSSL(boolean outUseSSL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outUseSSL = outUseSSL;
	}

	@Override
	public String getOutUserName() {
		if (_outUserName == null) {
			return "";
		}
		else {
			return _outUserName;
		}
	}

	@Override
	public void setOutUserName(String outUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outUserName = outUserName;
	}

	@Override
	public String getOutPassword() {
		if (_outPassword == null) {
			return "";
		}
		else {
			return _outPassword;
		}
	}

	@Override
	public void setOutPassword(String outPassword) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_outPassword = outPassword;
	}

	@Override
	public boolean getAllowAnonymous() {
		return _allowAnonymous;
	}

	@Override
	public boolean isAllowAnonymous() {
		return _allowAnonymous;
	}

	@Override
	public void setAllowAnonymous(boolean allowAnonymous) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_allowAnonymous = allowAnonymous;
	}

	@Override
	public boolean getActive() {
		return _active;
	}

	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(MBMailingList.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MBMailingList.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MBMailingList toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MBMailingList>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MBMailingListImpl mbMailingListImpl = new MBMailingListImpl();

		mbMailingListImpl.setMvccVersion(getMvccVersion());
		mbMailingListImpl.setCtCollectionId(getCtCollectionId());
		mbMailingListImpl.setUuid(getUuid());
		mbMailingListImpl.setMailingListId(getMailingListId());
		mbMailingListImpl.setGroupId(getGroupId());
		mbMailingListImpl.setCompanyId(getCompanyId());
		mbMailingListImpl.setUserId(getUserId());
		mbMailingListImpl.setUserName(getUserName());
		mbMailingListImpl.setCreateDate(getCreateDate());
		mbMailingListImpl.setModifiedDate(getModifiedDate());
		mbMailingListImpl.setCategoryId(getCategoryId());
		mbMailingListImpl.setEmailAddress(getEmailAddress());
		mbMailingListImpl.setInProtocol(getInProtocol());
		mbMailingListImpl.setInServerName(getInServerName());
		mbMailingListImpl.setInServerPort(getInServerPort());
		mbMailingListImpl.setInUseSSL(isInUseSSL());
		mbMailingListImpl.setInUserName(getInUserName());
		mbMailingListImpl.setInPassword(getInPassword());
		mbMailingListImpl.setInReadInterval(getInReadInterval());
		mbMailingListImpl.setOutEmailAddress(getOutEmailAddress());
		mbMailingListImpl.setOutCustom(isOutCustom());
		mbMailingListImpl.setOutServerName(getOutServerName());
		mbMailingListImpl.setOutServerPort(getOutServerPort());
		mbMailingListImpl.setOutUseSSL(isOutUseSSL());
		mbMailingListImpl.setOutUserName(getOutUserName());
		mbMailingListImpl.setOutPassword(getOutPassword());
		mbMailingListImpl.setAllowAnonymous(isAllowAnonymous());
		mbMailingListImpl.setActive(isActive());

		mbMailingListImpl.resetOriginalValues();

		return mbMailingListImpl;
	}

	@Override
	public MBMailingList cloneWithOriginalValues() {
		MBMailingListImpl mbMailingListImpl = new MBMailingListImpl();

		mbMailingListImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		mbMailingListImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		mbMailingListImpl.setUuid(this.<String>getColumnOriginalValue("uuid_"));
		mbMailingListImpl.setMailingListId(
			this.<Long>getColumnOriginalValue("mailingListId"));
		mbMailingListImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		mbMailingListImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		mbMailingListImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		mbMailingListImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		mbMailingListImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		mbMailingListImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		mbMailingListImpl.setCategoryId(
			this.<Long>getColumnOriginalValue("categoryId"));
		mbMailingListImpl.setEmailAddress(
			this.<String>getColumnOriginalValue("emailAddress"));
		mbMailingListImpl.setInProtocol(
			this.<String>getColumnOriginalValue("inProtocol"));
		mbMailingListImpl.setInServerName(
			this.<String>getColumnOriginalValue("inServerName"));
		mbMailingListImpl.setInServerPort(
			this.<Integer>getColumnOriginalValue("inServerPort"));
		mbMailingListImpl.setInUseSSL(
			this.<Boolean>getColumnOriginalValue("inUseSSL"));
		mbMailingListImpl.setInUserName(
			this.<String>getColumnOriginalValue("inUserName"));
		mbMailingListImpl.setInPassword(
			this.<String>getColumnOriginalValue("inPassword"));
		mbMailingListImpl.setInReadInterval(
			this.<Integer>getColumnOriginalValue("inReadInterval"));
		mbMailingListImpl.setOutEmailAddress(
			this.<String>getColumnOriginalValue("outEmailAddress"));
		mbMailingListImpl.setOutCustom(
			this.<Boolean>getColumnOriginalValue("outCustom"));
		mbMailingListImpl.setOutServerName(
			this.<String>getColumnOriginalValue("outServerName"));
		mbMailingListImpl.setOutServerPort(
			this.<Integer>getColumnOriginalValue("outServerPort"));
		mbMailingListImpl.setOutUseSSL(
			this.<Boolean>getColumnOriginalValue("outUseSSL"));
		mbMailingListImpl.setOutUserName(
			this.<String>getColumnOriginalValue("outUserName"));
		mbMailingListImpl.setOutPassword(
			this.<String>getColumnOriginalValue("outPassword"));
		mbMailingListImpl.setAllowAnonymous(
			this.<Boolean>getColumnOriginalValue("allowAnonymous"));
		mbMailingListImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));

		return mbMailingListImpl;
	}

	@Override
	public int compareTo(MBMailingList mbMailingList) {
		long primaryKey = mbMailingList.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MBMailingList)) {
			return false;
		}

		MBMailingList mbMailingList = (MBMailingList)object;

		long primaryKey = mbMailingList.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MBMailingList> toCacheModel() {
		MBMailingListCacheModel mbMailingListCacheModel =
			new MBMailingListCacheModel();

		mbMailingListCacheModel.mvccVersion = getMvccVersion();

		mbMailingListCacheModel.ctCollectionId = getCtCollectionId();

		mbMailingListCacheModel.uuid = getUuid();

		String uuid = mbMailingListCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			mbMailingListCacheModel.uuid = null;
		}

		mbMailingListCacheModel.mailingListId = getMailingListId();

		mbMailingListCacheModel.groupId = getGroupId();

		mbMailingListCacheModel.companyId = getCompanyId();

		mbMailingListCacheModel.userId = getUserId();

		mbMailingListCacheModel.userName = getUserName();

		String userName = mbMailingListCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			mbMailingListCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			mbMailingListCacheModel.createDate = createDate.getTime();
		}
		else {
			mbMailingListCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			mbMailingListCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			mbMailingListCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		mbMailingListCacheModel.categoryId = getCategoryId();

		mbMailingListCacheModel.emailAddress = getEmailAddress();

		String emailAddress = mbMailingListCacheModel.emailAddress;

		if ((emailAddress != null) && (emailAddress.length() == 0)) {
			mbMailingListCacheModel.emailAddress = null;
		}

		mbMailingListCacheModel.inProtocol = getInProtocol();

		String inProtocol = mbMailingListCacheModel.inProtocol;

		if ((inProtocol != null) && (inProtocol.length() == 0)) {
			mbMailingListCacheModel.inProtocol = null;
		}

		mbMailingListCacheModel.inServerName = getInServerName();

		String inServerName = mbMailingListCacheModel.inServerName;

		if ((inServerName != null) && (inServerName.length() == 0)) {
			mbMailingListCacheModel.inServerName = null;
		}

		mbMailingListCacheModel.inServerPort = getInServerPort();

		mbMailingListCacheModel.inUseSSL = isInUseSSL();

		mbMailingListCacheModel.inUserName = getInUserName();

		String inUserName = mbMailingListCacheModel.inUserName;

		if ((inUserName != null) && (inUserName.length() == 0)) {
			mbMailingListCacheModel.inUserName = null;
		}

		mbMailingListCacheModel.inPassword = getInPassword();

		String inPassword = mbMailingListCacheModel.inPassword;

		if ((inPassword != null) && (inPassword.length() == 0)) {
			mbMailingListCacheModel.inPassword = null;
		}

		mbMailingListCacheModel.inReadInterval = getInReadInterval();

		mbMailingListCacheModel.outEmailAddress = getOutEmailAddress();

		String outEmailAddress = mbMailingListCacheModel.outEmailAddress;

		if ((outEmailAddress != null) && (outEmailAddress.length() == 0)) {
			mbMailingListCacheModel.outEmailAddress = null;
		}

		mbMailingListCacheModel.outCustom = isOutCustom();

		mbMailingListCacheModel.outServerName = getOutServerName();

		String outServerName = mbMailingListCacheModel.outServerName;

		if ((outServerName != null) && (outServerName.length() == 0)) {
			mbMailingListCacheModel.outServerName = null;
		}

		mbMailingListCacheModel.outServerPort = getOutServerPort();

		mbMailingListCacheModel.outUseSSL = isOutUseSSL();

		mbMailingListCacheModel.outUserName = getOutUserName();

		String outUserName = mbMailingListCacheModel.outUserName;

		if ((outUserName != null) && (outUserName.length() == 0)) {
			mbMailingListCacheModel.outUserName = null;
		}

		mbMailingListCacheModel.outPassword = getOutPassword();

		String outPassword = mbMailingListCacheModel.outPassword;

		if ((outPassword != null) && (outPassword.length() == 0)) {
			mbMailingListCacheModel.outPassword = null;
		}

		mbMailingListCacheModel.allowAnonymous = isAllowAnonymous();

		mbMailingListCacheModel.active = isActive();

		return mbMailingListCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MBMailingList, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MBMailingList, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBMailingList, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((MBMailingList)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, MBMailingList>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					MBMailingList.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _mailingListId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _categoryId;
	private String _emailAddress;
	private String _inProtocol;
	private String _inServerName;
	private int _inServerPort;
	private boolean _inUseSSL;
	private String _inUserName;
	private String _inPassword;
	private int _inReadInterval;
	private String _outEmailAddress;
	private boolean _outCustom;
	private String _outServerName;
	private int _outServerPort;
	private boolean _outUseSSL;
	private String _outUserName;
	private String _outPassword;
	private boolean _allowAnonymous;
	private boolean _active;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<MBMailingList, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((MBMailingList)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("mailingListId", _mailingListId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("categoryId", _categoryId);
		_columnOriginalValues.put("emailAddress", _emailAddress);
		_columnOriginalValues.put("inProtocol", _inProtocol);
		_columnOriginalValues.put("inServerName", _inServerName);
		_columnOriginalValues.put("inServerPort", _inServerPort);
		_columnOriginalValues.put("inUseSSL", _inUseSSL);
		_columnOriginalValues.put("inUserName", _inUserName);
		_columnOriginalValues.put("inPassword", _inPassword);
		_columnOriginalValues.put("inReadInterval", _inReadInterval);
		_columnOriginalValues.put("outEmailAddress", _outEmailAddress);
		_columnOriginalValues.put("outCustom", _outCustom);
		_columnOriginalValues.put("outServerName", _outServerName);
		_columnOriginalValues.put("outServerPort", _outServerPort);
		_columnOriginalValues.put("outUseSSL", _outUseSSL);
		_columnOriginalValues.put("outUserName", _outUserName);
		_columnOriginalValues.put("outPassword", _outPassword);
		_columnOriginalValues.put("allowAnonymous", _allowAnonymous);
		_columnOriginalValues.put("active_", _active);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("mailingListId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("categoryId", 1024L);

		columnBitmasks.put("emailAddress", 2048L);

		columnBitmasks.put("inProtocol", 4096L);

		columnBitmasks.put("inServerName", 8192L);

		columnBitmasks.put("inServerPort", 16384L);

		columnBitmasks.put("inUseSSL", 32768L);

		columnBitmasks.put("inUserName", 65536L);

		columnBitmasks.put("inPassword", 131072L);

		columnBitmasks.put("inReadInterval", 262144L);

		columnBitmasks.put("outEmailAddress", 524288L);

		columnBitmasks.put("outCustom", 1048576L);

		columnBitmasks.put("outServerName", 2097152L);

		columnBitmasks.put("outServerPort", 4194304L);

		columnBitmasks.put("outUseSSL", 8388608L);

		columnBitmasks.put("outUserName", 16777216L);

		columnBitmasks.put("outPassword", 33554432L);

		columnBitmasks.put("allowAnonymous", 67108864L);

		columnBitmasks.put("active_", 134217728L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private MBMailingList _escapedModel;

}