/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.service.base.MBBanServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=mb", "json.web.service.context.path=MBBan"}, service={AopService.class})
public class MBBanServiceImpl
extends MBBanServiceBaseImpl {
    @Reference
    private Portal _portal;
    @Reference(target="(resource.name=com.liferay.message.boards)")
    private PortletResourcePermission _portletResourcePermission;
    @Reference
    private UserLocalService _userLocalService;

    public MBBan addBan(long banUserId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "BAN_USER");
        User banUser = this._userLocalService.getUser(banUserId);
        boolean groupAdmin = false;
        try {
            groupAdmin = this._portal.isGroupAdmin(banUser, serviceContext.getScopeGroupId());
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        if (groupAdmin) {
            throw new PrincipalException();
        }
        return this.mbBanLocalService.addBan(this.getUserId(), banUserId, serviceContext);
    }

    public void deleteBan(long banUserId, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "BAN_USER");
        this.mbBanLocalService.deleteBan(banUserId, serviceContext);
    }
}

