/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.trash;

import com.liferay.asset.util.AssetHelper;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.message.boards.service.MBMessageServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.trash.BaseJSPTrashRenderer;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;

public class MBThreadTrashRenderer
extends BaseJSPTrashRenderer {
    public static final String TYPE = "message_thread";
    private final AssetHelper _assetHelper;
    private final MBMessage _rootMessage;
    private final MBThread _thread;

    public MBThreadTrashRenderer(MBThread thread, AssetHelper assetHelper) throws PortalException {
        this._thread = thread;
        this._assetHelper = assetHelper;
        this._rootMessage = MBMessageLocalServiceUtil.getMBMessage((long)thread.getRootMessageId());
    }

    public String getClassName() {
        return MBThread.class.getName();
    }

    public long getClassPK() {
        return this._thread.getPrimaryKey();
    }

    public String getIconCssClass() {
        return "comments";
    }

    public String getJspPath(HttpServletRequest httpServletRequest, String template) {
        return "/message_boards/view_message_content.jsp";
    }

    public String getPortletId() {
        return "com_liferay_message_boards_web_portlet_MBPortlet";
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    public String getTitle(Locale locale) {
        return HtmlUtil.stripHtml((String)this._rootMessage.getSubject());
    }

    public String getType() {
        return TYPE;
    }

    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        httpServletRequest.setAttribute("ASSET_HELPER", (Object)this._assetHelper);
        MBMessageDisplay messageDisplay = MBMessageServiceUtil.getMessageDisplay((long)this._rootMessage.getMessageId(), (int)8);
        httpServletRequest.setAttribute("MESSAGE_BOARDS_MESSAGE_DISPLAY", (Object)messageDisplay);
        MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER", (Object)treeWalker);
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_CATEGORY", (Object)messageDisplay.getCategory());
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_CUR_MESSAGE", (Object)treeWalker.getRoot());
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_DEPTH", (Object)0);
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_LAST_NODE", (Object)Boolean.FALSE);
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_SEL_MESSAGE", (Object)this._rootMessage);
        httpServletRequest.setAttribute("MESSAGE_BOARDS_TREE_WALKER_THREAD", (Object)messageDisplay.getThread());
        return super.include(httpServletRequest, httpServletResponse, template);
    }
}

