/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class MBDiscussionConstraintResolver
implements ConstraintResolver<MBDiscussion> {
    @Reference
    private MBDiscussionLocalService _mbDiscussionLocalService;

    public String getConflictDescriptionKey() {
        return "duplicate-comment";
    }

    public Class<MBDiscussion> getModelClass() {
        return MBDiscussion.class;
    }

    public String getResolutionDescriptionKey() {
        return "the-conflicting-comment-was-deleted";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundleUtil.getBundle((Locale)locale, MBDiscussionConstraintResolver.class);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"classNameId", "classPK"};
    }

    public void resolveConflict(ConstraintResolverContext<MBDiscussion> constraintResolverContext) throws PortalException {
        MBDiscussion mbDiscussion = (MBDiscussion)constraintResolverContext.getSourceCTModel();
        this._mbDiscussionLocalService.deleteMBDiscussion(mbDiscussion);
    }
}

