/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.persistence.MBMessageFinder;
import com.liferay.message.boards.service.persistence.MBMessagePersistence;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class MBMessageLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
MBMessageLocalService {
    protected MBMessageLocalService mbMessageLocalService;
    @Reference
    protected MBMessagePersistence mbMessagePersistence;
    @Reference
    protected MBMessageFinder mbMessageFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public MBMessage addMBMessage(MBMessage mbMessage) {
        mbMessage.setNew(true);
        return (MBMessage)this.mbMessagePersistence.update((BaseModel)mbMessage);
    }

    @Transactional(enabled=false)
    public MBMessage createMBMessage(long messageId) {
        return this.mbMessagePersistence.create(messageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteMBMessage(long messageId) throws PortalException {
        return this.mbMessagePersistence.remove(messageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteMBMessage(MBMessage mbMessage) {
        return (MBMessage)this.mbMessagePersistence.remove((BaseModel)mbMessage);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.mbMessagePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(MBMessage.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.mbMessagePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.mbMessagePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.mbMessagePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.mbMessagePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.mbMessagePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public MBMessage fetchMBMessage(long messageId) {
        return this.mbMessagePersistence.fetchByPrimaryKey(messageId);
    }

    public MBMessage fetchMBMessageByUuidAndGroupId(String uuid, long groupId) {
        return this.mbMessagePersistence.fetchByUUID_G(uuid, groupId);
    }

    public MBMessage fetchMBMessageByExternalReferenceCode(String externalReferenceCode, long groupId) {
        return this.mbMessagePersistence.fetchByERC_G(externalReferenceCode, groupId);
    }

    public MBMessage getMBMessageByExternalReferenceCode(String externalReferenceCode, long groupId) throws PortalException {
        return this.mbMessagePersistence.findByERC_G(externalReferenceCode, groupId);
    }

    public MBMessage getMBMessage(long messageId) throws PortalException {
        return this.mbMessagePersistence.findByPrimaryKey(messageId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mbMessageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MBMessage.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("messageId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mbMessageLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(MBMessage.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("messageId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.mbMessageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(MBMessage.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("messageId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)MBMessage.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBMessage>(){

            public void performAction(MBMessage mbMessage) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)mbMessage);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)MBMessage.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.mbMessagePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement MBMessageLocalServiceImpl#deleteMBMessage(MBMessage) to avoid orphaned data");
        }
        return this.mbMessageLocalService.deleteMBMessage((MBMessage)persistedModel);
    }

    public BasePersistence<MBMessage> getBasePersistence() {
        return this.mbMessagePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.mbMessagePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<MBMessage> getMBMessagesByUuidAndCompanyId(String uuid, long companyId) {
        return this.mbMessagePersistence.findByUuid_C(uuid, companyId);
    }

    public List<MBMessage> getMBMessagesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<MBMessage> orderByComparator) {
        return this.mbMessagePersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public MBMessage getMBMessageByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.mbMessagePersistence.findByUUID_G(uuid, groupId);
    }

    public List<MBMessage> getMBMessages(int start, int end) {
        return this.mbMessagePersistence.findAll(start, end);
    }

    public int getMBMessagesCount() {
        return this.mbMessagePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public MBMessage updateMBMessage(MBMessage mbMessage) {
        return (MBMessage)this.mbMessagePersistence.update((BaseModel)mbMessage);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{MBMessageLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.mbMessageLocalService = (MBMessageLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return MBMessageLocalService.class.getName();
    }

    public CTPersistence<MBMessage> getCTPersistence() {
        return this.mbMessagePersistence;
    }

    public Class<MBMessage> getModelClass() {
        return MBMessage.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<MBMessage>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.mbMessagePersistence);
    }

    protected String getModelClassName() {
        return MBMessage.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.mbMessagePersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

