/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search.spi.model.index.contributor;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.IndexerWriterMode;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;

public class MBCategoryModelIndexerWriterContributor
implements ModelIndexerWriterContributor<MBCategory> {
    private static final Log _log = LogFactoryUtil.getLog(MBCategoryModelIndexerWriterContributor.class);
    private final DynamicQueryBatchIndexingActionableFactory _dynamicQueryBatchIndexingActionableFactory;
    private final MBCategoryLocalService _mbCategoryLocalService;

    public MBCategoryModelIndexerWriterContributor(DynamicQueryBatchIndexingActionableFactory dynamicQueryBatchIndexingActionableFactory, MBCategoryLocalService mbCategoryLocalService) {
        this._dynamicQueryBatchIndexingActionableFactory = dynamicQueryBatchIndexingActionableFactory;
        this._mbCategoryLocalService = mbCategoryLocalService;
    }

    public void customize(BatchIndexingActionable batchIndexingActionable, ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {
        batchIndexingActionable.setAddCriteriaMethod(dynamicQuery -> {
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.in((Object[])new Integer[]{0, 8}));
        });
        batchIndexingActionable.setPerformActionMethod(mbCategory -> {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Reindexing message boards categories for ", "category ID ", mbCategory.getCategoryId(), " and group ID ", mbCategory.getGroupId()}));
            }
            batchIndexingActionable.addDocuments(new Document[]{modelIndexerWriterDocumentHelper.getDocument((BaseModel)mbCategory)});
        });
    }

    public BatchIndexingActionable getBatchIndexingActionable() {
        return this._dynamicQueryBatchIndexingActionableFactory.getBatchIndexingActionable(this._mbCategoryLocalService.getIndexableActionableDynamicQuery());
    }

    public long getCompanyId(MBCategory mbCategory) {
        return mbCategory.getCompanyId();
    }

    public IndexerWriterMode getIndexerWriterMode(MBCategory mbCategory) {
        int status = mbCategory.getStatus();
        if (status == 0 || status == 8) {
            return IndexerWriterMode.UPDATE;
        }
        return IndexerWriterMode.DELETE;
    }
}

