/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBThreadFlag;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadFlagLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class MBThreadFlagStagedModelDataHandler
extends BaseStagedModelDataHandler<MBThreadFlag> {
    public static final String[] CLASS_NAMES = new String[]{MBThreadFlag.class.getName()};
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadFlagLocalService _mbThreadFlagLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void deleteStagedModel(MBThreadFlag threadFlag) {
        this._mbThreadFlagLocalService.deleteThreadFlag(threadFlag);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) {
        MBThreadFlag threadFlag = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (threadFlag != null) {
            this.deleteStagedModel(threadFlag);
        }
    }

    public MBThreadFlag fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mbThreadFlagLocalService.fetchMBThreadFlagByUuidAndGroupId(uuid, groupId);
    }

    public List<MBThreadFlag> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mbThreadFlagLocalService.getMBThreadFlagsByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBThreadFlag threadFlag) throws Exception {
        MBThread thread = this._mbThreadLocalService.getThread(threadFlag.getThreadId());
        MBMessage rootMessage = this._mbMessageLocalService.getMessage(thread.getRootMessageId());
        if (rootMessage.getStatus() != 0 || rootMessage.getCategoryId() == -1L) {
            return;
        }
        StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)rootMessage);
        Element threadFlagElement = portletDataContext.getExportDataElement((ClassedModel)threadFlag);
        threadFlagElement.addAttribute("root-message-id", String.valueOf(rootMessage.getMessageId()));
        portletDataContext.addClassedModel(threadFlagElement, ExportImportPathUtil.getModelPath((StagedModel)threadFlag), (ClassedModel)threadFlag);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBThreadFlag threadFlag) throws Exception {
        User user = this._userLocalService.fetchUserByUuidAndCompanyId(threadFlag.getUserUuid(), portletDataContext.getCompanyId());
        if (user == null) {
            return;
        }
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)threadFlag);
        long rootMessageId = GetterUtil.getLong((String)element.attributeValue("root-message-id"));
        String rootMessagePath = ExportImportPathUtil.getModelPath((PortletDataContext)portletDataContext, (String)MBMessage.class.getName(), (long)rootMessageId);
        MBMessage rootMessage = (MBMessage)portletDataContext.getZipEntryAsObject(element, rootMessagePath);
        StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (StagedModel)rootMessage);
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        long threadId = MapUtil.getLong((Map)threadIds, (long)threadFlag.getThreadId(), (long)threadFlag.getThreadId());
        MBThread thread = this._mbThreadLocalService.fetchThread(threadId);
        if (thread == null) {
            return;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)threadFlag);
        serviceContext.setUuid(threadFlag.getUuid());
        this._mbThreadFlagLocalService.addThreadFlag(user.getUserId(), thread, serviceContext);
    }
}

