/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.message.boards.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.message.boards.model.MBSuspiciousActivity;
import com.liferay.message.boards.model.MBSuspiciousActivityModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MBSuspiciousActivity service. Represents a row in the &quot;MBSuspiciousActivity&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MBSuspiciousActivityModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MBSuspiciousActivityImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see MBSuspiciousActivityImpl
 * @generated
 */
@JSON(strict = true)
public class MBSuspiciousActivityModelImpl
	extends BaseModelImpl<MBSuspiciousActivity>
	implements MBSuspiciousActivityModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a message boards suspicious activity model instance should use the <code>MBSuspiciousActivity</code> interface instead.
	 */
	public static final String TABLE_NAME = "MBSuspiciousActivity";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"ctCollectionId", Types.BIGINT},
		{"uuid_", Types.VARCHAR}, {"suspiciousActivityId", Types.BIGINT},
		{"groupId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"messageId", Types.BIGINT}, {"threadId", Types.BIGINT},
		{"reason", Types.VARCHAR}, {"validated", Types.BOOLEAN}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("ctCollectionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("suspiciousActivityId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("messageId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("threadId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("reason", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("validated", Types.BOOLEAN);
	}

	public static final String TABLE_SQL_CREATE =
		"create table MBSuspiciousActivity (mvccVersion LONG default 0 not null,ctCollectionId LONG default 0 not null,uuid_ VARCHAR(75) null,suspiciousActivityId LONG not null,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,messageId LONG,threadId LONG,reason VARCHAR(255) null,validated BOOLEAN,primary key (suspiciousActivityId, ctCollectionId))";

	public static final String TABLE_SQL_DROP =
		"drop table MBSuspiciousActivity";

	public static final String ORDER_BY_JPQL =
		" ORDER BY mbSuspiciousActivity.suspiciousActivityId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY MBSuspiciousActivity.suspiciousActivityId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MESSAGEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long THREADID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SUSPICIOUSACTIVITYID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public MBSuspiciousActivityModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _suspiciousActivityId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSuspiciousActivityId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _suspiciousActivityId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MBSuspiciousActivity.class;
	}

	@Override
	public String getModelClassName() {
		return MBSuspiciousActivity.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MBSuspiciousActivity, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MBSuspiciousActivity, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBSuspiciousActivity, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((MBSuspiciousActivity)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MBSuspiciousActivity, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MBSuspiciousActivity, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MBSuspiciousActivity)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MBSuspiciousActivity, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MBSuspiciousActivity, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map<String, Function<MBSuspiciousActivity, Object>>
			_attributeGetterFunctions;

		static {
			Map<String, Function<MBSuspiciousActivity, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String, Function<MBSuspiciousActivity, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", MBSuspiciousActivity::getMvccVersion);
			attributeGetterFunctions.put(
				"ctCollectionId", MBSuspiciousActivity::getCtCollectionId);
			attributeGetterFunctions.put("uuid", MBSuspiciousActivity::getUuid);
			attributeGetterFunctions.put(
				"suspiciousActivityId",
				MBSuspiciousActivity::getSuspiciousActivityId);
			attributeGetterFunctions.put(
				"groupId", MBSuspiciousActivity::getGroupId);
			attributeGetterFunctions.put(
				"companyId", MBSuspiciousActivity::getCompanyId);
			attributeGetterFunctions.put(
				"userId", MBSuspiciousActivity::getUserId);
			attributeGetterFunctions.put(
				"userName", MBSuspiciousActivity::getUserName);
			attributeGetterFunctions.put(
				"createDate", MBSuspiciousActivity::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", MBSuspiciousActivity::getModifiedDate);
			attributeGetterFunctions.put(
				"messageId", MBSuspiciousActivity::getMessageId);
			attributeGetterFunctions.put(
				"threadId", MBSuspiciousActivity::getThreadId);
			attributeGetterFunctions.put(
				"reason", MBSuspiciousActivity::getReason);
			attributeGetterFunctions.put(
				"validated", MBSuspiciousActivity::getValidated);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<MBSuspiciousActivity, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<MBSuspiciousActivity, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<MBSuspiciousActivity, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setMvccVersion);
			attributeSetterBiConsumers.put(
				"ctCollectionId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setCtCollectionId);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<MBSuspiciousActivity, String>)
					MBSuspiciousActivity::setUuid);
			attributeSetterBiConsumers.put(
				"suspiciousActivityId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setSuspiciousActivityId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<MBSuspiciousActivity, String>)
					MBSuspiciousActivity::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<MBSuspiciousActivity, Date>)
					MBSuspiciousActivity::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<MBSuspiciousActivity, Date>)
					MBSuspiciousActivity::setModifiedDate);
			attributeSetterBiConsumers.put(
				"messageId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setMessageId);
			attributeSetterBiConsumers.put(
				"threadId",
				(BiConsumer<MBSuspiciousActivity, Long>)
					MBSuspiciousActivity::setThreadId);
			attributeSetterBiConsumers.put(
				"reason",
				(BiConsumer<MBSuspiciousActivity, String>)
					MBSuspiciousActivity::setReason);
			attributeSetterBiConsumers.put(
				"validated",
				(BiConsumer<MBSuspiciousActivity, Boolean>)
					MBSuspiciousActivity::setValidated);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public long getCtCollectionId() {
		return _ctCollectionId;
	}

	@Override
	public void setCtCollectionId(long ctCollectionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_ctCollectionId = ctCollectionId;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getSuspiciousActivityId() {
		return _suspiciousActivityId;
	}

	@Override
	public void setSuspiciousActivityId(long suspiciousActivityId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_suspiciousActivityId = suspiciousActivityId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getMessageId() {
		return _messageId;
	}

	@Override
	public void setMessageId(long messageId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_messageId = messageId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalMessageId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("messageId"));
	}

	@JSON
	@Override
	public long getThreadId() {
		return _threadId;
	}

	@Override
	public void setThreadId(long threadId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_threadId = threadId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalThreadId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("threadId"));
	}

	@JSON
	@Override
	public String getReason() {
		if (_reason == null) {
			return "";
		}
		else {
			return _reason;
		}
	}

	@Override
	public void setReason(String reason) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_reason = reason;
	}

	@JSON
	@Override
	public boolean getValidated() {
		return _validated;
	}

	@JSON
	@Override
	public boolean isValidated() {
		return _validated;
	}

	@Override
	public void setValidated(boolean validated) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_validated = validated;
	}

	@Override
	public long getContainerModelId() {
		return getSuspiciousActivityId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_suspiciousActivityId = containerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getContainerModelId());
	}

	@Override
	public long getParentContainerModelId() {
		return 0;
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(MBSuspiciousActivity.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MBSuspiciousActivity.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MBSuspiciousActivity toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MBSuspiciousActivity>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MBSuspiciousActivityImpl mbSuspiciousActivityImpl =
			new MBSuspiciousActivityImpl();

		mbSuspiciousActivityImpl.setMvccVersion(getMvccVersion());
		mbSuspiciousActivityImpl.setCtCollectionId(getCtCollectionId());
		mbSuspiciousActivityImpl.setUuid(getUuid());
		mbSuspiciousActivityImpl.setSuspiciousActivityId(
			getSuspiciousActivityId());
		mbSuspiciousActivityImpl.setGroupId(getGroupId());
		mbSuspiciousActivityImpl.setCompanyId(getCompanyId());
		mbSuspiciousActivityImpl.setUserId(getUserId());
		mbSuspiciousActivityImpl.setUserName(getUserName());
		mbSuspiciousActivityImpl.setCreateDate(getCreateDate());
		mbSuspiciousActivityImpl.setModifiedDate(getModifiedDate());
		mbSuspiciousActivityImpl.setMessageId(getMessageId());
		mbSuspiciousActivityImpl.setThreadId(getThreadId());
		mbSuspiciousActivityImpl.setReason(getReason());
		mbSuspiciousActivityImpl.setValidated(isValidated());

		mbSuspiciousActivityImpl.resetOriginalValues();

		return mbSuspiciousActivityImpl;
	}

	@Override
	public MBSuspiciousActivity cloneWithOriginalValues() {
		MBSuspiciousActivityImpl mbSuspiciousActivityImpl =
			new MBSuspiciousActivityImpl();

		mbSuspiciousActivityImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		mbSuspiciousActivityImpl.setCtCollectionId(
			this.<Long>getColumnOriginalValue("ctCollectionId"));
		mbSuspiciousActivityImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		mbSuspiciousActivityImpl.setSuspiciousActivityId(
			this.<Long>getColumnOriginalValue("suspiciousActivityId"));
		mbSuspiciousActivityImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		mbSuspiciousActivityImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		mbSuspiciousActivityImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		mbSuspiciousActivityImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		mbSuspiciousActivityImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		mbSuspiciousActivityImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		mbSuspiciousActivityImpl.setMessageId(
			this.<Long>getColumnOriginalValue("messageId"));
		mbSuspiciousActivityImpl.setThreadId(
			this.<Long>getColumnOriginalValue("threadId"));
		mbSuspiciousActivityImpl.setReason(
			this.<String>getColumnOriginalValue("reason"));
		mbSuspiciousActivityImpl.setValidated(
			this.<Boolean>getColumnOriginalValue("validated"));

		return mbSuspiciousActivityImpl;
	}

	@Override
	public int compareTo(MBSuspiciousActivity mbSuspiciousActivity) {
		long primaryKey = mbSuspiciousActivity.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MBSuspiciousActivity)) {
			return false;
		}

		MBSuspiciousActivity mbSuspiciousActivity =
			(MBSuspiciousActivity)object;

		long primaryKey = mbSuspiciousActivity.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MBSuspiciousActivity> toCacheModel() {
		MBSuspiciousActivityCacheModel mbSuspiciousActivityCacheModel =
			new MBSuspiciousActivityCacheModel();

		mbSuspiciousActivityCacheModel.mvccVersion = getMvccVersion();

		mbSuspiciousActivityCacheModel.ctCollectionId = getCtCollectionId();

		mbSuspiciousActivityCacheModel.uuid = getUuid();

		String uuid = mbSuspiciousActivityCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			mbSuspiciousActivityCacheModel.uuid = null;
		}

		mbSuspiciousActivityCacheModel.suspiciousActivityId =
			getSuspiciousActivityId();

		mbSuspiciousActivityCacheModel.groupId = getGroupId();

		mbSuspiciousActivityCacheModel.companyId = getCompanyId();

		mbSuspiciousActivityCacheModel.userId = getUserId();

		mbSuspiciousActivityCacheModel.userName = getUserName();

		String userName = mbSuspiciousActivityCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			mbSuspiciousActivityCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			mbSuspiciousActivityCacheModel.createDate = createDate.getTime();
		}
		else {
			mbSuspiciousActivityCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			mbSuspiciousActivityCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			mbSuspiciousActivityCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		mbSuspiciousActivityCacheModel.messageId = getMessageId();

		mbSuspiciousActivityCacheModel.threadId = getThreadId();

		mbSuspiciousActivityCacheModel.reason = getReason();

		String reason = mbSuspiciousActivityCacheModel.reason;

		if ((reason != null) && (reason.length() == 0)) {
			mbSuspiciousActivityCacheModel.reason = null;
		}

		mbSuspiciousActivityCacheModel.validated = isValidated();

		return mbSuspiciousActivityCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MBSuspiciousActivity, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MBSuspiciousActivity, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MBSuspiciousActivity, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(MBSuspiciousActivity)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, MBSuspiciousActivity>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					MBSuspiciousActivity.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _ctCollectionId;
	private String _uuid;
	private long _suspiciousActivityId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _messageId;
	private long _threadId;
	private String _reason;
	private boolean _validated;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<MBSuspiciousActivity, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((MBSuspiciousActivity)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("ctCollectionId", _ctCollectionId);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"suspiciousActivityId", _suspiciousActivityId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("messageId", _messageId);
		_columnOriginalValues.put("threadId", _threadId);
		_columnOriginalValues.put("reason", _reason);
		_columnOriginalValues.put("validated", _validated);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("ctCollectionId", 2L);

		columnBitmasks.put("uuid_", 4L);

		columnBitmasks.put("suspiciousActivityId", 8L);

		columnBitmasks.put("groupId", 16L);

		columnBitmasks.put("companyId", 32L);

		columnBitmasks.put("userId", 64L);

		columnBitmasks.put("userName", 128L);

		columnBitmasks.put("createDate", 256L);

		columnBitmasks.put("modifiedDate", 512L);

		columnBitmasks.put("messageId", 1024L);

		columnBitmasks.put("threadId", 2048L);

		columnBitmasks.put("reason", 4096L);

		columnBitmasks.put("validated", 8192L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private MBSuspiciousActivity _escapedModel;

}