/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.messaging;

import com.liferay.mail.kernel.model.Account;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.internal.messaging.MailingListRequest;
import com.liferay.message.boards.internal.util.MBMailMessage;
import com.liferay.message.boards.internal.util.MBMailUtil;
import com.liferay.message.boards.internal.util.MailingListThreadLocal;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlParser;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/message_boards_mailing_list"}, service={MessageListener.class})
public class MailingListMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MailingListMessageListener.class);
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private HtmlParser _htmlParser;
    @Reference
    private MailService _mailService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBMessageService _mbMessageService;
    @Reference
    private Portal _portal;
    private ServiceRegistration<Destination> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("parallel", "liferay/message_boards_mailing_list"));
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReceive(Message message) throws Exception {
        MailingListRequest mailingListRequest = (MailingListRequest)message.getPayload();
        Store store = null;
        Folder folder = null;
        javax.mail.Message[] messages = null;
        try {
            store = this._getStore(mailingListRequest);
            store.connect();
            folder = this._getFolder(store);
            messages = folder.getMessages();
            this._processMessages(mailingListRequest, messages);
        }
        finally {
            block20: {
                block19: {
                    if (folder != null && folder.isOpen()) {
                        block18: {
                            try {
                                folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                            }
                            catch (Exception exception) {
                                if (!_log.isDebugEnabled()) break block18;
                                _log.debug((Throwable)exception);
                            }
                        }
                        try {
                            folder.close(true);
                        }
                        catch (Exception exception) {
                            if (!_log.isDebugEnabled()) break block19;
                            _log.debug((Throwable)exception);
                        }
                    }
                }
                if (store != null && store.isConnected()) {
                    try {
                        store.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!_log.isDebugEnabled()) break block20;
                        _log.debug((Throwable)messagingException);
                    }
                }
            }
        }
    }

    private Folder _getFolder(Store store) throws Exception {
        Folder folder = store.getFolder("INBOX");
        if (!folder.exists()) {
            throw new MessagingException("Inbox not found");
        }
        folder.open(2);
        return folder;
    }

    private Store _getStore(MailingListRequest mailingListRequest) throws Exception {
        String protocol = mailingListRequest.getInProtocol();
        String host = mailingListRequest.getInServerName();
        int port = mailingListRequest.getInServerPort();
        String user = mailingListRequest.getInUserName();
        String password = mailingListRequest.getInPassword();
        Account account = Account.getInstance((String)protocol, (int)port);
        account.setHost(host);
        account.setPort(port);
        account.setUser(user);
        account.setPassword(password);
        Session session = this._mailService.getSession(account);
        URLName urlName = new URLName(protocol, host, port, "", user, password);
        return session.getStore(urlName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processMessage(MailingListRequest mailingListRequest, javax.mail.Message mailMessage) throws Exception {
        if (MBMailUtil.hasMailIdHeader(mailMessage)) {
            return;
        }
        String from = null;
        Object[] addresses = mailMessage.getFrom();
        if (ArrayUtil.isNotEmpty((Object[])addresses)) {
            Object address = addresses[0];
            if (address instanceof InternetAddress) {
                InternetAddress internetAddress = (InternetAddress)address;
                from = internetAddress.getAddress();
            } else {
                from = address.toString();
            }
        }
        long companyId = mailingListRequest.getCompanyId();
        long categoryId = mailingListRequest.getCategoryId();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Category id " + categoryId));
        }
        boolean anonymous = false;
        User user = this._userLocalService.fetchUserByEmailAddress(companyId, from);
        if (user == null) {
            if (!mailingListRequest.isAllowAnonymous()) {
                return;
            }
            anonymous = true;
            user = this._userLocalService.getUserById(companyId, mailingListRequest.getUserId());
        }
        long parentMessageId = MBMailUtil.getParentMessageId(mailMessage);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parent message id " + parentMessageId));
        }
        MBMessage parentMessage = null;
        if (parentMessageId > 0L) {
            parentMessage = this._mbMessageLocalService.fetchMBMessage(parentMessageId);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Parent message " + parentMessage));
        }
        MBMailMessage mbMailMessage = new MBMailMessage();
        MBMailUtil.collectPartContent((Part)mailMessage, mbMailMessage);
        PermissionCheckerUtil.setThreadValues((User)user);
        MailingListThreadLocal.setSourceMailingList(true);
        String subject = MBMailUtil.getSubjectWithoutMessageId(mailMessage);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        long groupId = mailingListRequest.getGroupId();
        serviceContext.setLayoutFullURL(this._portal.getLayoutFullURL(groupId, PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW)));
        serviceContext.setScopeGroupId(groupId);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
        try {
            if (parentMessage == null) {
                this._mbMessageService.addMessage(groupId, categoryId, subject, mbMailMessage.getBody(this._htmlParser), MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, anonymous, 0.0, true, serviceContext);
            } else {
                this._mbMessageService.addMessage(parentMessage.getMessageId(), subject, mbMailMessage.getBody(this._htmlParser), MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, anonymous, 0.0, true, serviceContext);
            }
        }
        finally {
            for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
                try {
                    InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)ioException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processMessages(MailingListRequest mailingListRequest, javax.mail.Message[] messages) throws Exception {
        for (javax.mail.Message message : messages) {
            try {
                this._processMessage(mailingListRequest, message);
            }
            finally {
                PermissionCheckerUtil.setThreadValues(null);
            }
        }
    }
}

