/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.internal.util.MBUserRankUtil;
import com.liferay.message.boards.model.MBStatsUser;
import com.liferay.message.boards.model.MBThreadTable;
import com.liferay.message.boards.service.base.MBStatsUserLocalServiceBaseImpl;
import com.liferay.message.boards.service.persistence.MBMessagePersistence;
import com.liferay.message.boards.service.persistence.MBThreadPersistence;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBStatsUser"}, service={AopService.class})
public class MBStatsUserLocalServiceImpl
extends MBStatsUserLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MBStatsUserLocalServiceImpl.class);
    @Reference
    private MBMessagePersistence _mbMessagePersistence;
    @Reference
    private MBThreadPersistence _mbThreadPersistence;

    public MBStatsUser addStatsUser(long groupId, long userId) {
        MBStatsUser statsUser;
        block3: {
            long statsUserId = this.counterLocalService.increment();
            statsUser = this.mbStatsUserPersistence.create(statsUserId);
            statsUser.setGroupId(groupId);
            statsUser.setUserId(userId);
            try {
                statsUser = (MBStatsUser)this.mbStatsUserPersistence.update((BaseModel)statsUser);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {groupId=", groupId, ", userId=", userId, "}"}));
                }
                if ((statsUser = this.mbStatsUserPersistence.fetchByG_U(groupId, userId, false)) != null) break block3;
                throw systemException;
            }
        }
        return statsUser;
    }

    public void deleteStatsUser(long statsUserId) throws PortalException {
        MBStatsUser statsUser = this.mbStatsUserPersistence.findByPrimaryKey(statsUserId);
        this.deleteStatsUser(statsUser);
    }

    public void deleteStatsUser(MBStatsUser statsUser) {
        this.mbStatsUserPersistence.remove((BaseModel)statsUser);
    }

    public void deleteStatsUsersByGroupId(long groupId) {
        List statsUsers = this.mbStatsUserPersistence.findByGroupId(groupId);
        for (MBStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public void deleteStatsUsersByUserId(long userId) {
        List statsUsers = this.mbStatsUserPersistence.findByUserId(userId);
        for (MBStatsUser statsUser : statsUsers) {
            this.deleteStatsUser(statsUser);
        }
    }

    public Date getLastPostDateByUserId(long groupId, long userId) {
        List results = (List)this._mbThreadPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.max((Expression)MBThreadTable.INSTANCE.lastPostDate).as("maxLastPostDate")}).from((Table)MBThreadTable.INSTANCE).where(MBThreadTable.INSTANCE.userId.eq((Object)userId).and((Expression)MBThreadTable.INSTANCE.status.neq((Object)8))));
        return (Date)results.get(0);
    }

    public long getMessageCountByGroupId(long groupId) {
        DynamicQuery dynamicQuery = this.mbStatsUserLocalService.dynamicQuery();
        dynamicQuery.setProjection(ProjectionFactoryUtil.sum((String)"messageCount"));
        Property property = PropertyFactoryUtil.forName((String)"groupId");
        dynamicQuery.add(property.eq((Object)groupId));
        List results = this.mbStatsUserLocalService.dynamicQuery(dynamicQuery);
        if (results.get(0) == null) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    public long getMessageCountByUserId(long userId) {
        DynamicQuery dynamicQuery = this.mbStatsUserLocalService.dynamicQuery();
        dynamicQuery.setProjection(ProjectionFactoryUtil.sum((String)"messageCount"));
        Property property = PropertyFactoryUtil.forName((String)"userId");
        dynamicQuery.add(property.eq((Object)userId));
        List results = this.mbStatsUserLocalService.dynamicQuery(dynamicQuery);
        if (results.get(0) == null) {
            return 0L;
        }
        return (Long)results.get(0);
    }

    public MBStatsUser getStatsUser(long groupId, long userId) {
        MBStatsUser statsUser = this.mbStatsUserPersistence.fetchByG_U(groupId, userId);
        if (statsUser == null) {
            statsUser = this.mbStatsUserLocalService.addStatsUser(groupId, userId);
        }
        return statsUser;
    }

    public List<MBStatsUser> getStatsUsersByGroupId(long groupId, int start, int end) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        return this.mbStatsUserPersistence.findByG_NotU_NotM(groupId, defaultUserId, 0, start, end);
    }

    public int getStatsUsersByGroupIdCount(long groupId) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        return this.mbStatsUserPersistence.countByG_NotU_NotM(groupId, defaultUserId, 0);
    }

    public List<MBStatsUser> getStatsUsersByUserId(long userId) {
        return this.mbStatsUserPersistence.findByUserId(userId);
    }

    public String[] getUserRank(long groupId, String languageId, long userId) throws PortalException {
        return MBUserRankUtil.getUserRank(MBGroupServiceSettings.getInstance((long)groupId), languageId, this.getStatsUser(groupId, userId));
    }

    public MBStatsUser updateStatsUser(long groupId, long userId) {
        return this.updateStatsUser(groupId, userId, this.getLastPostDateByUserId(groupId, userId));
    }

    public MBStatsUser updateStatsUser(long groupId, long userId, Date lastPostDate) {
        int messageCount = this._mbMessagePersistence.countByG_U_S(groupId, userId, 0);
        return this.updateStatsUser(groupId, userId, messageCount, lastPostDate);
    }

    public MBStatsUser updateStatsUser(long groupId, long userId, int messageCount, Date lastPostDate) {
        MBStatsUser statsUser = this.getStatsUser(groupId, userId);
        statsUser.setMessageCount(messageCount);
        if (lastPostDate != null) {
            statsUser.setLastPostDate(lastPostDate);
        }
        return (MBStatsUser)this.mbStatsUserPersistence.update((BaseModel)statsUser);
    }
}

