/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.exception.MailingListEmailAddressException;
import com.liferay.message.boards.exception.MailingListInServerNameException;
import com.liferay.message.boards.exception.MailingListInUserNameException;
import com.liferay.message.boards.exception.MailingListOutEmailAddressException;
import com.liferay.message.boards.exception.MailingListOutServerNameException;
import com.liferay.message.boards.exception.MailingListOutUserNameException;
import com.liferay.message.boards.internal.messaging.MailingListRequest;
import com.liferay.message.boards.model.MBMailingList;
import com.liferay.message.boards.service.base.MBMailingListLocalServiceBaseImpl;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.json.jabsorb.serializer.LiferayJSONDeserializationWhitelist;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.proxy.ProxyModeThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Closeable;
import java.util.Calendar;
import java.util.Date;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBMailingList"}, service={AopService.class})
public class MBMailingListLocalServiceImpl
extends MBMailingListLocalServiceBaseImpl {
    @Reference
    private LiferayJSONDeserializationWhitelist _liferayJSONDeserializationWhitelist;
    private Closeable _unregister;
    @Reference
    private UserLocalService _userLocalService;

    public MBMailingList addMailingList(long userId, long groupId, long categoryId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        long mailingListId = this.counterLocalService.increment();
        MBMailingList mailingList = this.mbMailingListPersistence.create(mailingListId);
        mailingList.setUuid(serviceContext.getUuid());
        mailingList.setGroupId(groupId);
        mailingList.setCompanyId(user.getCompanyId());
        mailingList.setUserId(user.getUserId());
        mailingList.setUserName(user.getFullName());
        mailingList.setCategoryId(categoryId);
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? inProtocol + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setAllowAnonymous(allowAnonymous);
        mailingList.setActive(active);
        mailingList = (MBMailingList)this.mbMailingListPersistence.update((BaseModel)mailingList);
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    public void deleteCategoryMailingList(long groupId, long categoryId) throws PortalException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByG_C(groupId, categoryId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(long mailingListId) throws PortalException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(MBMailingList mailingList) throws PortalException {
        this.unscheduleMailingList(mailingList);
        this.mbMailingListPersistence.remove((BaseModel)mailingList);
    }

    public MBMailingList fetchCategoryMailingList(long groupId, long categoryId) {
        return this.mbMailingListPersistence.fetchByG_C(groupId, categoryId);
    }

    public MBMailingList getCategoryMailingList(long groupId, long categoryId) throws PortalException {
        return this.mbMailingListPersistence.findByG_C(groupId, categoryId);
    }

    public MBMailingList updateMailingList(long mailingListId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean active, ServiceContext serviceContext) throws PortalException {
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? inProtocol + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setAllowAnonymous(allowAnonymous);
        mailingList.setActive(active);
        mailingList = (MBMailingList)this.mbMailingListPersistence.update((BaseModel)mailingList);
        if (active) {
            try (SafeCloseable safeCloseable = ProxyModeThreadLocal.setWithSafeCloseable((boolean)true);){
                this.unscheduleMailingList(mailingList);
                this.scheduleMailingList(mailingList);
            }
        } else {
            this.unscheduleMailingList(mailingList);
        }
        return mailingList;
    }

    @Activate
    protected void activate() {
        this._unregister = this._liferayJSONDeserializationWhitelist.register(new String[]{MailingListRequest.class.getName()});
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        try {
            this._unregister.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected String getSchedulerGroupName(MBMailingList mailingList) {
        return StringBundler.concat((Object[])new Object[]{"liferay/message_boards_mailing_list", "/", mailingList.getMailingListId()});
    }

    protected void scheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        Calendar startDate = CalendarFactoryUtil.getCalendar();
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)groupName, (String)groupName, (Date)startDate.getTime(), (int)mailingList.getInReadInterval(), (TimeUnit)TimeUnit.MINUTE);
        MailingListRequest mailingListRequest = new MailingListRequest();
        mailingListRequest.setCompanyId(mailingList.getCompanyId());
        mailingListRequest.setUserId(mailingList.getUserId());
        mailingListRequest.setGroupId(mailingList.getGroupId());
        mailingListRequest.setCategoryId(mailingList.getCategoryId());
        mailingListRequest.setInProtocol(mailingList.getInProtocol());
        mailingListRequest.setInServerName(mailingList.getInServerName());
        mailingListRequest.setInServerPort(mailingList.getInServerPort());
        mailingListRequest.setInUseSSL(mailingList.isInUseSSL());
        mailingListRequest.setInUserName(mailingList.getInUserName());
        mailingListRequest.setInPassword(mailingList.getInPassword());
        mailingListRequest.setAllowAnonymous(mailingList.isAllowAnonymous());
        Message message = new Message();
        message.put("companyId", (Object)mailingList.getCompanyId());
        message.setPayload((Object)mailingListRequest);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, null, (String)"liferay/message_boards_mailing_list", (Message)message, (int)0);
    }

    protected void unscheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
    }

    protected void validate(String emailAddress, String inServerName, String inUserName, String outEmailAddress, boolean outCustom, String outServerName, String outUserName, boolean active) throws PortalException {
        if (!active) {
            return;
        }
        if (!Validator.isEmailAddress((String)emailAddress)) {
            throw new MailingListEmailAddressException(emailAddress);
        }
        if (Validator.isNull((String)inServerName)) {
            throw new MailingListInServerNameException("In server name is null");
        }
        if (Validator.isNull((String)inUserName)) {
            throw new MailingListInUserNameException("In user name is null");
        }
        if (Validator.isNull((String)outEmailAddress)) {
            throw new MailingListOutEmailAddressException("Out email address is null");
        }
        if (outCustom) {
            if (Validator.isNull((String)outServerName)) {
                throw new MailingListOutServerNameException("Out server name is null");
            }
            if (Validator.isNull((String)outUserName)) {
                throw new MailingListOutUserNameException("Out user name is null");
            }
        }
    }
}

