/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.util;

import com.liferay.message.boards.model.MBStatsUser;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;

public class MBUserRankUtil {
    private static final Log _log = LogFactoryUtil.getLog(MBUserRankUtil.class);

    public static String[] getUserRank(MBGroupServiceSettings mbGroupServiceSettings, String languageId, MBStatsUser statsUser) throws PortalException {
        String[] ranks;
        String[] rank = new String[]{"", ""};
        int maxPosts = 0;
        Group group = GroupLocalServiceUtil.getGroup((long)statsUser.getGroupId());
        long companyId = group.getCompanyId();
        for (String curRank : ranks = mbGroupServiceSettings.getRanks(languageId)) {
            String[] kvp = StringUtil.split((String)curRank, (char)'=');
            String kvpPosts = kvp[1];
            String[] curRankValueKvp = StringUtil.split((String)kvpPosts, (char)':');
            if (curRankValueKvp.length <= 1) {
                int posts = GetterUtil.getInteger((String)kvpPosts);
                if (posts > statsUser.getMessageCount() || posts < maxPosts) continue;
                rank[0] = kvp[0];
                maxPosts = posts;
                continue;
            }
            String entityType = curRankValueKvp[0];
            String entityValue = curRankValueKvp[1];
            try {
                if (!MBUserRankUtil._isEntityRank(companyId, statsUser, entityType, entityValue)) continue;
                rank[1] = kvp[0];
                break;
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)exception, (Throwable)exception);
            }
        }
        return rank;
    }

    private static boolean _isEntityRank(long companyId, MBStatsUser statsUser, String entityType, String entityValue) throws Exception {
        UserGroup userGroup;
        Organization organization;
        long userId = statsUser.getUserId();
        if (entityType.equals("organization-role") || entityType.equals("site-role")) {
            Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)entityValue);
            if (UserGroupRoleLocalServiceUtil.hasUserGroupRole((long)userId, (long)statsUser.getGroupId(), (long)role.getRoleId(), (boolean)true)) {
                return true;
            }
        } else if (entityType.equals("organization") ? OrganizationLocalServiceUtil.hasUserOrganization((long)userId, (long)(organization = OrganizationLocalServiceUtil.getOrganization((long)companyId, (String)entityValue)).getOrganizationId(), (boolean)false, (boolean)false) : (entityType.equals("regular-role") ? RoleLocalServiceUtil.hasUserRole((long)userId, (long)companyId, (String)entityValue, (boolean)true) : entityType.equals("user-group") && UserLocalServiceUtil.hasUserGroupUser((long)(userGroup = UserGroupLocalServiceUtil.getUserGroup((long)companyId, (String)entityValue)).getUserGroupId(), (long)userId))) {
            return true;
        }
        return false;
    }
}

