/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.util;

import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.MimeUtility;

public class MBMailMessage {
    private static final Log _log = LogFactoryUtil.getLog((String)MBMailMessage.class.getName());
    private final List<ObjectValuePair<String, byte[]>> _bytesOVPs = new ArrayList<ObjectValuePair<String, byte[]>>();
    private String _htmlBody;
    private String _plainBody;

    public void addBytes(String fileName, byte[] bytes) {
        block2: {
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to decode file name " + fileName), (Throwable)unsupportedEncodingException);
            }
        }
        this._bytesOVPs.add((ObjectValuePair<String, byte[]>)new ObjectValuePair((Object)fileName, (Object)bytes));
    }

    public String getBody() {
        String body = null;
        if (MBMessageConstants.DEFAULT_FORMAT.equals("bbcode")) {
            if (Validator.isNotNull((String)this._plainBody)) {
                body = GetterUtil.getString((String)this._plainBody);
            } else if (Validator.isNotNull((String)this._htmlBody)) {
                body = HtmlUtil.extractText((String)this._htmlBody);
            }
        } else if (MBMessageConstants.DEFAULT_FORMAT.equals("html")) {
            if (Validator.isNotNull((String)this._htmlBody)) {
                body = GetterUtil.getString((String)this._htmlBody);
            } else if (Validator.isNotNull((String)this._plainBody)) {
                body = GetterUtil.getString((String)this._plainBody);
            }
        }
        if (Validator.isNull(body)) {
            body = "-";
        }
        return body;
    }

    public String getHtmlBody() {
        return this._htmlBody;
    }

    public List<ObjectValuePair<String, InputStream>> getInputStreamOVPs() {
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>(this._bytesOVPs.size());
        for (ObjectValuePair<String, byte[]> bytesOVP : this._bytesOVPs) {
            String key = (String)bytesOVP.getKey();
            byte[] bytes = (byte[])bytesOVP.getValue();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)key, (Object)byteArrayInputStream);
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        return inputStreamOVPs;
    }

    public String getPlainBody() {
        return this._plainBody;
    }

    public void setHtmlBody(String htmlBody) {
        this._htmlBody = htmlBody;
    }

    public void setPlainBody(String plainBody) {
        this._plainBody = plainBody;
    }
}

