/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v3_1_0;

import com.liferay.message.boards.internal.upgrade.v3_1_0.util.MBMessageTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeUrlSubject
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("MBMessage", "urlSubject")) {
            this.alter(MBMessageTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "urlSubject", "VARCHAR(255) null")});
        }
        this.runSQL("create index IX_TEMP on MBMessage (subject[$COLUMN_LENGTH:75$],messageId)");
        this._populateUrlSubject();
        this.runSQL("drop index IX_TEMP on MBMessage");
    }

    private String _getURLSubject(long id, String subject) {
        if (subject == null) {
            return String.valueOf(id);
        }
        subject = Validator.isNull((String)(subject = StringUtil.toLowerCase((String)subject.trim()))) || Validator.isNumber((String)subject) || subject.equals("rss") ? String.valueOf(id) : FriendlyURLNormalizerUtil.normalizeWithPeriodsAndSlashes((String)subject);
        return subject.substring(0, Math.min(subject.length(), 254));
    }

    private void _populateUrlSubject() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select messageId, subject from MBMessage order by subject, messageId asc");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update MBMessage set urlSubject = ? where messageId = ?"));){
            int count = 0;
            String curURLSubject = null;
            String previousURLSubject = null;
            while (rs.next()) {
                long messageId = rs.getLong(1);
                String subject = rs.getString(2);
                curURLSubject = this._getURLSubject(messageId, subject);
                String suffix = null;
                if (StringUtil.equals(previousURLSubject, (String)curURLSubject)) {
                    suffix = "-" + ++count;
                } else {
                    count = 0;
                    previousURLSubject = curURLSubject;
                    suffix = "";
                }
                ps2.setString(1, curURLSubject + suffix);
                ps2.setLong(2, messageId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

