/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v3_0_0;

import com.liferay.message.boards.internal.upgrade.v3_0_0.util.MBMessageTable;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class UpgradeMBMessageTreePath
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        if (!this.hasColumn("MBMessage", "treePath")) {
            this.alter(MBMessageTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "treePath", "STRING null")});
        }
        this._populateTreePath();
    }

    private String _calculatePath(Map<Long, Long> relations, long messageId) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(messageId + "/");
        while (relations.containsKey(messageId)) {
            messageId = relations.get(messageId);
            paths.add(messageId + "/");
        }
        paths.add("/");
        Collections.reverse(paths);
        return StringUtil.merge(paths, (String)"");
    }

    private void _populateTreePath() throws Exception {
        Throwable throwable;
        this.runSQL("update MBMessage set treePath = CONCAT('/', CAST_TEXT(messageId), '/') where parentMessageId = 0");
        this.runSQL("update MBMessage set treePath = CONCAT('/', CAST_TEXT(rootMessageId), '/', CAST_TEXT(messageId), '/') where parentMessageId = rootMessageId");
        HashMap<Long, Long> relations = new HashMap<Long, Long>();
        try (PreparedStatement ps = this.connection.prepareStatement("select messageId, parentMessageId from MBMessage where parentMessageId != 0 order by createDate desc");){
            throwable = null;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    relations.put(rs.getLong(1), rs.getLong(2));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        var3_3 = null;
        try (PreparedStatement ps1 = this.connection.prepareStatement("select messageId from MBMessage where treePath is null or treePath = ''");){
            throwable = null;
            try (PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update MBMessage set treePath = ? where messageId = ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long messageId = rs.getLong(1);
                    ps2.setString(1, this._calculatePath(relations, messageId));
                    ps2.setLong(2, messageId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Throwable throwable4) {
            var3_3 = throwable4;
            throw throwable4;
        }
    }
}

