/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.trash;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.trash.BaseTrashHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.message.boards.model.MBMessage"}, service={TrashHandler.class})
public class MBMessageTrashHandler
extends BaseTrashHandler {
    private MBMessageLocalService _mbMessageLocalService;
    private MBMessageService _mbMessageService;
    private MBThreadLocalService _mbThreadLocalService;
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;

    public void deleteTrashEntry(long classPK) {
    }

    public String getClassName() {
        return MBMessage.class.getName();
    }

    public ContainerModel getContainerModel(long containerModelId) throws PortalException {
        return this._mbThreadLocalService.getThread(containerModelId);
    }

    public String getContainerModelClassName(long classPK) {
        return MBThread.class.getName();
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException {
        MBMessage message = (MBMessage)trashedModel;
        return this.getContainerModel(message.getThreadId());
    }

    public TrashedModel getTrashedModel(long classPK) {
        return this._mbMessageLocalService.fetchMBMessage(classPK);
    }

    public boolean isDeletable() {
        return false;
    }

    public boolean isDeletable(long classPK) throws PortalException {
        return false;
    }

    public void restoreRelatedTrashEntry(String className, long classPK) throws PortalException {
        if (!className.equals(DLFileEntry.class.getName())) {
            return;
        }
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)classPK);
        MBMessage message = this._mbMessageLocalService.getFileEntryMessage(classPK);
        this._mbMessageService.restoreMessageAttachmentFromTrash(message.getMessageId(), fileEntry.getTitle());
    }

    public void restoreTrashEntry(long userId, long classPK) {
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        return this._messageModelResourcePermission.contains(permissionChecker, classPK, actionId);
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }
}

