/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.security.permission.resource;

import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBCategoryModel;
import com.liferay.message.boards.service.MBBanLocalService;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class MBCategoryPermissionRegistrar {
    @Reference
    private MBBanLocalService _mbBanLocalService;
    @Reference
    private MBCategoryLocalService _mbCategoryLocalService;
    @Reference(target="(resource.name=com.liferay.message.boards)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission<MBCategory>> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;

    @Activate
    protected void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", MBCategory.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(MBCategory.class, MBCategoryModel::getCategoryId, arg_0 -> ((MBCategoryLocalService)this._mbCategoryLocalService).getCategory(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept((permissionChecker, name, message, actionId) -> {
                if (this._mbBanLocalService.hasBan(message.getGroupId(), permissionChecker.getUserId())) {
                    return false;
                }
                return null;
            });
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_message_boards_web_portlet_MBPortlet", MBCategoryModel::getCategoryId));
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(modelResourcePermission, this._getFetchParentFunction(), false));
            }
        }, actionId -> {
            if ("ADD_CATEGORY".equals(actionId)) {
                return "ADD_SUBCATEGORY";
            }
            return actionId;
        }), (Dictionary)properties);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<MBCategory, MBCategory, PortalException> _getFetchParentFunction() {
        return category -> {
            long categoryId = category.getParentCategoryId();
            if (0L == categoryId) {
                return null;
            }
            if (category.isInTrash()) {
                return this._mbCategoryLocalService.fetchMBCategory(categoryId);
            }
            return this._mbCategoryLocalService.getCategory(categoryId);
        };
    }
}

