/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MBCategoryStagedModelDataHandler
extends BaseStagedModelDataHandler<MBCategory> {
    public static final String[] CLASS_NAMES = new String[]{MBCategory.class.getName()};
    private MBCategoryLocalService _mbCategoryLocalService;

    public void deleteStagedModel(MBCategory category) throws PortalException {
        this._mbCategoryLocalService.deleteCategory(category);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        MBCategory category = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (category != null) {
            this.deleteStagedModel(category);
        }
    }

    public MBCategory fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mbCategoryLocalService.fetchMBCategoryByUuidAndGroupId(uuid, groupId);
    }

    public List<MBCategory> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mbCategoryLocalService.getMBCategoriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBCategory category) {
        return category.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        if (category.getCategoryId() == 0L || category.getCategoryId() == -1L) {
            return;
        }
        if (category.getParentCategory() != null) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)category, (StagedModel)category.getParentCategory(), (String)"parent");
        }
        Element categoryElement = portletDataContext.getExportDataElement((ClassedModel)category);
        portletDataContext.addClassedModel(categoryElement, ExportImportPathUtil.getModelPath((StagedModel)category), (ClassedModel)category);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        long userId = portletDataContext.getUserId(category.getUserUuid());
        String emailAddress = null;
        String inProtocol = null;
        String inServerName = null;
        int inServerPort = 0;
        boolean inUseSSL = false;
        String inUserName = null;
        String inPassword = null;
        int inReadInterval = 0;
        String outEmailAddress = null;
        boolean outCustom = false;
        String outServerName = null;
        int outServerPort = 0;
        boolean outUseSSL = false;
        String outUserName = null;
        String outPassword = null;
        boolean allowAnonymous = false;
        boolean mailingListActive = false;
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)category.getParentCategoryId(), (long)category.getParentCategoryId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)category);
        MBCategory importedCategory = null;
        if (portletDataContext.isDataStrategyMirror()) {
            MBCategory existingCategory = this.fetchStagedModelByUuidAndGroupId(category.getUuid(), portletDataContext.getScopeGroupId());
            if (existingCategory == null) {
                serviceContext.setUuid(category.getUuid());
                importedCategory = this._mbCategoryLocalService.addCategory(userId, parentCategoryId, category.getName(), category.getDescription(), category.getDisplayStyle(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
            } else {
                importedCategory = this._mbCategoryLocalService.updateCategory(existingCategory.getCategoryId(), parentCategoryId, category.getName(), category.getDescription(), category.getDisplayStyle(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, false, serviceContext);
            }
        } else {
            importedCategory = this._mbCategoryLocalService.addCategory(userId, parentCategoryId, category.getName(), category.getDescription(), category.getDisplayStyle(), emailAddress, inProtocol, inServerName, inServerPort, inUseSSL, inUserName, inPassword, inReadInterval, outEmailAddress, outCustom, outServerName, outServerPort, outUseSSL, outUserName, outPassword, allowAnonymous, mailingListActive, serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)category, (ClassedModel)importedCategory);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, MBCategory category) throws Exception {
        MBCategory existingCategory = this.fetchStagedModelByUuidAndGroupId(category.getUuid(), portletDataContext.getScopeGroupId());
        if (existingCategory == null || !existingCategory.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)MBCategory.class.getName());
        if (trashHandler.isRestorable(existingCategory.getCategoryId())) {
            trashHandler.restoreTrashEntry(portletDataContext.getUserId(category.getUserUuid()), existingCategory.getCategoryId());
        }
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }
}

