/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.persistence.impl;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.impl.MBMessageImpl;
import com.liferay.message.boards.service.persistence.MBMessageFinder;
import com.liferay.message.boards.service.persistence.impl.MBMessageFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MBMessageFinderImpl
extends MBMessageFinderBaseImpl
implements MBMessageFinder {
    public static final String COUNT_BY_C_T = MBMessageFinder.class.getName() + ".countByC_T";
    public static final String COUNT_BY_G_U_C_S = MBMessageFinder.class.getName() + ".countByG_U_C_S";
    public static final String COUNT_BY_G_U_C_A_S = MBMessageFinder.class.getName() + ".countByG_U_C_A_S";
    public static final String COUNT_BY_G_U_MD_C_A_S = MBMessageFinder.class.getName() + ".countByG_U_MD_C_A_S";
    public static final String FIND_BY_NO_ASSETS = MBMessageFinder.class.getName() + ".findByNoAssets";
    public static final String FIND_BY_THREAD_ID = MBMessageFinder.class.getName() + ".findByThreadId";
    public static final String FIND_BY_G_U_C_S = MBMessageFinder.class.getName() + ".findByG_U_C_S";
    public static final String FIND_BY_G_U_C_A_S = MBMessageFinder.class.getName() + ".findByG_U_C_A_S";
    public static final String FIND_BY_G_U_MD_C_A_S = MBMessageFinder.class.getName() + ".findByG_U_MD_C_A_S";
    private static final String _USER_ID_SQL = "AND (currentMessage.userId = ?)";
    @ServiceReference(type=CustomSQL.class)
    private CustomSQL _customSQL;

    public int countByC_T(Date createDate, long threadId) {
        Timestamp createDate_TS = CalendarUtil.getTimestamp((Date)createDate);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_C_T);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(createDate_TS);
            qPos.add(threadId);
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public int countByG_U_C_S(long groupId, long userId, long[] categoryIds, int status) {
        return this.doCountByG_U_C_S(groupId, userId, categoryIds, status, false);
    }

    public int countByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status) {
        return this.doCountByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, false);
    }

    public int filterCountByG_U_C_S(long groupId, long userId, long[] categoryIds, int status) {
        return this.doCountByG_U_C_S(groupId, userId, categoryIds, status, true);
    }

    public int filterCountByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status) {
        return this.doCountByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, true);
    }

    public int filterCountByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status) {
        return this.doCountByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, true);
    }

    public int filterCountByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status) {
        return this.doCountByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, anonymous, status, true);
    }

    public List<Long> filterFindByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end) {
        return this.doFindByG_U_C_S(groupId, userId, categoryIds, status, start, end, true);
    }

    public List<Long> filterFindByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end) {
        return this.doFindByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, start, end, true);
    }

    public List<Long> filterFindByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, int start, int end) {
        return this.doFindByG_U_MD_C_S(groupId, userId, modifiedDate, categoryIds, status, start, end, true);
    }

    public List<Long> filterFindByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status, int start, int end) {
        return this.doFindByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, anonymous, status, start, end, true);
    }

    @Deprecated
    public List<MBMessage> findByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("MBMessage", MBMessageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(PortalUtil.getClassNameId(MBMessage.class));
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MBMessage> findByThreadId(long threadId, QueryDefinition<MBMessage> queryDefinition) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_THREAD_ID, queryDefinition, "MBMessage");
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("MBMessage", MBMessageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(threadId);
            qPos.add(queryDefinition.getStatus());
            if (queryDefinition.getOwnerUserId() > 0L) {
                qPos.add(queryDefinition.getOwnerUserId());
                if (queryDefinition.isIncludeOwner()) {
                    qPos.add(8);
                }
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end) {
        return this.doFindByG_U_C_S(groupId, userId, categoryIds, status, start, end, false);
    }

    public List<Long> findByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end) {
        return this.doFindByG_U_C_A_S(groupId, userId, categoryIds, anonymous, status, start, end, false);
    }

    protected int doCountByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = ArrayUtil.isEmpty((long[])categoryIds) ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_C_A_S);
            sql = ArrayUtil.isEmpty((long[])categoryIds) ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            qPos.add(anonymous);
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, boolean inlineSQLHelper) {
        return this.doCountByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, true, status, inlineSQLHelper);
    }

    protected int doCountByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status, boolean inlineSQLHelper) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_G_U_MD_C_A_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = ArrayUtil.isEmpty((long[])categoryIds) ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (!anonymous) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.anonymous = [$FALSE$])");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            qPos.add(modifiedDate);
            if (status != -1) {
                qPos.add(status);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_C_S(long groupId, long userId, long[] categoryIds, int status, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = ArrayUtil.isEmpty((long[])categoryIds) ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("threadId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_C_A_S(long groupId, long userId, long[] categoryIds, boolean anonymous, int status, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_C_A_S);
            sql = ArrayUtil.isEmpty((long[])categoryIds) ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("threadId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(userId);
            qPos.add(anonymous);
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Long> doFindByG_U_MD_C_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, int status, int start, int end, boolean inlineSQLHelper) {
        return this.doFindByG_U_MD_C_A_S(groupId, userId, modifiedDate, categoryIds, true, status, start, end, inlineSQLHelper);
    }

    protected List<Long> doFindByG_U_MD_C_A_S(long groupId, long userId, Date modifiedDate, long[] categoryIds, boolean anonymous, int status, int start, int end, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_G_U_MD_C_A_S);
            if (userId <= 0L) {
                sql = StringUtil.replace((String)sql, (String)_USER_ID_SQL, (String)"");
            }
            sql = ArrayUtil.isEmpty((long[])categoryIds) ? StringUtil.replace((String)sql, (String)"(currentMessage.categoryId = ?) AND", (String)"") : StringUtil.replace((String)sql, (String)"currentMessage.categoryId = ?", (String)("currentMessage.categoryId = " + StringUtil.merge((long[])categoryIds, (String)" OR currentMessage.categoryId = ")));
            if (status != -1) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.status = ?)");
            }
            if (!anonymous) {
                sql = this._customSQL.appendCriteria(sql, "AND (currentMessage.anonymous = [$FALSE$])");
            }
            if (inlineSQLHelper) {
                sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)MBMessage.class.getName(), (String)"currentMessage.rootMessageId", (long)groupId);
            }
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("threadId", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            if (userId > 0L) {
                qPos.add(userId);
            }
            qPos.add(modifiedDate);
            if (status != -1) {
                qPos.add(status);
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

