/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.message.boards.exception.NoSuchCategoryException;
import com.liferay.message.boards.exception.SplitThreadException;
import com.liferay.message.boards.internal.util.MBUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.message.boards.service.MBStatsUserLocalService;
import com.liferay.message.boards.service.base.MBThreadLocalServiceBaseImpl;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.exception.TrashEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.model.TrashVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MBThreadLocalServiceImpl
extends MBThreadLocalServiceBaseImpl {
    @ServiceReference(type=ExpandoRowLocalService.class)
    protected ExpandoRowLocalService expandoRowLocalService;
    @BeanReference(type=MBStatsUserLocalService.class)
    protected MBStatsUserLocalService mbStatsUserLocalService;
    @ServiceReference(type=SubscriptionLocalService.class)
    protected SubscriptionLocalService subscriptionLocalService;

    public MBThread addThread(long categoryId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        long threadId = message.getThreadId();
        if (!message.isRoot() || threadId <= 0L) {
            threadId = this.counterLocalService.increment();
        }
        MBThread thread = this.mbThreadPersistence.create(threadId);
        thread.setUuid(serviceContext.getUuid());
        thread.setGroupId(message.getGroupId());
        thread.setCompanyId(message.getCompanyId());
        thread.setUserId(message.getUserId());
        thread.setUserName(message.getUserName());
        thread.setCategoryId(categoryId);
        thread.setRootMessageId(message.getMessageId());
        thread.setRootMessageUserId(message.getUserId());
        thread.setTitle(message.getSubject());
        if (message.isAnonymous()) {
            thread.setLastPostByUserId(0L);
        } else {
            thread.setLastPostByUserId(message.getUserId());
        }
        thread.setLastPostDate(message.getModifiedDate());
        if (message.getPriority() != -1.0) {
            thread.setPriority(message.getPriority());
        }
        thread.setStatus(message.getStatus());
        thread.setStatusByUserId(message.getStatusByUserId());
        thread.setStatusByUserName(message.getStatusByUserName());
        thread.setStatusDate(message.getStatusDate());
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        if (categoryId >= 0L) {
            this.assetEntryLocalService.updateEntry(message.getUserId(), message.getGroupId(), thread.getStatusDate(), thread.getLastPostDate(), MBThread.class.getName(), thread.getThreadId(), thread.getUuid(), 0L, new long[0], new String[0], true, false, null, null, thread.getStatusDate(), null, null, String.valueOf(thread.getRootMessageId()), null, null, null, null, 0, 0, Double.valueOf(serviceContext.getAssetPriority()));
        }
        return thread;
    }

    public void deleteThread(long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        this.mbThreadLocalService.deleteThread(thread);
    }

    @SystemEvent(action=1, type=1)
    public void deleteThread(MBThread thread) throws PortalException {
        AssetEntry assetEntry;
        MBMessage rootMessage;
        block8: {
            rootMessage = this.mbMessageLocalService.getMessage(thread.getRootMessageId());
            Indexer messageIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            long folderId = thread.getAttachmentsFolderId();
            if (folderId != 0L) {
                PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
            }
            this.subscriptionLocalService.deleteSubscriptions(thread.getCompanyId(), MBThread.class.getName(), thread.getThreadId());
            List messages = this.mbMessageLocalService.getThreadMessages(thread.getThreadId(), -1, null);
            for (MBMessage message : messages) {
                this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
                this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
                this.expandoRowLocalService.deleteRows(message.getMessageId());
                if (!message.isDiscussion()) {
                    this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
                }
                this.mbMessageLocalService.deleteMBMessage(message);
                messageIndexer.delete((Object)message);
                if (!message.isDiscussion()) {
                    this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
                }
                this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
            }
            if (rootMessage.getCategoryId() != 0L && rootMessage.getCategoryId() != -1L) {
                try {
                    MBCategory category = this.mbCategoryLocalService.getCategory(thread.getCategoryId());
                    MBUtil.updateCategoryStatistics(category.getCategoryId());
                }
                catch (NoSuchCategoryException nsce) {
                    if (thread.isInTrash()) break block8;
                    throw nsce;
                }
            }
        }
        if ((assetEntry = this.assetEntryLocalService.fetchEntry(MBThread.class.getName(), thread.getThreadId())) != null) {
            assetEntry.setTitle(rootMessage.getSubject());
            this.assetEntryLocalService.updateAssetEntry(assetEntry);
        }
        this.assetEntryLocalService.deleteEntry(MBThread.class.getName(), thread.getThreadId());
        Indexer threadIndexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        threadIndexer.delete((Object)thread);
        this.mbThreadPersistence.remove((BaseModel)thread);
    }

    public void deleteThreads(long groupId, long categoryId) throws PortalException {
        this.mbThreadLocalService.deleteThreads(groupId, categoryId, true);
    }

    public void deleteThreads(long groupId, long categoryId, boolean includeTrashedEntries) throws PortalException {
        List threads = this.mbThreadPersistence.findByG_C(groupId, categoryId);
        for (MBThread thread : threads) {
            if (!includeTrashedEntries && thread.isInTrashExplicitly()) continue;
            this.mbThreadLocalService.deleteThread(thread);
        }
        if (this.mbThreadPersistence.countByGroupId(groupId) == 0) {
            PortletFileRepositoryUtil.deletePortletRepository((long)groupId, (String)"com.liferay.message.boards");
        }
    }

    public MBThread fetchThread(long threadId) {
        return this.mbThreadPersistence.fetchByPrimaryKey(threadId);
    }

    public int getCategoryThreadsCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, boolean includeAnonymous, QueryDefinition<MBThread> queryDefinition) {
        if (userId <= 0L) {
            return this.getGroupThreads(groupId, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.findByS_G_U_C(groupId, userId, null, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.findByG_U_C(groupId, userId, null, queryDefinition);
        }
        return this.mbThreadFinder.findByG_U_C_A(groupId, userId, null, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, boolean subscribed, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreads(groupId, userId, subscribed, true, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreads(groupId, userId, false, queryDefinition);
    }

    public List<MBThread> getGroupThreads(long groupId, QueryDefinition<MBThread> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.mbThreadPersistence.findByG_NotC_NotS(groupId, -1L, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd());
        }
        return this.mbThreadPersistence.findByG_NotC_S(groupId, -1L, queryDefinition.getStatus(), queryDefinition.getStart(), queryDefinition.getEnd());
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, boolean includeAnonymous, QueryDefinition<MBThread> queryDefinition) {
        if (userId <= 0L) {
            return this.getGroupThreadsCount(groupId, queryDefinition);
        }
        if (subscribed) {
            return this.mbThreadFinder.countByS_G_U_C(groupId, userId, null, queryDefinition);
        }
        if (includeAnonymous) {
            return this.mbThreadFinder.countByG_U_C(groupId, userId, null, queryDefinition);
        }
        return this.mbThreadFinder.countByG_U_C_A(groupId, userId, null, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, boolean subscribed, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreadsCount(groupId, userId, subscribed, true, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, long userId, QueryDefinition<MBThread> queryDefinition) {
        return this.getGroupThreadsCount(groupId, userId, false, queryDefinition);
    }

    public int getGroupThreadsCount(long groupId, QueryDefinition<MBThread> queryDefinition) {
        if (queryDefinition.isExcludeStatus()) {
            return this.mbThreadPersistence.countByG_NotC_NotS(groupId, -1L, queryDefinition.getStatus());
        }
        return this.mbThreadPersistence.countByG_NotC_S(groupId, -1L, queryDefinition.getStatus());
    }

    @Deprecated
    public List<MBThread> getNoAssetThreads() {
        return this.mbThreadFinder.findByNoAssets();
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority) throws PortalException {
        return this.getPriorityThreads(categoryId, priority, false);
    }

    public List<MBThread> getPriorityThreads(long categoryId, double priority, boolean inherit) throws PortalException {
        if (!inherit) {
            return this.mbThreadPersistence.findByC_P(categoryId, priority);
        }
        ArrayList<MBThread> threads = new ArrayList<MBThread>();
        while (categoryId != 0L && categoryId != -1L) {
            threads.addAll(0, this.mbThreadPersistence.findByC_P(categoryId, priority));
            MBCategory category = this.mbCategoryLocalService.getCategory(categoryId);
            categoryId = category.getParentCategoryId();
        }
        return threads;
    }

    public MBThread getThread(long threadId) throws PortalException {
        return this.mbThreadPersistence.findByPrimaryKey(threadId);
    }

    public List<MBThread> getThreads(long groupId, long categoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbThreadPersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbThreadPersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public int getThreadsCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbThreadPersistence.countByG_C(groupId, categoryId);
        }
        return this.mbThreadPersistence.countByG_C_S(groupId, categoryId, status);
    }

    public boolean hasAnswerMessage(long threadId) {
        int count = this.mbMessageLocalService.getThreadMessagesCount(threadId, true);
        return count > 0;
    }

    @BufferedIncrement(configuration="MBThread", incrementClass=NumberIncrement.class)
    public void incrementViewCounter(long threadId, int increment) throws PortalException {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        MBThread thread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        if (thread == null) {
            return;
        }
        thread.setModifiedDate(thread.getModifiedDate());
        thread.setViewCount(thread.getViewCount() + increment);
        this.mbThreadPersistence.update((BaseModel)thread);
    }

    public void moveDependentsToTrash(long groupId, long threadId, long trashEntryId) throws PortalException {
        HashSet<Long> userIds = new HashSet<Long>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        List messages = this.mbMessageLocalService.getThreadMessages(threadId, -1);
        for (MBMessage message : messages) {
            if (message.isDiscussion()) continue;
            int oldStatus = message.getStatus();
            message.setStatus(8);
            this.mbMessageLocalService.updateMBMessage(message);
            userIds.add(message.getUserId());
            int status = oldStatus;
            if (oldStatus == 1) {
                status = 2;
            }
            if (oldStatus != 0) {
                this.trashVersionLocalService.addTrashVersion(trashEntryId, MBMessage.class.getName(), message.getMessageId(), status, null);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), false);
            }
            for (FileEntry fileEntry : message.getAttachmentsFileEntries()) {
                PortletFileRepositoryUtil.movePortletFileEntryToTrash((long)thread.getStatusByUserId(), (long)fileEntry.getFileEntryId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
            if (oldStatus != 1) continue;
            this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLink(message.getCompanyId(), message.getGroupId(), MBMessage.class.getName(), message.getMessageId());
        }
        Iterator iterator = userIds.iterator();
        while (iterator.hasNext()) {
            long userId = (Long)iterator.next();
            this.mbStatsUserLocalService.updateStatsUser(groupId, userId);
        }
    }

    public MBThread moveThread(long groupId, long categoryId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        long oldCategoryId = thread.getCategoryId();
        MBCategory oldCategory = null;
        if (oldCategoryId != 0L) {
            oldCategory = this.mbCategoryLocalService.fetchMBCategory(oldCategoryId);
        }
        MBCategory category = null;
        if (categoryId != 0L) {
            category = this.mbCategoryLocalService.fetchMBCategory(categoryId);
        }
        thread.setCategoryId(categoryId);
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        List messages = this.mbMessageLocalService.getCategoryMessages(groupId, oldCategoryId, thread.getThreadId());
        for (MBMessage message : messages) {
            message.setCategoryId(categoryId);
            this.mbMessageLocalService.updateMBMessage(message);
            if (message.isDiscussion()) continue;
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        if (oldCategory != null && categoryId != oldCategoryId) {
            MBUtil.updateCategoryStatistics(oldCategory.getCategoryId());
        }
        if (category != null && categoryId != oldCategoryId) {
            MBUtil.updateCategoryStatistics(category.getCategoryId());
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        return thread;
    }

    public MBThread moveThreadFromTrash(long userId, long categoryId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (!thread.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (thread.isInTrashExplicitly()) {
            this.restoreThreadFromTrash(userId, threadId);
        } else {
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(MBThread.class.getName(), thread.getThreadId());
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, threadId, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            this.mbThreadLocalService.restoreDependentsFromTrash(thread.getGroupId(), threadId);
        }
        return this.moveThread(thread.getGroupId(), categoryId, threadId);
    }

    public void moveThreadsToTrash(long groupId, long userId) throws PortalException {
        List threads = this.mbThreadPersistence.findByGroupId(groupId);
        for (MBThread thread : threads) {
            this.moveThreadToTrash(userId, thread);
        }
    }

    public MBThread moveThreadToTrash(long userId, long threadId) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        return this.moveThreadToTrash(userId, thread);
    }

    public MBThread moveThreadToTrash(long userId, MBThread thread) throws PortalException {
        if (thread.isInTrash()) {
            throw new TrashEntryException();
        }
        if (thread.getCategoryId() == -1L) {
            return thread;
        }
        int oldStatus = thread.getStatus();
        if (oldStatus == 1) {
            thread.setStatus(2);
            thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        }
        thread = this.updateStatus(userId, thread.getThreadId(), 8);
        TrashEntry trashEntry = this.trashEntryLocalService.addTrashEntry(userId, thread.getGroupId(), MBThread.class.getName(), thread.getThreadId(), thread.getUuid(), null, oldStatus, null, null);
        this.mbThreadLocalService.moveDependentsToTrash(thread.getGroupId(), thread.getThreadId(), trashEntry.getEntryId());
        MBMessage message = this.mbMessageLocalService.getMBMessage(thread.getRootMessageId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("rootMessageId", thread.getRootMessageId());
        extraDataJSONObject.put("title", message.getSubject());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)thread, (int)10007, (String)extraDataJSONObject.toString(), (long)0L);
        return thread;
    }

    public void restoreDependentsFromTrash(long groupId, long threadId) throws PortalException {
        HashSet<Long> userIds = new HashSet<Long>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        List messages = this.mbMessageLocalService.getThreadMessages(threadId, -1);
        for (MBMessage message : messages) {
            if (message.isDiscussion()) continue;
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(MBMessage.class.getName(), message.getMessageId());
            int oldStatus = 0;
            if (trashVersion != null) {
                oldStatus = trashVersion.getStatus();
            }
            message.setStatus(oldStatus);
            this.mbMessageLocalService.updateMBMessage(message);
            userIds.add(message.getUserId());
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
            if (oldStatus == 0) {
                this.assetEntryLocalService.updateVisible(MBMessage.class.getName(), message.getMessageId(), true);
            }
            for (FileEntry fileEntry : message.getDeletedAttachmentsFileEntries()) {
                PortletFileRepositoryUtil.restorePortletFileEntryFromTrash((long)thread.getStatusByUserId(), (long)fileEntry.getFileEntryId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        Iterator iterator = userIds.iterator();
        while (iterator.hasNext()) {
            long userId = (Long)iterator.next();
            this.mbStatsUserLocalService.updateStatsUser(groupId, userId);
        }
    }

    public void restoreThreadFromTrash(long userId, long threadId) throws PortalException {
        MBThread thread = this.getThread(threadId);
        if (!thread.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        if (thread.getCategoryId() == -1L) {
            return;
        }
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(MBThread.class.getName(), threadId);
        this.updateStatus(userId, threadId, trashEntry.getStatus());
        this.mbThreadLocalService.restoreDependentsFromTrash(thread.getGroupId(), threadId);
        this.trashEntryLocalService.deleteEntry(trashEntry.getEntryId());
        MBMessage message = this.mbMessageLocalService.getMBMessage(thread.getRootMessageId());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("rootMessageId", thread.getRootMessageId());
        extraDataJSONObject.put("title", message.getSubject());
        SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)thread, (int)10008, (String)extraDataJSONObject.toString(), (long)0L);
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException {
        return this.search(groupId, userId, creatorUserId, 0L, 0L, status, start, end);
    }

    public Hits search(long groupId, long userId, long creatorUserId, long startDate, long endDate, int status, int start, int end) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)MBThread.class.getName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (endDate > 0L) {
            searchContext.setAttribute("endDate", (Serializable)Long.valueOf(endDate));
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("participantUserId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        if (startDate > 0L) {
            searchContext.setAttribute("startDate", (Serializable)Long.valueOf(startDate));
        }
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("lastPostDate", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    public MBThread splitThread(long userId, long messageId, String subject, ServiceContext serviceContext) throws PortalException {
        Indexer indexer;
        MBMessage message = this.mbMessageLocalService.getMessage(messageId);
        if (message.isRoot()) {
            throw new SplitThreadException("Unable to split message " + messageId + " because it is a root message");
        }
        MBCategory category = message.getCategory();
        MBThread oldThread = message.getThread();
        MBMessage rootMessage = this.mbMessageLocalService.getMessage(oldThread.getRootMessageId());
        long oldAttachmentsFolderId = message.getAttachmentsFolderId();
        this.mbMessageLocalService.updateAnswer(message, false, true);
        MBThread thread = this.addThread(message.getCategoryId(), message, serviceContext);
        oldThread = (MBThread)this.mbThreadPersistence.update((BaseModel)oldThread);
        if (Validator.isNotNull((String)subject)) {
            MBMessageDisplay messageDisplay = this.mbMessageLocalService.getMessageDisplay(userId, messageId, -1);
            MBTreeWalker treeWalker = messageDisplay.getTreeWalker();
            List messages = treeWalker.getMessages();
            int[] range = treeWalker.getChildrenRange(message);
            for (int i = range[0]; i < range[1]; ++i) {
                MBMessage curMessage = (MBMessage)messages.get(i);
                String oldSubject = message.getSubject();
                String curSubject = curMessage.getSubject();
                curSubject = oldSubject.startsWith("RE: ") ? StringUtil.replace((String)curSubject, (String)rootMessage.getSubject(), (String)subject) : StringUtil.replace((String)curSubject, (String)oldSubject, (String)subject);
                curMessage.setSubject(curSubject);
                this.mbMessageLocalService.updateMBMessage(curMessage);
            }
            message.setSubject(subject);
            thread.setTitle(subject);
            this.mbThreadLocalService.updateMBThread(thread);
        }
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(0L);
        this.mbMessageLocalService.updateMBMessage(message);
        this.moveAttachmentsFolders(message, oldAttachmentsFolderId, oldThread, thread, serviceContext);
        if (!message.isDiscussion()) {
            indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
            indexer.reindex((Object)message);
        }
        this.moveChildrenMessages(message, category, oldThread.getThreadId());
        MBUtil.updateThreadMessageCount(thread.getThreadId());
        MBUtil.updateThreadMessageCount(oldThread.getThreadId());
        if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
            MBUtil.updateCategoryThreadCount(category.getCategoryId());
        }
        indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)oldThread);
        indexer.reindex((Object)message.getThread());
        return thread;
    }

    public MBThread updateMessageCount(long threadId) {
        MBThread mbThread = this.mbThreadPersistence.fetchByPrimaryKey(threadId);
        if (mbThread == null) {
            return null;
        }
        int messageCount = this.mbMessageLocalService.getThreadMessagesCount(threadId, 0);
        mbThread.setMessageCount(messageCount);
        return (MBThread)this.mbThreadPersistence.update((BaseModel)mbThread);
    }

    public void updateQuestion(long threadId, boolean question) throws PortalException {
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        if (thread.isQuestion() == question) {
            return;
        }
        thread.setQuestion(question);
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        MBMessage message = this.mbMessageLocalService.getMessage(thread.getRootMessageId());
        if (!question) {
            this.mbMessageLocalService.updateAnswer(message, false, true);
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        indexer.reindex((Object)message);
    }

    public MBThread updateStatus(long userId, long threadId, int status) throws PortalException {
        MBCategory category;
        MBThread thread = this.mbThreadPersistence.findByPrimaryKey(threadId);
        User user = this.userLocalService.getUser(userId);
        thread.setStatus(status);
        thread.setStatusByUserId(user.getUserId());
        thread.setStatusByUserName(user.getFullName());
        thread.setStatusDate(new Date());
        thread = (MBThread)this.mbThreadPersistence.update((BaseModel)thread);
        if (thread.getCategoryId() != 0L && (category = this.mbCategoryLocalService.fetchMBCategory(thread.getCategoryId())) != null) {
            MBUtil.updateCategoryStatistics(category.getCategoryId());
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        return thread;
    }

    protected void moveAttachmentsFolders(MBMessage message, long oldAttachmentsFolderId, MBThread oldThread, MBThread newThread, ServiceContext serviceContext) throws PortalException {
        if (oldAttachmentsFolderId != 0L) {
            Folder newThreadFolder = newThread.addAttachmentsFolder();
            PortletFileRepositoryUtil.movePortletFolder((long)message.getGroupId(), (long)message.getUserId(), (long)oldAttachmentsFolderId, (long)newThreadFolder.getFolderId(), (ServiceContext)serviceContext);
        }
        List childMessages = this.mbMessageLocalService.getThreadMessages(oldThread.getThreadId(), message.getMessageId());
        for (MBMessage childMessage : childMessages) {
            this.moveAttachmentsFolders(childMessage, childMessage.getAttachmentsFolderId(), oldThread, newThread, serviceContext);
        }
    }

    protected void moveChildrenMessages(MBMessage parentMessage, MBCategory category, long oldThreadId) throws PortalException {
        List messages = this.mbMessageLocalService.getThreadMessages(oldThreadId, parentMessage.getMessageId());
        for (MBMessage message : messages) {
            message.setCategoryId(parentMessage.getCategoryId());
            message.setThreadId(parentMessage.getThreadId());
            message.setRootMessageId(parentMessage.getRootMessageId());
            this.mbMessageLocalService.updateMBMessage(message);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.reindex((Object)message);
            }
            this.moveChildrenMessages(message, category, oldThreadId);
        }
    }
}

