/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.LockedThreadException;
import com.liferay.message.boards.internal.util.MBUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.base.MBMessageServiceBaseImpl;
import com.liferay.message.boards.service.impl.MBCategoryServiceImpl;
import com.liferay.message.boards.service.permission.MBDiscussionPermission;
import com.liferay.message.boards.util.comparator.MessageCreateDateComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.util.PropsValues;
import com.liferay.rss.export.RSSExporter;
import com.liferay.rss.model.SyndContent;
import com.liferay.rss.model.SyndEntry;
import com.liferay.rss.model.SyndFeed;
import com.liferay.rss.model.SyndLink;
import com.liferay.rss.model.SyndModelFactory;
import com.liferay.rss.util.RSSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class MBMessageServiceImpl
extends MBMessageServiceBaseImpl {
    private static volatile ModelResourcePermission<MBCategory> _categoryModelResourcePermission = ModelResourcePermissionFactory.getInstance(MBCategoryServiceImpl.class, (String)"_categoryModelResourcePermission", MBCategory.class);
    private static volatile ModelResourcePermission<MBMessage> _messageModelResourcePermission = ModelResourcePermissionFactory.getInstance(MBMessageServiceImpl.class, (String)"_messageModelResourcePermission", MBMessage.class);
    @ServiceReference(type=RSSExporter.class)
    private RSSExporter _rssExporter;
    @ServiceReference(type=SyndModelFactory.class)
    private SyndModelFactory _syndModelFactory;

    public MBMessage addDiscussionMessage(long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        User user = this.getGuestOrUser();
        MBDiscussionPermission.check((PermissionChecker)this.getPermissionChecker(), (long)user.getCompanyId(), (long)serviceContext.getScopeGroupId(), (String)className, (long)classPK, (String)"ADD_DISCUSSION");
        return this.mbMessageLocalService.addDiscussionMessage(user.getUserId(), null, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
    }

    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_MESSAGE");
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, String fileName, File file, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws FileNotFoundException, PortalException {
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        FileInputStream inputStream = new FileInputStream(file);
        ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
        inputStreamOVPs.add(inputStreamOVP);
        return this.addMessage(groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        MBCategory category = this.mbCategoryLocalService.getCategory(categoryId);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        return this.addMessage(category.getGroupId(), categoryId, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, false, serviceContext);
    }

    public MBMessage addMessage(long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage = this.mbMessagePersistence.findByPrimaryKey(parentMessageId);
        this.checkReplyToPermission(parentMessage.getGroupId(), parentMessage.getCategoryId(), parentMessageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        int workFlowAction = serviceContext.getWorkflowAction();
        if (workFlowAction == 2 && !preview && !serviceContext.isSignedIn()) {
            _messageModelResourcePermission.check(this.getPermissionChecker(), parentMessageId, "UPDATE");
        }
        if (LockManagerUtil.isLocked((String)MBThread.class.getName(), (long)parentMessage.getThreadId())) {
            StringBundler sb = new StringBundler(4);
            sb.append("Thread is locked for class name ");
            sb.append(MBThread.class.getName());
            sb.append(" and class PK ");
            sb.append(parentMessage.getThreadId());
            throw new LockedThreadException(sb.toString());
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)parentMessage.getGroupId(), (long)parentMessage.getCategoryId(), (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)parentMessage.getGroupId(), (long)parentMessage.getCategoryId(), (String)"UPDATE_THREAD_PRIORITY")) {
            priority = -1.0;
        }
        return this.mbMessageLocalService.addMessage(this.getGuestOrUserId(), null, parentMessage.getGroupId(), parentMessage.getCategoryId(), parentMessage.getThreadId(), parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public void addMessageAttachment(long messageId, String fileName, File file, String mimeType) throws PortalException {
        MBMessage message = this.mbMessageLocalService.getMBMessage(messageId);
        if (LockManagerUtil.isLocked((String)MBThread.class.getName(), (long)message.getThreadId())) {
            StringBundler sb = new StringBundler(4);
            sb.append("Thread is locked for class name ");
            sb.append(MBThread.class.getName());
            sb.append(" and class PK ");
            sb.append(message.getThreadId());
            throw new LockedThreadException(sb.toString());
        }
        ModelResourcePermissionHelper.check(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE");
        this.mbMessageLocalService.addMessageAttachment(this.getUserId(), messageId, fileName, file, mimeType);
    }

    public FileEntry addTempAttachment(long groupId, long categoryId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        ModelResourcePermissionHelper.check(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_FILE");
        return this.mbMessageLocalService.addTempAttachment(groupId, this.getUserId(), folderName, fileName, inputStream, mimeType);
    }

    public void deleteDiscussionMessage(long messageId) throws PortalException {
        MBDiscussionPermission.check((PermissionChecker)this.getPermissionChecker(), (long)messageId, (String)"DELETE_DISCUSSION");
        this.mbMessageLocalService.deleteDiscussionMessage(messageId);
    }

    public void deleteMessage(long messageId) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessage(messageId);
    }

    public void deleteMessageAttachment(long messageId, String fileName) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        this.mbMessageLocalService.deleteMessageAttachment(messageId, fileName);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.deleteMessageAttachments(messageId);
    }

    public void deleteTempAttachment(long groupId, long categoryId, String folderName, String fileName) throws PortalException {
        ModelResourcePermissionHelper.check(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)categoryId, (String)"ADD_FILE");
        this.mbMessageLocalService.deleteTempAttachment(groupId, this.getUserId(), folderName, fileName);
    }

    public void emptyMessageAttachments(long messageId) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "DELETE");
        this.mbMessageLocalService.emptyMessageAttachments(messageId);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws PortalException {
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        List categoryMessages = this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, start, end);
        for (MBMessage message : categoryMessages) {
            if (!_messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
            messages.add(message);
        }
        return messages;
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) {
        return this.mbMessageLocalService.getCategoryMessagesCount(groupId, categoryId, status);
    }

    public String getCategoryMessagesRSS(long groupId, long categoryId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        String name = "";
        String description = "";
        MBCategory category = this.mbCategoryLocalService.fetchMBCategory(categoryId);
        if (category == null) {
            Group group = this.groupLocalService.getGroup(categoryId);
            groupId = group.getGroupId();
            categoryId = 0L;
            name = group.getDescriptiveName();
            description = group.getDescription(LocaleUtil.getMostRelevantLocale());
        } else {
            groupId = category.getGroupId();
            name = category.getName();
            description = category.getDescription();
        }
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCategoryMessages(groupId, categoryId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!_messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getCompanyMessagesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Company company = this.companyLocalService.getCompany(companyId);
        String name = company.getName();
        String description = company.getName();
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getCompanyMessages(companyId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!_messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public int getGroupMessagesCount(long groupId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByGroupId(groupId);
        }
        return this.mbMessagePersistence.filterCountByG_S(groupId, status);
    }

    public String getGroupMessagesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        String name = group.getDescriptiveName();
        String description = group.getDescription(LocaleUtil.getMostRelevantLocale());
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!_messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public String getGroupMessagesRSS(long groupId, long userId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        String name = group.getDescriptiveName();
        String description = group.getDescription(LocaleUtil.getMostRelevantLocale());
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
        block0: while (messages.size() < max && listNotExhausted) {
            List messageList = this.mbMessageLocalService.getGroupMessages(groupId, userId, status, lastIntervalStart, lastIntervalStart + max, (OrderByComparator)comparator);
            lastIntervalStart += max;
            listNotExhausted = messageList.size() == max;
            for (MBMessage message : messageList) {
                if (messages.size() >= max) continue block0;
                if (!_messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public MBMessage getMessage(long messageId) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessage(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "VIEW");
        return this.mbMessageLocalService.getMessageDisplay(this.getGuestOrUserId(), messageId, status);
    }

    public String[] getTempAttachmentNames(long groupId, String folderName) throws PortalException {
        return this.mbMessageLocalService.getTempAttachmentNames(groupId, this.getUserId(), folderName);
    }

    public int getThreadAnswersCount(long groupId, long categoryId, long threadId) {
        return this.mbMessagePersistence.filterCountByG_C_T_A(groupId, categoryId, threadId, true);
    }

    public List<MBMessage> getThreadMessages(long groupId, long categoryId, long threadId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.filterFindByG_C_T(groupId, categoryId, threadId, start, end);
        }
        return this.mbMessagePersistence.filterFindByG_C_T_S(groupId, categoryId, threadId, status, start, end);
    }

    public int getThreadMessagesCount(long groupId, long categoryId, long threadId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.filterCountByG_C_T(groupId, categoryId, threadId);
        }
        return this.mbMessagePersistence.filterCountByG_C_T_S(groupId, categoryId, threadId, status);
    }

    public String getThreadMessagesRSS(long threadId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        String name = "";
        String description = "";
        ArrayList<MBMessage> messages = new ArrayList<MBMessage>();
        MBThread thread = this.mbThreadLocalService.getThread(threadId);
        if (_messageModelResourcePermission.contains(this.getPermissionChecker(), thread.getRootMessageId(), "VIEW")) {
            MessageCreateDateComparator comparator = new MessageCreateDateComparator(false);
            List threadMessages = this.mbMessageLocalService.getThreadMessages(threadId, status, (Comparator)comparator);
            for (MBMessage message : threadMessages) {
                if (messages.size() >= max) break;
                if (!_messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "VIEW")) continue;
                messages.add(message);
            }
            if (!messages.isEmpty()) {
                MBMessage message = (MBMessage)messages.get(messages.size() - 1);
                name = message.getSubject();
                description = message.getSubject();
            }
        }
        return this.exportToRSS(name, description, type, version, displayStyle, feedURL, entryURL, messages, themeDisplay);
    }

    public void moveMessageAttachmentToTrash(long messageId, String fileName) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        this.mbMessageLocalService.moveMessageAttachmentToTrash(this.getUserId(), messageId, fileName);
    }

    public void restoreMessageAttachmentFromTrash(long messageId, String fileName) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        ModelResourcePermissionHelper.check(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE");
        this.mbMessageLocalService.restoreMessageAttachmentFromTrash(this.getUserId(), messageId, fileName);
    }

    public void subscribeMessage(long messageId) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.subscribeMessage(this.getUserId(), messageId);
    }

    public void unsubscribeMessage(long messageId) throws PortalException {
        _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "SUBSCRIBE");
        this.mbMessageLocalService.unsubscribeMessage(this.getUserId(), messageId);
    }

    public void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        _messageModelResourcePermission.check(this.getPermissionChecker(), message.getRootMessageId(), "UPDATE");
        this.mbMessageLocalService.updateAnswer(messageId, answer, cascade);
    }

    public MBMessage updateDiscussionMessage(String className, long classPK, long messageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        MBDiscussionPermission.check((PermissionChecker)this.getPermissionChecker(), (long)messageId, (String)"UPDATE_DISCUSSION");
        return this.mbMessageLocalService.updateDiscussionMessage(this.getUserId(), messageId, className, classPK, subject, body, serviceContext);
    }

    public MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        if (preview && _messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "UPDATE")) {
            this.checkReplyToPermission(message.getGroupId(), message.getCategoryId(), message.getParentMessageId());
        } else {
            _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        }
        if (LockManagerUtil.isLocked((String)MBThread.class.getName(), (long)message.getThreadId())) {
            StringBundler sb = new StringBundler(4);
            sb.append("Thread is locked for class name ");
            sb.append(MBThread.class.getName());
            sb.append(" and class PK ");
            sb.append(message.getThreadId());
            throw new LockedThreadException(sb.toString());
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"UPDATE_THREAD_PRIORITY")) {
            MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
            priority = thread.getPriority();
        }
        return this.mbMessageLocalService.updateMessage(this.getGuestOrUserId(), messageId, subject, body, inputStreamOVPs, priority, allowPingbacks, serviceContext);
    }

    @Deprecated
    public MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        boolean preview = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"preview");
        if (preview && _messageModelResourcePermission.contains(this.getPermissionChecker(), (ClassedModel)message, "UPDATE")) {
            this.checkReplyToPermission(message.getGroupId(), message.getCategoryId(), message.getParentMessageId());
        } else {
            _messageModelResourcePermission.check(this.getPermissionChecker(), messageId, "UPDATE");
        }
        if (LockManagerUtil.isLocked((String)MBThread.class.getName(), (long)message.getThreadId())) {
            StringBundler sb = new StringBundler(4);
            sb.append("Thread is locked for class name ");
            sb.append(MBThread.class.getName());
            sb.append(" and class PK ");
            sb.append(message.getThreadId());
            throw new LockedThreadException(sb.toString());
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"ADD_FILE")) {
            inputStreamOVPs = Collections.emptyList();
        }
        if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)message.getGroupId(), (long)message.getCategoryId(), (String)"UPDATE_THREAD_PRIORITY")) {
            MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
            priority = thread.getPriority();
        }
        return this.mbMessageLocalService.updateMessage(this.getGuestOrUserId(), messageId, subject, body, inputStreamOVPs, existingFiles, priority, allowPingbacks, serviceContext);
    }

    protected void checkReplyToPermission(long groupId, long categoryId, long parentMessageId) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentMessageId > 0L) {
            if (ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)categoryId, (String)"ADD_MESSAGE")) {
                return;
            }
            if (!ModelResourcePermissionHelper.contains(_categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)categoryId, (String)"REPLY_TO_MESSAGE")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, MBCategory.class.getName(), categoryId, new String[]{"REPLY_TO_MESSAGE"});
            }
        } else {
            ModelResourcePermissionHelper.check(_categoryModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)categoryId, (String)"ADD_MESSAGE");
        }
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<MBMessage> messages, ThemeDisplay themeDisplay) {
        SyndFeed syndFeed = this._syndModelFactory.createSyndFeed();
        syndFeed.setDescription(description);
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        syndFeed.setEntries(syndEntries);
        for (MBMessage message : messages) {
            SyndEntry syndEntry = this._syndModelFactory.createSyndEntry();
            if (!message.isAnonymous()) {
                String author = PortalUtil.getUserName((BaseModel)message);
                syndEntry.setAuthor(author);
            }
            SyndContent syndContent = this._syndModelFactory.createSyndContent();
            syndContent.setType("html");
            String value = null;
            if (displayStyle.equals("abstract")) {
                value = StringUtil.shorten((String)HtmlUtil.extractText((String)message.getBody()), (int)PropsValues.MESSAGE_BOARDS_RSS_ABSTRACT_LENGTH, (String)"");
            } else if (displayStyle.equals("title")) {
                value = "";
            } else if (message.isFormatBBCode()) {
                value = BBCodeTranslatorUtil.getHTML((String)message.getBody());
                value = MBUtil.replaceMessageBodyPaths(themeDisplay, value);
            } else {
                value = message.getBody();
            }
            syndContent.setValue(value);
            syndEntry.setDescription(syndContent);
            String link = entryURL + "&messageId=" + message.getMessageId();
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(message.getCreateDate());
            syndEntry.setTitle(message.getSubject());
            syndEntry.setUpdatedDate(message.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLink> syndLinks = new ArrayList<SyndLink>();
        syndFeed.setLinks(syndLinks);
        SyndLink selfSyndLink = this._syndModelFactory.createSyndLink();
        syndLinks.add(selfSyndLink);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        return this._rssExporter.export(syndFeed);
    }
}

