/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.comment.configuration.CommentGroupServiceConfiguration;
import com.liferay.message.boards.constants.MBCategoryConstants;
import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.exception.DiscussionMaxCommentsException;
import com.liferay.message.boards.exception.MessageBodyException;
import com.liferay.message.boards.exception.MessageSubjectException;
import com.liferay.message.boards.exception.NoSuchThreadException;
import com.liferay.message.boards.exception.RequiredMessageException;
import com.liferay.message.boards.internal.util.MBDiscussionSubcriptionSender;
import com.liferay.message.boards.internal.util.MBMailUtil;
import com.liferay.message.boards.internal.util.MBSubscriptionSender;
import com.liferay.message.boards.internal.util.MailingListThreadLocal;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.impl.MBCategoryImpl;
import com.liferay.message.boards.model.impl.MBMessageDisplayImpl;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBStatsUserLocalService;
import com.liferay.message.boards.service.base.MBMessageLocalServiceBaseImpl;
import com.liferay.message.boards.settings.MBGroupServiceSettings;
import com.liferay.message.boards.util.MBUtil;
import com.liferay.message.boards.util.comparator.MessageCreateDateComparator;
import com.liferay.message.boards.util.comparator.MessageThreadComparator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.sanitizer.SanitizerUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.social.SocialActivityManagerUtil;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.linkback.LinkbackProducerUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.util.LayoutURLUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.kernel.util.TrashUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.StartTag;

public class MBMessageLocalServiceImpl
extends MBMessageLocalServiceBaseImpl {
    @ServiceReference(type=ConfigurationProvider.class)
    protected ConfigurationProvider configurationProvider;
    @ServiceReference(type=Http.class)
    protected Http http;
    @BeanReference(type=MBDiscussionLocalService.class)
    protected MBDiscussionLocalService mbDiscussionLocalService;
    @BeanReference(type=MBStatsUserLocalService.class)
    protected MBStatsUserLocalService mbStatsUserLocalService;
    @ServiceReference(type=Portal.class)
    protected Portal portal;
    @ServiceReference(type=SubscriptionLocalService.class)
    protected SubscriptionLocalService subscriptionLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageLocalServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, int workflowAction) throws PortalException {
        String subject;
        long threadId = 0L;
        long parentMessageId = 0L;
        String body = subject = String.valueOf(classPK);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setWorkflowAction(workflowAction);
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        WorkflowThreadLocal.setEnabled((boolean)false);
        try {
            MBMessage mBMessage = this.addDiscussionMessage(userId, userName, groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext);
            return mBMessage;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    public MBMessage addDiscussionMessage(long userId, String userName, long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        long classNameId;
        MBDiscussion discussion;
        this.validateDiscussionMaxComments(className, classPK);
        long categoryId = -1L;
        subject = this.getDiscussionMessageSubject(subject, body);
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        boolean anonymous = false;
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        Date now = new Date();
        if (serviceContext.getCreateDate() == null) {
            serviceContext.setCreateDate(now);
        }
        if (serviceContext.getModifiedDate() == null) {
            serviceContext.setModifiedDate(now);
        }
        MBMessage message = this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, PropsValues.DISCUSSION_COMMENTS_FORMAT, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
        if (parentMessageId == 0L && (discussion = this.mbDiscussionLocalService.fetchDiscussion(classNameId = this.classNameLocalService.getClassNameId(className), classPK)) == null) {
            this.mbDiscussionLocalService.addDiscussion(userId, groupId, classNameId, classPK, message.getThreadId(), serviceContext);
        }
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, long threadId, long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage;
        MBGroupServiceSettings mbGroupServiceSettings;
        Group group = this.groupLocalService.getGroup(groupId);
        User user = this.userLocalService.fetchUser(PortalUtil.getValidUserId((long)group.getCompanyId(), (long)userId));
        userName = user.isDefaultUser() ? userName : user.getFullName();
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        if (!MBUtil.isValidMessageFormat((String)format)) {
            format = "html";
        }
        if ((mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)groupId)) != null && !mbGroupServiceSettings.isAllowAnonymousPosting() && (anonymous || user.isDefaultUser())) {
            throw new PrincipalException.MustHavePermission(userId, new String[]{"ADD_MESSAGE"});
        }
        if (user.isDefaultUser()) {
            anonymous = true;
        }
        Date now = new Date();
        long messageId = this.counterLocalService.increment();
        subject = this.getSubject(subject, body);
        body = this.getBody(subject, body, format);
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        boolean discussion = false;
        if (categoryId == -1L) {
            discussion = true;
        }
        options.put("discussion", discussion);
        body = SanitizerUtil.sanitize((long)user.getCompanyId(), (long)groupId, (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)("text/" + format), (String)"ALL", (String)body, options);
        this.validate(subject, body);
        MBMessage message = this.mbMessagePersistence.create(messageId);
        message.setUuid(serviceContext.getUuid());
        message.setGroupId(groupId);
        message.setCompanyId(user.getCompanyId());
        message.setUserId(user.getUserId());
        message.setUserName(userName);
        message.setCreateDate(serviceContext.getCreateDate(now));
        message.setModifiedDate(serviceContext.getModifiedDate(now));
        if (threadId > 0L) {
            message.setThreadId(threadId);
        }
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        message.setSubject(subject);
        message.setAllowPingbacks(allowPingbacks);
        message.setStatus(2);
        message.setStatusByUserId(user.getUserId());
        message.setStatusByUserName(userName);
        message.setStatusDate(serviceContext.getModifiedDate(now));
        if (parentMessageId != 0L && (parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(parentMessageId)) == null) {
            parentMessageId = 0L;
        }
        MBThread thread = null;
        if (threadId > 0L) {
            thread = this.mbThreadLocalService.fetchThread(threadId);
        }
        if (thread == null) {
            if (parentMessageId == 0L) {
                thread = this.mbThreadLocalService.addThread(categoryId, message, serviceContext);
            } else {
                throw new NoSuchThreadException("{threadId=" + threadId + "}");
            }
        }
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.mbThreadLocalService.updateMBThread(thread);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        message.setCategoryId(categoryId);
        message.setThreadId(thread.getThreadId());
        message.setRootMessageId(thread.getRootMessageId());
        message.setParentMessageId(parentMessageId);
        message.setBody(body);
        message.setFormat(format);
        message.setAnonymous(anonymous);
        if (message.isDiscussion()) {
            long classNameId = this.classNameLocalService.getClassNameId((String)((Object)serviceContext.getAttribute("className")));
            long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
            message.setClassNameId(classNameId);
            message.setClassPK(classPK);
        }
        message.setExpandoBridgeAttributes(serviceContext);
        message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        if (parentMessageId != 0L && GetterUtil.getBoolean((Object)serviceContext.getAttribute("propagatePermissions"))) {
            com.liferay.message.boards.internal.util.MBUtil.propagatePermissions(message.getCompanyId(), groupId, parentMessageId, serviceContext);
        }
        if (!message.isDiscussion()) {
            if (user.isDefaultUser()) {
                this.addMessageResources(message, true, true);
            } else if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
                this.addMessageResources(message, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
            } else {
                this.addMessageResources(message, serviceContext.getModelPermissions());
            }
        }
        if (ListUtil.isNotEmpty(inputStreamOVPs)) {
            Folder folder = message.addAttachmentsFolder();
            PortletFileRepositoryUtil.addPortletFileEntries((long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"com.liferay.message.boards", (long)folder.getFolderId(), inputStreamOVPs);
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds(), serviceContext.isAssetEntryVisible());
        this.startWorkflowInstance(userId, message, serviceContext);
        return message;
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = Collections.emptyList();
        return this.addMessage(userId, userName, groupId, categoryId, 0L, 0L, subject, body, MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, false, serviceContext);
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        long threadId = 0L;
        long parentMessageId = 0L;
        return this.addMessage(userId, userName, groupId, categoryId, threadId, parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public MBMessage addMessage(long userId, String userName, long groupId, long categoryId, String subject, String body, String format, String fileName, File file, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws FileNotFoundException, PortalException {
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>(1);
        FileInputStream inputStream = new FileInputStream(file);
        ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
        inputStreamOVPs.add(inputStreamOVP);
        return this.addMessage(userId, userName, groupId, categoryId, 0L, 0L, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext);
    }

    public void addMessageAttachment(long userId, long messageId, String fileName, File file, String mimeType) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        Folder folder = message.addAttachmentsFolder();
        PortletFileRepositoryUtil.addPortletFileEntry((long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"com.liferay.message.boards", (long)folder.getFolderId(), (File)file, (String)fileName, (String)mimeType, (boolean)true);
    }

    public void addMessageResources(long messageId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, addGroupPermissions, addGuestPermissions);
    }

    public void addMessageResources(long messageId, ModelPermissions modelPermissions) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.addMessageResources(message, modelPermissions);
    }

    public void addMessageResources(MBMessage message, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this.resourceLocalService.addResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addMessageResources(MBMessage message, ModelPermissions modelPermissions) throws PortalException {
        this.resourceLocalService.addModelResources(message.getCompanyId(), message.getGroupId(), message.getUserId(), MBMessage.class.getName(), message.getMessageId(), modelPermissions);
    }

    public FileEntry addTempAttachment(long groupId, long userId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteDiscussionMessage(long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        SocialActivityManagerUtil.deleteActivities((ClassedModel)message);
        return this.mbMessageLocalService.deleteMessage(messageId);
    }

    public void deleteDiscussionMessages(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        MBDiscussion discussion = this.mbDiscussionLocalService.fetchDiscussion(classNameId, classPK);
        if (discussion == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Unable to delete discussion message for class name ", className, " and class PK ", classPK, " because it does not exist"}));
            }
            return;
        }
        List messages = this.mbMessagePersistence.findByT_P(discussion.getThreadId(), 0L, 0, 1);
        if (!messages.isEmpty()) {
            MBMessage message = (MBMessage)messages.get(0);
            SocialActivityManagerUtil.deleteActivities((ClassedModel)message);
            this.mbThreadLocalService.deleteThread(message.getThreadId());
        }
        this.mbDiscussionLocalService.deleteMBDiscussion(discussion);
    }

    @Indexable(type=IndexableType.DELETE)
    public MBMessage deleteMessage(long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageLocalService.deleteMessage(message);
    }

    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public MBMessage deleteMessage(MBMessage message) throws PortalException {
        int count;
        long folderId = message.getAttachmentsFolderId();
        if (folderId != 0L) {
            PortletFileRepositoryUtil.deletePortletFolder((long)folderId);
        }
        if ((count = this.mbMessagePersistence.countByThreadId(message.getThreadId())) == 1) {
            long threadAttachmentsFolderId = message.getThreadAttachmentsFolderId();
            if (threadAttachmentsFolderId != 0L) {
                PortletFileRepositoryUtil.deletePortletFolder((long)threadAttachmentsFolderId);
            }
            this.subscriptionLocalService.deleteSubscriptions(message.getCompanyId(), MBThread.class.getName(), message.getThreadId());
            MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
            this.mbThreadLocalService.deleteMBThread(thread);
            if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
                com.liferay.message.boards.internal.util.MBUtil.updateCategoryStatistics(message.getCategoryId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
            indexer.delete((Object)thread);
        } else {
            List childrenMessages;
            MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
            if (thread.getRootMessageId() == message.getMessageId()) {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (childrenMessages.size() > 1) {
                    throw new RequiredMessageException(String.valueOf(message.getMessageId()));
                }
                if (childrenMessages.size() == 1) {
                    MBMessage childMessage = (MBMessage)childrenMessages.get(0);
                    childMessage.setRootMessageId(childMessage.getMessageId());
                    childMessage.setParentMessageId(0L);
                    childMessage = (MBMessage)this.mbMessagePersistence.update((BaseModel)childMessage);
                    List repliesMessages = this.mbMessagePersistence.findByThreadReplies(message.getThreadId());
                    for (MBMessage repliesMessage : repliesMessages) {
                        repliesMessage.setRootMessageId(childMessage.getMessageId());
                        this.mbMessagePersistence.update((BaseModel)repliesMessage);
                    }
                    thread.setRootMessageId(childMessage.getMessageId());
                    thread.setRootMessageUserId(childMessage.getUserId());
                    this.mbThreadLocalService.updateMBThread(thread);
                }
            } else {
                childrenMessages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
                if (!childrenMessages.isEmpty()) {
                    for (MBMessage childMessage : childrenMessages) {
                        childMessage.setParentMessageId(message.getParentMessageId());
                        this.mbMessagePersistence.update((BaseModel)childMessage);
                    }
                } else if (message.getStatus() == 0) {
                    MessageCreateDateComparator comparator = new MessageCreateDateComparator(true);
                    MBMessage[] prevAndNextMessages = this.mbMessagePersistence.findByT_S_PrevAndNext(message.getMessageId(), thread.getThreadId(), 0, (OrderByComparator)comparator);
                    if (prevAndNextMessages[2] == null) {
                        thread.setLastPostByUserId(prevAndNextMessages[0].getUserId());
                        thread.setLastPostDate(prevAndNextMessages[0].getModifiedDate());
                        this.mbThreadLocalService.updateMBThread(thread);
                    }
                }
            }
            if (message.isApproved()) {
                com.liferay.message.boards.internal.util.MBUtil.updateThreadMessageCount(thread.getThreadId());
            }
            if (message.getCategoryId() != 0L && message.getCategoryId() != -1L && !message.isDraft()) {
                com.liferay.message.boards.internal.util.MBUtil.updateCategoryMessageCount(message.getCategoryId());
            }
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
            indexer.reindex((Object)thread);
        }
        this.assetEntryLocalService.deleteEntry(message.getWorkflowClassName(), message.getMessageId());
        this.expandoRowLocalService.deleteRows(message.getMessageId());
        this.ratingsStatsLocalService.deleteStats(message.getWorkflowClassName(), message.getMessageId());
        if (!message.isDiscussion()) {
            this.resourceLocalService.deleteResource(message.getCompanyId(), message.getWorkflowClassName(), 4, message.getMessageId());
        }
        this.mbMessagePersistence.remove((BaseModel)message);
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), message.getUserId());
        }
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(message.getCompanyId(), message.getGroupId(), message.getWorkflowClassName(), message.getMessageId());
        return message;
    }

    public void deleteMessageAttachment(long messageId, String fileName) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntry((long)message.getGroupId(), (long)folderId, (String)fileName);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntries((long)message.getGroupId(), (long)folderId);
    }

    public void deleteTempAttachment(long groupId, long userId, String folderName, String fileName) throws PortalException {
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)userId, (String)folderName, (String)fileName);
    }

    public void emptyMessageAttachments(long messageId) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        if (folderId == 0L) {
            return;
        }
        PortletFileRepositoryUtil.deletePortletFileEntries((long)message.getGroupId(), (long)folderId, (int)8);
    }

    public MBMessage fetchFileEntryMessage(long fileEntryId) throws PortalException {
        return this.mbMessagePersistence.fetchByPrimaryKey(this._getFileEntryMessageId(fileEntryId));
    }

    public MBMessage fetchFirstMessage(long threadId, long parentMessageId) throws PortalException {
        return this.mbMessagePersistence.fetchByT_P_First(threadId, parentMessageId, null);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_C(groupId, categoryId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_C_S(groupId, categoryId, status, start, end, obc);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, long threadId) {
        return this.mbMessagePersistence.findByG_C_T(groupId, categoryId, threadId);
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_C(groupId, categoryId);
        }
        return this.mbMessagePersistence.countByG_C_S(groupId, categoryId, status);
    }

    public List<MBMessage> getChildMessages(long parentMessageId, int status) {
        return this.mbMessagePersistence.findByP_S(parentMessageId, status);
    }

    public List<MBMessage> getChildMessages(long parentMessageId, int status, int start, int end) {
        return this.mbMessagePersistence.findByP_S(parentMessageId, status, start, end);
    }

    public int getChildMessagesCount(long parentMessageId, int status) {
        return this.mbMessagePersistence.countByP_S(parentMessageId, status);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end);
    }

    public List<MBMessage> getCompanyMessages(long companyId, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        if (status == -1) {
            return this.mbMessagePersistence.findByCompanyId(companyId, start, end, obc);
        }
        return this.mbMessagePersistence.findByC_S(companyId, status, start, end, obc);
    }

    public int getCompanyMessagesCount(long companyId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByCompanyId(companyId);
        }
        return this.mbMessagePersistence.countByC_S(companyId, status);
    }

    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status) throws PortalException {
        return this.getDiscussionMessageDisplay(userId, groupId, className, classPK, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MBMessageDisplay getDiscussionMessageDisplay(long userId, long groupId, String className, long classPK, int status, Comparator<MBMessage> comparator) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        MBMessage message = null;
        MBDiscussion discussion = this.mbDiscussionLocalService.fetchDiscussion(classNameId, classPK);
        if (discussion != null) {
            message = this.mbMessagePersistence.findByT_P_First(discussion.getThreadId(), 0L, null);
        } else {
            boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
            WorkflowThreadLocal.setEnabled((boolean)false);
            try {
                String subject = String.valueOf(classPK);
                message = this.mbMessageLocalService.addDiscussionMessage(userId, null, groupId, className, classPK, 0L, 0L, subject, subject, new ServiceContext());
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Add failed, fetch {threadId=0, parentMessageId=0}");
                }
                if ((message = this.mbMessagePersistence.fetchByT_P_First(0L, 0L, null)) == null) {
                    throw se;
                }
            }
            finally {
                WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
            }
        }
        return this.getMessageDisplay(userId, message, status, comparator);
    }

    public int getDiscussionMessagesCount(long classNameId, long classPK, int status) {
        MBDiscussion discussion = this.mbDiscussionLocalService.fetchDiscussion(classNameId, classPK);
        if (discussion == null) {
            return 0;
        }
        int count = 0;
        count = status == -1 ? this.mbMessagePersistence.countByThreadId(discussion.getThreadId()) : this.mbMessagePersistence.countByT_S(discussion.getThreadId(), status);
        if (count >= 1) {
            return count - 1;
        }
        return 0;
    }

    public int getDiscussionMessagesCount(String className, long classPK, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getDiscussionMessagesCount(classNameId, classPK, status);
    }

    public List<MBDiscussion> getDiscussions(String className) {
        return this.mbDiscussionLocalService.getDiscussions(className);
    }

    public MBMessage getFileEntryMessage(long fileEntryId) throws PortalException {
        return this.mbMessagePersistence.findByPrimaryKey(this._getFileEntryMessageId(fileEntryId));
    }

    public MBMessage getFirstMessage(long threadId, long parentMessageId) throws PortalException {
        return this.mbMessagePersistence.findByT_P_First(threadId, parentMessageId, null);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        if (status == -1) {
            return this.mbMessagePersistence.findByGroupId(groupId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_S(groupId, status, start, end, obc);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end);
    }

    public List<MBMessage> getGroupMessages(long groupId, long userId, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        if (status == -1) {
            return this.mbMessagePersistence.findByG_U(groupId, userId, start, end, obc);
        }
        return this.mbMessagePersistence.findByG_U_S(groupId, userId, status, start, end, obc);
    }

    public int getGroupMessagesCount(long groupId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByGroupId(groupId);
        }
        return this.mbMessagePersistence.countByG_S(groupId, status);
    }

    public int getGroupMessagesCount(long groupId, long userId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByG_U(groupId, userId);
        }
        return this.mbMessagePersistence.countByG_U_S(groupId, userId, status);
    }

    public MBMessage getLastThreadMessage(long threadId, int status) throws PortalException {
        return this.mbMessagePersistence.findByT_S_Last(threadId, status, null);
    }

    public MBMessage getMessage(long messageId) throws PortalException {
        return this.mbMessagePersistence.findByPrimaryKey(messageId);
    }

    public MBMessageDisplay getMessageDisplay(long userId, long messageId, int status) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        return this.getMessageDisplay(userId, message, status);
    }

    public MBMessageDisplay getMessageDisplay(long userId, MBMessage message, int status) throws PortalException {
        return this.getMessageDisplay(userId, message, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public MBMessageDisplay getMessageDisplay(long userId, MBMessage message, int status, Comparator<MBMessage> comparator) throws PortalException {
        MBCategoryImpl category = null;
        if (message.getCategoryId() != 0L && message.getCategoryId() != -1L) {
            category = this.mbCategoryLocalService.getCategory(message.getCategoryId());
        } else {
            category = new MBCategoryImpl();
            category.setCategoryId(message.getCategoryId());
            category.setDisplayStyle(MBCategoryConstants.DEFAULT_DISPLAY_STYLE);
        }
        MBMessage parentMessage = null;
        if (message.isReply()) {
            parentMessage = this.mbMessagePersistence.findByPrimaryKey(message.getParentMessageId());
        }
        MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
        if (message.isApproved() && !message.isDiscussion()) {
            this.mbThreadLocalService.incrementViewCounter(thread.getThreadId(), 1);
            SocialActivityManagerUtil.addActivity((long)userId, (ClassedModel)thread, (int)10001, (String)"", (long)0L);
        }
        return new MBMessageDisplayImpl(userId, message, parentMessage, category, thread, status, this, comparator);
    }

    public List<MBMessage> getMessages(String className, long classPK, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        if (status == -1) {
            return this.mbMessagePersistence.findByC_C(classNameId, classPK);
        }
        return this.mbMessagePersistence.findByC_C_S(classNameId, classPK, status);
    }

    @Deprecated
    public List<MBMessage> getNoAssetMessages() {
        return this.mbMessageFinder.findByNoAssets();
    }

    public int getPositionInThread(long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageFinder.countByC_T(message.getCreateDate(), message.getThreadId());
    }

    public List<MBMessage> getRootDiscussionMessages(String className, long classPK, int status) throws PortalException {
        return this.getRootDiscussionMessages(className, classPK, status, -1, -1);
    }

    public List<MBMessage> getRootDiscussionMessages(String className, long classPK, int status, int start, int end) throws PortalException {
        long rootDiscussionMessageId = this._getRootDiscussionMessageId(className, classPK);
        return this.getChildMessages(rootDiscussionMessageId, status, start, end);
    }

    public int getRootDiscussionMessagesCount(String className, long classPK, int status) {
        int count;
        block2: {
            count = 0;
            try {
                long rootDiscussionMessageId = this._getRootDiscussionMessageId(className, classPK);
                count = this.getChildMessagesCount(rootDiscussionMessageId, status);
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to obtain root discussion message id for ", "class name ", className, " and class PK ", classPK}), (Throwable)pe);
            }
        }
        return count;
    }

    @Deprecated
    public List<MBMessage> getRootMessages(String className, long classPK, int status) throws PortalException {
        return this.getRootDiscussionMessages(className, classPK, status);
    }

    @Deprecated
    public List<MBMessage> getRootMessages(String className, long classPK, int status, int start, int end) throws PortalException {
        return this.getRootDiscussionMessages(className, classPK, status, start, end);
    }

    @Deprecated
    public int getRootMessagesCount(String className, long classPK, int status) {
        return this.getRootDiscussionMessagesCount(className, classPK, status);
    }

    public String[] getTempAttachmentNames(long groupId, long userId, String folderName) throws PortalException {
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)userId, (String)folderName);
    }

    public List<MBMessage> getThreadMessages(long threadId, int status) {
        return this.getThreadMessages(threadId, status, (Comparator<MBMessage>)new MessageThreadComparator());
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, Comparator<MBMessage> comparator) {
        List messages = null;
        messages = status == -1 ? this.mbMessagePersistence.findByThreadId(threadId) : this.mbMessagePersistence.findByT_S(threadId, status);
        return ListUtil.sort((List)messages, comparator);
    }

    public List<MBMessage> getThreadMessages(long threadId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadId(threadId, start, end);
        }
        return this.mbMessagePersistence.findByT_S(threadId, status, start, end);
    }

    public List<MBMessage> getThreadMessages(long threadId, long parentMessageId) {
        return this.mbMessagePersistence.findByT_P(threadId, parentMessageId);
    }

    public List<MBMessage> getThreadMessages(long userId, long threadId, int status, int start, int end, Comparator<MBMessage> comparator) {
        if (status == -1) {
            OrderByComparator orderByComparator = null;
            if (comparator instanceof OrderByComparator) {
                orderByComparator = (OrderByComparator)comparator;
            }
            List messages = this.mbMessagePersistence.findByT_notS(threadId, 8, start, end, orderByComparator);
            if (!(comparator instanceof OrderByComparator)) {
                messages = ListUtil.sort((List)messages, comparator);
            }
            return messages;
        }
        QueryDefinition queryDefinition = new QueryDefinition(status, userId, true, start, end, null);
        if (comparator instanceof OrderByComparator) {
            queryDefinition.setOrderByComparator((OrderByComparator)comparator);
        }
        List messages = this.mbMessageFinder.findByThreadId(threadId, queryDefinition);
        if (!(comparator instanceof OrderByComparator)) {
            messages = ListUtil.sort((List)messages, comparator);
        }
        return messages;
    }

    public int getThreadMessagesCount(long threadId, boolean answer) {
        return this.mbMessagePersistence.countByT_A(threadId, answer);
    }

    public int getThreadMessagesCount(long threadId, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByThreadId(threadId);
        }
        return this.mbMessagePersistence.countByT_S(threadId, status);
    }

    public List<MBMessage> getThreadRepliesMessages(long threadId, int status, int start, int end) {
        if (status == -1) {
            return this.mbMessagePersistence.findByThreadReplies(threadId, start, end);
        }
        return this.mbMessagePersistence.findByTR_S(threadId, status, start, end);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, long classNameId, long classPK, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        if (status == -1) {
            return this.mbMessagePersistence.findByU_C_C(userId, classNameId, classPK, start, end, obc);
        }
        return this.mbMessagePersistence.findByU_C_C_S(userId, classNameId, classPK, status, start, end, obc);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, long[] classNameIds, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        if (status == -1) {
            return this.mbMessagePersistence.findByU_C(userId, classNameIds, start, end, obc);
        }
        return this.mbMessagePersistence.findByU_C_S(userId, classNameIds, status, start, end, obc);
    }

    public List<MBMessage> getUserDiscussionMessages(long userId, String className, long classPK, int status, int start, int end, OrderByComparator<MBMessage> obc) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getUserDiscussionMessages(userId, classNameId, classPK, status, start, end, obc);
    }

    public int getUserDiscussionMessagesCount(long userId, long classNameId, long classPK, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByU_C_C(userId, classNameId, classPK);
        }
        return this.mbMessagePersistence.countByU_C_C_S(userId, classNameId, classPK, status);
    }

    public int getUserDiscussionMessagesCount(long userId, long[] classNameIds, int status) {
        if (status == -1) {
            return this.mbMessagePersistence.countByU_C(userId, classNameIds);
        }
        return this.mbMessagePersistence.countByU_C_S(userId, classNameIds, status);
    }

    public int getUserDiscussionMessagesCount(long userId, String className, long classPK, int status) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getUserDiscussionMessagesCount(userId, classNameId, classPK, status);
    }

    public long moveMessageAttachmentToTrash(long userId, long messageId, String fileName) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        long folderId = message.getAttachmentsFolderId();
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)message.getGroupId(), (long)folderId, (String)fileName);
        PortletFileRepositoryUtil.movePortletFileEntryToTrash((long)userId, (long)fileEntry.getFileEntryId());
        return fileEntry.getFileEntryId();
    }

    public void restoreMessageAttachmentFromTrash(long userId, long messageId, String deletedFileName) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        Folder folder = message.addAttachmentsFolder();
        PortletFileRepositoryUtil.restorePortletFileEntryFromTrash((long)message.getGroupId(), (long)userId, (long)folder.getFolderId(), (String)deletedFileName);
    }

    public void subscribeMessage(long userId, long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.addSubscription(userId, message.getGroupId(), MBThread.class.getName(), message.getThreadId());
    }

    public void unsubscribeMessage(long userId, long messageId) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.subscriptionLocalService.deleteSubscription(userId, MBThread.class.getName(), message.getThreadId());
    }

    public void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        this.updateAnswer(message, answer, cascade);
    }

    public void updateAnswer(MBMessage message, boolean answer, boolean cascade) throws PortalException {
        if (message.isAnswer() != answer) {
            message.setAnswer(answer);
            message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        }
        if (cascade) {
            List messages = this.mbMessagePersistence.findByT_P(message.getThreadId(), message.getMessageId());
            for (MBMessage curMessage : messages) {
                this.updateAnswer(curMessage, answer, cascade);
            }
        }
    }

    public void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException {
        this.updateAsset(userId, message, assetCategoryIds, assetTagNames, assetLinkEntryIds, true);
    }

    public MBMessage updateDiscussionMessage(long userId, long messageId, String className, long classPK, String subject, String body, ServiceContext serviceContext) throws PortalException {
        subject = this.getDiscussionMessageSubject(subject, body);
        List inputStreamOVPs = null;
        double priority = 0.0;
        boolean allowPingbacks = false;
        serviceContext.setAttribute("className", (Serializable)((Object)className));
        serviceContext.setAttribute("classPK", (Serializable)((Object)String.valueOf(classPK)));
        return this.mbMessageLocalService.updateMessage(userId, messageId, subject, body, inputStreamOVPs, priority, allowPingbacks, serviceContext);
    }

    public MBMessage updateMessage(long userId, long messageId, String body, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        return this.mbMessageLocalService.updateMessage(userId, messageId, message.getSubject(), body, null, message.getPriority(), message.isAllowPingbacks(), serviceContext);
    }

    public MBMessage updateMessage(long userId, long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this._updateMessage(userId, messageId, subject, body, priority, allowPingbacks, serviceContext);
        if (ListUtil.isNotEmpty(inputStreamOVPs)) {
            Folder folder = message.addAttachmentsFolder();
            PortletFileRepositoryUtil.addPortletFileEntries((long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"com.liferay.message.boards", (long)folder.getFolderId(), inputStreamOVPs);
        }
        return message;
    }

    @Deprecated
    public MBMessage updateMessage(long userId, long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this._updateMessage(userId, messageId, subject, body, priority, allowPingbacks, serviceContext);
        if (inputStreamOVPs != null || existingFiles != null) {
            if (ListUtil.isNotEmpty(inputStreamOVPs) || ListUtil.isNotEmpty(existingFiles)) {
                List fileEntries = message.getAttachmentsFileEntries();
                for (FileEntry fileEntry : fileEntries) {
                    String fileEntryId = String.valueOf(fileEntry.getFileEntryId());
                    if (existingFiles == null || existingFiles.contains(fileEntryId)) continue;
                    if (!TrashUtil.isTrashEnabled((long)message.getGroupId())) {
                        this.deleteMessageAttachment(messageId, fileEntry.getTitle());
                        continue;
                    }
                    this.moveMessageAttachmentToTrash(userId, messageId, fileEntry.getTitle());
                }
                Folder folder = message.addAttachmentsFolder();
                PortletFileRepositoryUtil.addPortletFileEntries((long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"com.liferay.message.boards", (long)folder.getFolderId(), inputStreamOVPs);
            } else if (TrashUtil.isTrashEnabled((long)message.getGroupId())) {
                List fileEntries = message.getAttachmentsFileEntries();
                for (FileEntry fileEntry : fileEntries) {
                    this.moveMessageAttachmentToTrash(userId, messageId, fileEntry.getTitle());
                }
            } else {
                this.deleteMessageAttachments(message.getMessageId());
            }
        }
        return message;
    }

    public MBMessage updateStatus(long userId, long messageId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        MBMessage message = this.getMessage(messageId);
        int oldStatus = message.getStatus();
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        Date modifiedDate = serviceContext.getModifiedDate(now);
        message.setStatus(status);
        message.setStatusByUserId(userId);
        message.setStatusByUserName(user.getFullName());
        message.setStatusDate(modifiedDate);
        message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
        this.updateThreadStatus(thread, message, user, oldStatus, modifiedDate);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
        if (status == 0) {
            if (oldStatus != 0 && serviceContext.isAssetEntryVisible() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
                Date publishDate = null;
                AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(message.getWorkflowClassName(), message.getMessageId());
                if (assetEntry != null && assetEntry.getPublishDate() != null) {
                    publishDate = assetEntry.getPublishDate();
                } else {
                    publishDate = now;
                    serviceContext.setCommand("add");
                }
                this.assetEntryLocalService.updateEntry(message.getWorkflowClassName(), message.getMessageId(), publishDate, null, true, true);
            }
            this._updateSocialActivity(user, message, serviceContext);
            this.notifySubscribers(userId, (MBMessage)message.clone(), (String)((Object)workflowContext.get("url")), serviceContext);
            indexer.reindex((Object)message);
            this.pingPingback(message, serviceContext);
        } else if (oldStatus == 0) {
            this.assetEntryLocalService.updateVisible(message.getWorkflowClassName(), message.getMessageId(), false);
            indexer.delete((Object)message);
        }
        if (!message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), userId, serviceContext.getModifiedDate(now));
        }
        return message;
    }

    public void updateUserName(long userId, String userName) {
        List messages = this.mbMessagePersistence.findByUserId(userId);
        for (MBMessage message : messages) {
            message.setUserName(userName);
            this.mbMessagePersistence.update((BaseModel)message);
        }
    }

    protected String getBody(String subject, String body, String format) {
        if (!Validator.isBlank((String)body)) {
            return body;
        }
        if (StringUtil.equals((String)format, (String)"html")) {
            return HtmlUtil.escape((String)subject);
        }
        return subject;
    }

    protected String getDiscussionMessageSubject(String subject, String body) throws MessageBodyException {
        if (Validator.isNotNull((String)subject)) {
            return subject;
        }
        if (Validator.isNull((String)body)) {
            throw new MessageBodyException("Body is null");
        }
        subject = HtmlUtil.extractText((String)body);
        if (subject.length() <= 50) {
            return subject;
        }
        String subjectSubstring = subject.substring(0, 50);
        return subjectSubstring + "...";
    }

    protected String getMessageURL(MBMessage message, ServiceContext serviceContext) throws PortalException {
        String entryURL = GetterUtil.getString((Object)serviceContext.getAttribute("entryURL"));
        if (Validator.isNotNull((String)entryURL)) {
            return entryURL;
        }
        HttpServletRequest request = serviceContext.getRequest();
        if (request == null) {
            if (Validator.isNull((String)serviceContext.getLayoutFullURL())) {
                return "";
            }
            return StringBundler.concat((Object[])new Object[]{serviceContext.getLayoutFullURL(), "/-/", "message_boards/view_message/", message.getMessageId()});
        }
        String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        String layoutURL = LayoutURLUtil.getLayoutURL((long)message.getGroupId(), (String)portletId, (ServiceContext)serviceContext);
        if (Validator.isNotNull((String)layoutURL)) {
            return StringBundler.concat((Object[])new Object[]{layoutURL, "/-/", "message_boards/view_message/", message.getMessageId()});
        }
        Group group = this.groupLocalService.fetchGroup(message.getGroupId());
        portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((HttpServletRequest)request, (Group)group, (String)portletId, (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/message_boards/view_message");
        portletURL.setParameter("messageId", String.valueOf(message.getMessageId()));
        return portletURL.toString();
    }

    protected String getSubject(String subject, String body) {
        if (Validator.isNull((String)subject)) {
            return StringUtil.shorten((String)body);
        }
        return subject;
    }

    protected MBSubscriptionSender getSubscriptionSender(long userId, MBCategory category, MBMessage message, String messageURL, String entryTitle, boolean htmlFormat, String messageBody, String messageSubject, String messageSubjectPrefix, String inReplyTo, String fromName, String fromAddress, String replyToAddress, String emailAddress, String fullName, LocalizedValuesMap subjectLocalizedValuesMap, LocalizedValuesMap bodyLocalizedValuesMap, ServiceContext serviceContext) throws PortalException {
        MBSubscriptionSender subscriptionSender = new MBSubscriptionSender("com.liferay.message.boards");
        subscriptionSender.setAnonymous(message.isAnonymous());
        subscriptionSender.setBulk(PropsValues.MESSAGE_BOARDS_EMAIL_BULK);
        subscriptionSender.setClassName(message.getModelClassName());
        subscriptionSender.setClassPK(message.getMessageId());
        subscriptionSender.setCompanyId(message.getCompanyId());
        subscriptionSender.setContextAttribute("[$MESSAGE_BODY$]", messageBody, false);
        long groupId = message.getGroupId();
        Group group = this.groupLocalService.getGroup(groupId);
        if (category.getCategoryId() != 0L) {
            subscriptionSender.setContextAttribute("[$CATEGORY_NAME$]", category.getName(), true);
        } else {
            subscriptionSender.setLocalizedContextAttribute("[$CATEGORY_NAME$]", new EscapableLocalizableFunction(locale -> MBMessageLocalServiceImpl._getLocalizedRootCategoryName(group, locale)));
        }
        subscriptionSender.setContextAttributes(new Object[]{"[$MAILING_LIST_ADDRESS$]", replyToAddress, "[$MESSAGE_ID$]", message.getMessageId(), "[$MESSAGE_SUBJECT$]", messageSubject, "[$MESSAGE_SUBJECT_PREFIX$]", messageSubjectPrefix, "[$MESSAGE_URL$]", messageURL, "[$MESSAGE_USER_ADDRESS$]", emailAddress, "[$MESSAGE_USER_NAME$]", fullName});
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(entryTitle);
        subscriptionSender.setEntryURL(messageURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setFullName(fullName);
        subscriptionSender.setHtmlFormat(htmlFormat);
        subscriptionSender.setInReplyTo(inReplyTo);
        subscriptionSender.setLocalizedContextAttribute("[$SITE_NAME$]", new EscapableLocalizableFunction(locale -> this._getGroupDescriptiveName(group, (Locale)locale)));
        if (bodyLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        }
        if (subjectLocalizedValuesMap != null) {
            subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        }
        Date modifiedDate = message.getModifiedDate();
        subscriptionSender.setMailId("mb_message.", new Object[]{message.getCategoryId(), message.getMessageId(), modifiedDate.getTime()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setReplyToAddress(replyToAddress);
        subscriptionSender.setScopeGroupId(groupId);
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUniqueMailId(false);
        return subscriptionSender;
    }

    protected void notifyDiscussionSubscribers(long userId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        Map localizedSubjectMap;
        CommentGroupServiceConfiguration commentGroupServiceConfiguration = this._getCommentGroupServiceConfiguration(message.getGroupId());
        MBDiscussion mbDiscussion = this.mbDiscussionLocalService.getThreadDiscussion(message.getThreadId());
        String contentURL = (String)((Object)serviceContext.getAttribute("contentURL"));
        contentURL = this.http.addParameter(contentURL, serviceContext.getAttribute("namespace") + "messageId", message.getMessageId());
        String userAddress = "";
        String userName = (String)((Object)serviceContext.getAttribute("pingbackUserName"));
        if (Validator.isNull((String)userName)) {
            userAddress = this.portal.getUserEmailAddress(message.getUserId());
            userName = this.portal.getUserName(message.getUserId(), "");
        }
        MBDiscussionSubcriptionSender subscriptionSender = new MBDiscussionSubcriptionSender(commentGroupServiceConfiguration);
        subscriptionSender.setCompanyId(message.getCompanyId());
        subscriptionSender.setClassName(MBDiscussion.class.getName());
        subscriptionSender.setClassPK(mbDiscussion.getDiscussionId());
        subscriptionSender.setContextAttribute("[$COMMENTS_BODY$]", message.getBody(message.isFormatBBCode()), false);
        subscriptionSender.setContextAttributes(new Object[]{"[$COMMENTS_USER_ADDRESS$]", userAddress, "[$COMMENTS_USER_NAME$]", userName, "[$CONTENT_URL$]", contentURL});
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(message.getBody());
        subscriptionSender.setEntryURL(contentURL);
        subscriptionSender.setFrom(commentGroupServiceConfiguration.emailFromAddress(), commentGroupServiceConfiguration.emailFromName());
        subscriptionSender.setHtmlFormat(true);
        Map localizedBodyMap = LocalizationUtil.getMap((LocalizedValuesMap)commentGroupServiceConfiguration.discussionEmailBody());
        if (localizedBodyMap != null) {
            subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        }
        if ((localizedSubjectMap = LocalizationUtil.getMap((LocalizedValuesMap)commentGroupServiceConfiguration.discussionEmailSubject())) != null) {
            subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        }
        Date modifiedDate = message.getModifiedDate();
        subscriptionSender.setMailId("mb_discussion", new Object[]{message.getCategoryId(), message.getMessageId(), modifiedDate.getTime()});
        int notificationType = 0;
        if (serviceContext.isCommandUpdate()) {
            notificationType = 1;
        }
        subscriptionSender.setNotificationType(notificationType);
        String portletId = PortletProviderUtil.getPortletId((String)Comment.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        subscriptionSender.setPortletId(portletId);
        subscriptionSender.setScopeGroupId(message.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUniqueMailId(false);
        String className = (String)((Object)serviceContext.getAttribute("className"));
        long classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK");
        subscriptionSender.addPersistedSubscribers(MBUtil.getSubscriptionClassName((String)className), classPK);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void notifySubscribers(long userId, MBMessage message, String messageURL, ServiceContext serviceContext) throws PortalException {
        long categoryId;
        if (!message.isApproved() || Validator.isNull((String)messageURL)) {
            return;
        }
        if (message.isDiscussion()) {
            try {
                this.notifyDiscussionSubscribers(userId, message, serviceContext);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            return;
        }
        MBGroupServiceSettings mbGroupServiceSettings = MBGroupServiceSettings.getInstance((long)message.getGroupId());
        if (!(serviceContext.isCommandAdd() && mbGroupServiceSettings.isEmailMessageAddedEnabled() || serviceContext.isCommandUpdate() && mbGroupServiceSettings.isEmailMessageUpdatedEnabled())) {
            return;
        }
        Company company = this.companyLocalService.getCompany(message.getCompanyId());
        User user = this.userLocalService.getUser(userId);
        String emailAddress = user.getEmailAddress();
        String fullName = user.getFullName();
        if (message.isAnonymous()) {
            emailAddress = "";
            fullName = serviceContext.translate("anonymous", new Object[0]);
        }
        MBCategory category = message.getCategory();
        ArrayList<Long> categoryIds = new ArrayList<Long>();
        categoryIds.add(message.getCategoryId());
        if (message.getCategoryId() != 0L) {
            categoryIds.addAll(category.getAncestorCategoryIds());
        }
        String entryTitle = message.getSubject();
        String fromName = mbGroupServiceSettings.getEmailFromName();
        String fromAddress = mbGroupServiceSettings.getEmailFromAddress();
        String replyToAddress = "";
        if (PropsValues.POP_SERVER_NOTIFICATIONS_ENABLED) {
            replyToAddress = MBMailUtil.getReplyToAddress(message.getCategoryId(), message.getMessageId(), company.getMx(), fromAddress);
        }
        LocalizedValuesMap subjectLocalizedValuesMap = null;
        LocalizedValuesMap bodyLocalizedValuesMap = null;
        if (serviceContext.isCommandUpdate()) {
            subjectLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageUpdatedSubject();
            bodyLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageUpdatedBody();
        } else {
            subjectLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageAddedSubject();
            bodyLocalizedValuesMap = mbGroupServiceSettings.getEmailMessageAddedBody();
        }
        boolean htmlFormat = mbGroupServiceSettings.isEmailHtmlFormat();
        String messageBody = message.getBody();
        if (htmlFormat && message.isFormatBBCode()) {
            try {
                messageBody = BBCodeTranslatorUtil.getHTML((String)messageBody);
                HttpServletRequest request = serviceContext.getRequest();
                if (request != null) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    messageBody = com.liferay.message.boards.internal.util.MBUtil.replaceMessageBodyPaths(themeDisplay, messageBody);
                }
            }
            catch (Exception e) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse message ", message.getMessageId(), ": ", e.getMessage()}));
            }
        }
        String inReplyTo = null;
        String messageSubject = message.getSubject();
        String messageSubjectPrefix = "";
        if (message.getParentMessageId() != 0L) {
            MBMessage parentMessage = this.mbMessageLocalService.getMessage(message.getParentMessageId());
            Date modifiedDate = parentMessage.getModifiedDate();
            inReplyTo = this.portal.getMailId(company.getMx(), "mb_message.", new Object[]{message.getCategoryId(), parentMessage.getMessageId(), modifiedDate.getTime()});
            if (messageSubject.startsWith("RE: ")) {
                messageSubjectPrefix = "RE: ";
                messageSubject = messageSubject.substring(messageSubjectPrefix.length());
            }
        }
        MBSubscriptionSender subscriptionSender = this.getSubscriptionSender(userId, category, message, messageURL, entryTitle, htmlFormat, messageBody, messageSubject, messageSubjectPrefix, inReplyTo, fromName, fromAddress, replyToAddress, emailAddress, fullName, subjectLocalizedValuesMap, bodyLocalizedValuesMap, serviceContext);
        subscriptionSender.addPersistedSubscribers(MBCategory.class.getName(), message.getGroupId());
        Iterator iterator = categoryIds.iterator();
        while (iterator.hasNext()) {
            categoryId = (Long)iterator.next();
            if (categoryId == 0L) continue;
            subscriptionSender.addPersistedSubscribers(MBCategory.class.getName(), categoryId);
        }
        subscriptionSender.addPersistedSubscribers(MBThread.class.getName(), message.getThreadId());
        subscriptionSender.flushNotificationsAsync();
        if (!MailingListThreadLocal.isSourceMailingList()) {
            iterator = categoryIds.iterator();
            while (iterator.hasNext()) {
                categoryId = (Long)iterator.next();
                MBSubscriptionSender sourceMailingListSubscriptionSender = this.getSubscriptionSender(userId, category, message, messageURL, entryTitle, htmlFormat, messageBody, messageSubject, messageSubjectPrefix, inReplyTo, fromName, fromAddress, replyToAddress, emailAddress, fullName, subjectLocalizedValuesMap, bodyLocalizedValuesMap, serviceContext);
                sourceMailingListSubscriptionSender.setBulk(false);
                sourceMailingListSubscriptionSender.addMailingListSubscriber(message.getGroupId(), categoryId);
                sourceMailingListSubscriptionSender.flushNotificationsAsync();
            }
        }
    }

    protected void pingPingback(MBMessage message, ServiceContext serviceContext) {
        if (!(PropsValues.BLOGS_PINGBACK_ENABLED && message.isAllowPingbacks() && message.isApproved())) {
            return;
        }
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        String sourceUri = StringBundler.concat((Object[])new Object[]{layoutFullURL, "/-/", "message_boards/view_message/", message.getMessageId()});
        Source source = new Source((CharSequence)message.getBody(message.isFormatBBCode()));
        List startTags = source.getAllStartTags("a");
        for (StartTag startTag : startTags) {
            String targetUri = startTag.getAttributeValue("href");
            if (!Validator.isNotNull((String)targetUri)) continue;
            try {
                LinkbackProducerUtil.sendPingback((String)sourceUri, (String)targetUri);
            }
            catch (Exception e) {
                _log.error((Object)("Error while sending pingback " + targetUri), (Throwable)e);
            }
        }
    }

    protected void startWorkflowInstance(long userId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("url", this.getMessageURL(message, serviceContext));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)message.getCompanyId(), (long)message.getGroupId(), (long)userId, (String)message.getWorkflowClassName(), (long)message.getMessageId(), (Object)message, (ServiceContext)serviceContext, workflowContext);
    }

    protected void updateAsset(long userId, MBMessage message, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds, boolean assetEntryVisible) throws PortalException {
        boolean visible = false;
        Date publishDate = null;
        if (assetEntryVisible && message.isApproved() && (message.getClassNameId() == 0L || message.getParentMessageId() != 0L)) {
            visible = true;
            publishDate = message.getModifiedDate();
        }
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, message.getGroupId(), message.getCreateDate(), message.getModifiedDate(), message.getWorkflowClassName(), message.getMessageId(), message.getUuid(), 0L, assetCategoryIds, assetTagNames, true, visible, null, null, publishDate, null, "text/html", message.getSubject(), null, null, null, null, 0, 0, Double.valueOf(message.getPriority()));
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    protected void updatePriorities(long threadId, double priority) {
        List messages = this.mbMessagePersistence.findByThreadId(threadId);
        for (MBMessage message : messages) {
            if (message.getPriority() == priority) continue;
            message.setPriority(priority);
            this.mbMessagePersistence.update((BaseModel)message);
        }
    }

    protected void updateThreadStatus(MBThread thread, MBMessage message, User user, int oldStatus, Date modifiedDate) throws PortalException {
        int status = message.getStatus();
        if (status == oldStatus) {
            return;
        }
        MBCategory category = null;
        if (thread.getCategoryId() != 0L && thread.getCategoryId() != -1L) {
            category = this.mbCategoryLocalService.getCategory(thread.getCategoryId());
        }
        if (thread.getRootMessageId() == message.getMessageId()) {
            thread.setModifiedDate(modifiedDate);
            thread.setStatus(status);
            thread.setStatusByUserId(user.getUserId());
            thread.setStatusByUserName(user.getFullName());
            thread.setStatusDate(modifiedDate);
        }
        if (status == 0) {
            if (message.isAnonymous()) {
                thread.setLastPostByUserId(0L);
            } else {
                thread.setLastPostByUserId(message.getUserId());
            }
            thread.setLastPostDate(modifiedDate);
            if (category != null) {
                category.setLastPostDate(modifiedDate);
                category = this.mbCategoryLocalService.updateMBCategory(category);
            }
        }
        if (oldStatus == 0 || status == 0) {
            com.liferay.message.boards.internal.util.MBUtil.updateThreadMessageCount(thread.getThreadId());
            if (category != null && thread.getRootMessageId() == message.getMessageId()) {
                com.liferay.message.boards.internal.util.MBUtil.updateCategoryStatistics(category.getCategoryId());
            }
            if (category != null && thread.getRootMessageId() != message.getMessageId()) {
                com.liferay.message.boards.internal.util.MBUtil.updateCategoryMessageCount(category.getCategoryId());
            }
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBThread.class);
        indexer.reindex((Object)thread);
        this.mbThreadLocalService.updateMBThread(thread);
    }

    protected void validate(String subject, String body) throws PortalException {
        if (Validator.isNull((String)subject) && Validator.isNull((String)body)) {
            throw new MessageSubjectException("Subject and body are null");
        }
    }

    protected void validateDiscussionMaxComments(String className, long classPK) throws PortalException {
        if (PropsValues.DISCUSSION_MAX_COMMENTS <= 0) {
            return;
        }
        int count = this.mbMessageLocalService.getDiscussionMessagesCount(className, classPK, 0);
        if (count >= PropsValues.DISCUSSION_MAX_COMMENTS) {
            int max = PropsValues.DISCUSSION_MAX_COMMENTS - 1;
            throw new DiscussionMaxCommentsException(count + " exceeds " + max);
        }
    }

    private static String _getLocalizedRootCategoryName(Group group, Locale locale) {
        try {
            return LanguageUtil.get((Locale)locale, (String)"home") + " - " + group.getDescriptiveName(locale);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get descriptive name for group " + group.getGroupId()), (Throwable)pe);
            return LanguageUtil.get((Locale)locale, (String)"home");
        }
    }

    private CommentGroupServiceConfiguration _getCommentGroupServiceConfiguration(long groupId) throws ConfigurationException {
        return (CommentGroupServiceConfiguration)this.configurationProvider.getConfiguration(CommentGroupServiceConfiguration.class, (SettingsLocator)new GroupServiceSettingsLocator(groupId, "com.liferay.message.boards"));
    }

    private long _getFileEntryMessageId(long fileEntryId) throws PortalException {
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)fileEntry.getFolderId());
        return GetterUtil.getLong((String)folder.getName());
    }

    private String _getGroupDescriptiveName(Group group, Locale locale) {
        try {
            return group.getDescriptiveName(locale);
        }
        catch (PortalException pe) {
            _log.error((Object)("Unable to get descriptive name for group " + group.getGroupId()), (Throwable)pe);
            return "";
        }
    }

    private long _getRootDiscussionMessageId(String className, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        MBMessage message = this.mbMessagePersistence.findByC_C_First(classNameId, classPK, (OrderByComparator)new MessageCreateDateComparator(true));
        return message.getMessageId();
    }

    private MBMessage _updateMessage(long userId, long messageId, String subject, String body, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        MBMessage message = this.mbMessagePersistence.findByPrimaryKey(messageId);
        int oldStatus = message.getStatus();
        String oldSubject = message.getSubject();
        Date modifiedDate = serviceContext.getModifiedDate(null);
        subject = ModelHintsUtil.trimString((String)MBMessage.class.getName(), (String)"subject", (String)subject);
        subject = this.getSubject(subject, body);
        body = this.getBody(subject, body, message.getFormat());
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("discussion", message.isDiscussion());
        body = SanitizerUtil.sanitize((long)message.getCompanyId(), (long)message.getGroupId(), (long)userId, (String)MBMessage.class.getName(), (long)messageId, (String)("text/" + message.getFormat()), (String)"ALL", (String)body, options);
        this.validate(subject, body);
        message.setModifiedDate(modifiedDate);
        message.setSubject(subject);
        message.setBody(body);
        message.setAllowPingbacks(allowPingbacks);
        if (priority != -1.0) {
            message.setPriority(priority);
        }
        MBThread thread = this.mbThreadLocalService.getThread(message.getThreadId());
        if (serviceContext.getWorkflowAction() == 2 && !message.isDraft() && !message.isPending()) {
            message.setStatus(2);
            User user = this.userLocalService.getUser(userId);
            this.updateThreadStatus(thread, message, user, oldStatus, modifiedDate);
            this.assetEntryLocalService.updateVisible(message.getWorkflowClassName(), message.getMessageId(), false);
            if (!message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(MBMessage.class);
                indexer.delete((Object)message);
            }
        }
        message.setExpandoBridgeAttributes(serviceContext);
        message = (MBMessage)this.mbMessagePersistence.update((BaseModel)message);
        if (serviceContext.getWorkflowAction() == 2 && !message.isDiscussion()) {
            this.mbStatsUserLocalService.updateStatsUser(message.getGroupId(), userId, message.getModifiedDate());
        }
        if (priority != -1.0 && thread.getPriority() != priority) {
            thread.setPriority(priority);
            this.mbThreadLocalService.updateMBThread(thread);
            this.updatePriorities(thread.getThreadId(), priority);
        }
        if (message.isRoot()) {
            if (!Objects.equals(subject, oldSubject)) {
                thread.setTitle(subject);
            }
            this.mbThreadLocalService.updateMBThread(thread);
        }
        this.updateAsset(userId, message, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        this.startWorkflowInstance(userId, message, serviceContext);
        return message;
    }

    private void _updateSocialActivity(User user, MBMessage message, ServiceContext serviceContext) throws PortalException {
        long classPK;
        String className;
        AssetEntry assetEntry;
        long parentMessageId;
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        String title = message.getSubject();
        if (message.isDiscussion()) {
            title = HtmlUtil.stripHtml((String)title);
        }
        extraDataJSONObject.put("title", title);
        if (!message.isDiscussion()) {
            if (!message.isAnonymous() && !user.isDefaultUser()) {
                long receiverUserId = 0L;
                MBMessage parentMessage = this.mbMessagePersistence.fetchByPrimaryKey(message.getParentMessageId());
                if (parentMessage != null) {
                    receiverUserId = parentMessage.getUserId();
                }
                int activityKey = 3;
                if (serviceContext.isCommandAdd()) {
                    activityKey = 1;
                }
                SocialActivityManagerUtil.addActivity((long)message.getUserId(), (ClassedModel)message, (int)activityKey, (String)extraDataJSONObject.toString(), (long)receiverUserId);
                if (parentMessage != null && receiverUserId != message.getUserId()) {
                    SocialActivityManagerUtil.addActivity((long)message.getUserId(), (ClassedModel)parentMessage, (int)2, (String)extraDataJSONObject.toString(), (long)0L);
                }
            }
        } else if (serviceContext.isCommandAdd() && (parentMessageId = message.getParentMessageId()) != 0L && (assetEntry = this.assetEntryLocalService.fetchEntry(className = (String)((Object)serviceContext.getAttribute("className")), classPK = ParamUtil.getLong((ServiceContext)serviceContext, (String)"classPK"))) != null) {
            extraDataJSONObject.put("messageId", message.getMessageId());
            SocialActivityManagerUtil.addActivity((long)message.getUserId(), (ClassedModel)assetEntry, (int)10005, (String)extraDataJSONObject.toString(), (long)assetEntry.getUserId());
        }
    }
}

