/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.service.base.MBBanServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.spring.extender.service.ServiceReference;

public class MBBanServiceImpl
extends MBBanServiceBaseImpl {
    private static volatile PortletResourcePermission _portletResourcePermission = PortletResourcePermissionFactory.getInstance(MBBanServiceImpl.class, (String)"_portletResourcePermission", (String)"com.liferay.message.boards");
    @ServiceReference(type=Portal.class)
    private Portal _portal;
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public MBBan addBan(long banUserId, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        _portletResourcePermission.check(permissionChecker, serviceContext.getScopeGroupId(), "BAN_USER");
        User banUser = this._userLocalService.getUser(banUserId);
        boolean groupAdmin = false;
        try {
            groupAdmin = this._portal.isGroupAdmin(banUser, serviceContext.getScopeGroupId());
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        if (groupAdmin) {
            throw new PrincipalException();
        }
        return this.mbBanLocalService.addBan(this.getUserId(), banUserId, serviceContext);
    }

    public void deleteBan(long banUserId, ServiceContext serviceContext) throws PortalException {
        _portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "BAN_USER");
        this.mbBanLocalService.deleteBan(banUserId, serviceContext);
    }
}

