/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.service.impl;

import com.liferay.message.boards.exception.BannedUserException;
import com.liferay.message.boards.model.MBBan;
import com.liferay.message.boards.service.base.MBBanLocalServiceBaseImpl;
import com.liferay.message.boards.util.MBUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.util.PropsValues;
import java.util.Date;
import java.util.List;

public class MBBanLocalServiceImpl
extends MBBanLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(MBBanLocalServiceImpl.class);
    @ServiceReference(type=UserLocalService.class)
    private UserLocalService _userLocalService;

    public MBBan addBan(long userId, long banUserId, ServiceContext serviceContext) throws PortalException {
        long groupId = serviceContext.getScopeGroupId();
        MBBan ban = this.mbBanPersistence.fetchByG_B(groupId, banUserId);
        if (ban == null) {
            Date now = new Date();
            long banId = this.counterLocalService.increment();
            ban = this.mbBanPersistence.create(banId);
            ban.setUuid(serviceContext.getUuid());
            ban.setGroupId(groupId);
            User user = this._userLocalService.getUser(userId);
            ban.setCompanyId(user.getCompanyId());
            ban.setUserId(user.getUserId());
            ban.setUserName(user.getFullName());
            ban.setCreateDate(serviceContext.getCreateDate(now));
            ban.setModifiedDate(serviceContext.getModifiedDate(now));
            ban.setBanUserId(banUserId);
        }
        return (MBBan)this.mbBanPersistence.update((BaseModel)ban);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkBan(long groupId, long banUserId) throws PortalException {
        if (this.hasBan(groupId, banUserId)) {
            throw new BannedUserException("Banned user " + banUserId);
        }
    }

    public void deleteBan(long banId) throws PortalException {
        MBBan ban = this.mbBanPersistence.findByPrimaryKey(banId);
        this.mbBanLocalService.deleteBan(ban);
    }

    public void deleteBan(long banUserId, ServiceContext serviceContext) {
        long groupId = serviceContext.getScopeGroupId();
        MBBan ban = this.mbBanPersistence.fetchByG_B(groupId, banUserId);
        if (ban != null) {
            this.mbBanLocalService.deleteBan(ban);
        }
    }

    @SystemEvent(type=1)
    public void deleteBan(MBBan ban) {
        this.mbBanPersistence.remove((BaseModel)ban);
    }

    public void deleteBansByBanUserId(long banUserId) {
        List bans = this.mbBanPersistence.findByBanUserId(banUserId);
        for (MBBan ban : bans) {
            this.mbBanLocalService.deleteBan(ban);
        }
    }

    public void deleteBansByGroupId(long groupId) {
        List bans = this.mbBanPersistence.findByGroupId(groupId);
        for (MBBan ban : bans) {
            this.mbBanLocalService.deleteBan(ban);
        }
    }

    public void expireBans() {
        if (PropsValues.MESSAGE_BOARDS_EXPIRE_BAN_INTERVAL <= 0) {
            return;
        }
        long now = System.currentTimeMillis();
        List bans = this.mbBanPersistence.findAll();
        for (MBBan ban : bans) {
            Date unbanDate = MBUtil.getUnbanDate((MBBan)ban, (int)PropsValues.MESSAGE_BOARDS_EXPIRE_BAN_INTERVAL);
            long unbanTime = unbanDate.getTime();
            if (now < unbanTime) continue;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Auto expiring ban ", ban.getBanId(), " on user ", ban.getBanUserId()}));
            }
            this.mbBanPersistence.remove((BaseModel)ban);
        }
    }

    public List<MBBan> getBans(long groupId, int start, int end) {
        return this.mbBanPersistence.findByGroupId(groupId, start, end);
    }

    public int getBansCount(long groupId) {
        return this.mbBanPersistence.countByGroupId(groupId);
    }

    public boolean hasBan(long groupId, long banUserId) {
        return this.mbBanPersistence.fetchByG_B(groupId, banUserId) != null;
    }
}

