/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.model.impl;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBMessageDisplay;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.model.MBTreeWalker;
import com.liferay.message.boards.model.impl.MBTreeWalkerImpl;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.util.PropsValues;
import java.util.Comparator;

public class MBMessageDisplayImpl
implements MBMessageDisplay {
    private final MBCategory _category;
    private final int _discussionMessagesCount;
    private final MBMessage _message;
    private final MBMessage _parentMessage;
    private final MBThread _thread;
    private final MBTreeWalker _treeWalker;

    public MBMessageDisplayImpl(long userId, MBMessage message, MBMessage parentMessage, MBCategory category, MBThread thread, int status, MBMessageLocalService messageLocalService, Comparator<MBMessage> comparator) {
        this._message = message;
        this._parentMessage = parentMessage;
        this._category = category;
        this._thread = thread;
        this._treeWalker = new MBTreeWalkerImpl(userId, message.getThreadId(), status, messageLocalService, comparator);
        int dicussionMessagesCount = 0;
        if (message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0) {
            dicussionMessagesCount = messageLocalService.getDiscussionMessagesCount(message.getClassName(), message.getClassPK(), 0);
        }
        this._discussionMessagesCount = dicussionMessagesCount;
    }

    public MBCategory getCategory() {
        return this._category;
    }

    public MBMessage getMessage() {
        return this._message;
    }

    public MBMessage getParentMessage() {
        return this._parentMessage;
    }

    public MBThread getThread() {
        return this._thread;
    }

    public MBTreeWalker getTreeWalker() {
        return this._treeWalker;
    }

    public boolean isDiscussionMaxComments() {
        return this._message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0 && PropsValues.DISCUSSION_MAX_COMMENTS <= this._discussionMessagesCount;
    }
}

