/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.util;

import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.service.MBMessageLocalServiceUtil;
import com.liferay.message.boards.service.MBThreadLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class MBUtil {
    public static void propagatePermissions(long companyId, long groupId, long parentMessageId, ServiceContext serviceContext) throws PortalException {
        MBMessage parentMessage = MBMessageLocalServiceUtil.getMBMessage((long)parentMessageId);
        Role defaultGroupRole = RoleLocalServiceUtil.getDefaultGroupRole((long)groupId);
        Role guestRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        List actionIds = ResourceActionsUtil.getModelResourceActions((String)MBMessage.class.getName());
        Map roleIdsToActionIds = ResourcePermissionLocalServiceUtil.getAvailableResourcePermissionActionIds((long)companyId, (String)MBMessage.class.getName(), (int)4, (String)String.valueOf(parentMessage.getMessageId()), (Collection)actionIds);
        String[] groupPermissions = MBUtil._getRolePermissions(defaultGroupRole, roleIdsToActionIds);
        String[] guestPermissions = MBUtil._getRolePermissions(guestRole, roleIdsToActionIds);
        ModelPermissions modelPermissions = ModelPermissionsFactory.create((String[])groupPermissions, (String[])guestPermissions);
        serviceContext.setModelPermissions(modelPermissions);
    }

    public static String replaceMessageBodyPaths(ThemeDisplay themeDisplay, String messageBody) {
        return StringUtil.replace((String)messageBody, (String[])new String[]{"@theme_images_path@", "href=\"/", "src=\"/"}, (String[])new String[]{themeDisplay.getPathThemeImages(), "href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
    }

    public static void updateCategoryMessageCount(final long categoryId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBCategoryLocalServiceUtil.updateMessageCount((long)categoryId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryStatistics(final long categoryId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBCategoryLocalServiceUtil.updateStatistics((long)categoryId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public static void updateCategoryThreadCount(final long categoryId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBCategoryLocalServiceUtil.updateThreadCount((long)categoryId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public static void updateThreadMessageCount(final long threadId) {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MBThreadLocalServiceUtil.updateMessageCount((long)threadId);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    private static String[] _getRolePermissions(Role role, Map<Long, Set<String>> roleIdsToActionIds) {
        String[] rolePermissions = null;
        Set<String> defaultRoleActionIds = roleIdsToActionIds.get(role.getRoleId());
        rolePermissions = defaultRoleActionIds != null ? defaultRoleActionIds.toArray(new String[0]) : new String[]{};
        return rolePermissions;
    }
}

