/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.upgrade.v1_0_1;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.portal.kernel.dao.db.DBProcessContext;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeStep;

public class UpgradeUnsupportedGuestPermissions
implements UpgradeStep {
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;

    public UpgradeUnsupportedGuestPermissions(ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) {
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
    }

    public void upgrade(DBProcessContext dbProcessContext) throws UpgradeException {
        this._removeResourceActions(MBCategory.class.getName(), "DELETE");
        this._removeResourceActions(MBCategory.class.getName(), "MOVE_THREAD");
        this._removeResourceActions(MBCategory.class.getName(), "PERMISSIONS");
        this._removeResourceActions(MBMessage.class.getName(), "DELETE");
        this._removeResourceActions(MBMessage.class.getName(), "PERMISSIONS");
        this._removeResourceActions("com.liferay.message.boards", "LOCK_THREAD");
        this._removeResourceActions("com.liferay.message.boards", "MOVE_THREAD");
        this._removeResourceActions(MBThread.class.getName(), "DELETE");
    }

    private void _removeResourceAction(ResourcePermission resourcePermission, ResourceAction resourceAction) throws PortalException {
        Role guestRole = this._roleLocalService.getRole(resourcePermission.getCompanyId(), "Guest");
        if (guestRole.getRoleId() != resourcePermission.getRoleId()) {
            return;
        }
        if (this._resourcePermissionLocalService.hasActionId(resourcePermission, resourceAction)) {
            resourcePermission.removeResourceAction(resourceAction.getActionId());
            this._resourcePermissionLocalService.updateResourcePermission(resourcePermission);
        }
    }

    private void _removeResourceActions(String resourceName, String actionId) throws UpgradeException {
        try {
            ResourceAction resourceAction = this._resourceActionLocalService.fetchResourceAction(resourceName, actionId);
            if (resourceAction == null) {
                return;
            }
            ActionableDynamicQuery actionableDynamicQuery = this._resourcePermissionLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)resourceName)));
            actionableDynamicQuery.setPerformActionMethod(resourcePermission -> this._removeResourceAction((ResourcePermission)resourcePermission, resourceAction));
            actionableDynamicQuery.performActions();
        }
        catch (PortalException pe) {
            throw new UpgradeException((Throwable)pe);
        }
    }
}

