/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.service;

import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBMessageDisplay;
import com.liferay.message.boards.kernel.service.MBMessageServiceWrapper;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.petra.model.adapter.util.ModelAdapterUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class ModularMBMessageServiceWrapper
extends MBMessageServiceWrapper {
    @Reference
    private MBMessageService _mbMessageService;

    public ModularMBMessageServiceWrapper() {
        super(null);
    }

    public ModularMBMessageServiceWrapper(com.liferay.message.boards.kernel.service.MBMessageService mbMessageService) {
        super(mbMessageService);
    }

    public MBMessage addDiscussionMessage(long groupId, String className, long classPK, long threadId, long parentMessageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.addDiscussionMessage(groupId, className, classPK, threadId, parentMessageId, subject, body, serviceContext));
    }

    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.addMessage(groupId, categoryId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext));
    }

    public MBMessage addMessage(long groupId, long categoryId, String subject, String body, String format, String fileName, File file, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws FileNotFoundException, PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.addMessage(groupId, categoryId, subject, body, format, fileName, file, anonymous, priority, allowPingbacks, serviceContext));
    }

    public MBMessage addMessage(long categoryId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.addMessage(categoryId, subject, body, serviceContext));
    }

    public MBMessage addMessage(long parentMessageId, String subject, String body, String format, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, boolean anonymous, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.addMessage(parentMessageId, subject, body, format, inputStreamOVPs, anonymous, priority, allowPingbacks, serviceContext));
    }

    public void addMessageAttachment(long messageId, String fileName, File file, String mimeType) throws PortalException {
        this._mbMessageService.addMessageAttachment(messageId, fileName, file, mimeType);
    }

    public void deleteDiscussionMessage(long messageId) throws PortalException {
        this._mbMessageService.deleteDiscussionMessage(messageId);
    }

    public void deleteDiscussionMessage(long groupId, String className, long classPK, String permissionClassName, long permissionClassPK, long permissionOwnerId, long messageId) throws PortalException {
        super.deleteDiscussionMessage(groupId, className, classPK, permissionClassName, permissionClassPK, permissionOwnerId, messageId);
    }

    public void deleteMessage(long messageId) throws PortalException {
        this._mbMessageService.deleteMessage(messageId);
    }

    public void deleteMessageAttachment(long messageId, String fileName) throws PortalException {
        this._mbMessageService.deleteMessageAttachment(messageId, fileName);
    }

    public void deleteMessageAttachments(long messageId) throws PortalException {
        this._mbMessageService.deleteMessageAttachments(messageId);
    }

    public void emptyMessageAttachments(long messageId) throws PortalException {
        this._mbMessageService.emptyMessageAttachments(messageId);
    }

    public List<MBMessage> getCategoryMessages(long groupId, long categoryId, int status, int start, int end) throws PortalException {
        return ModelAdapterUtil.adapt(MBMessage.class, (List)this._mbMessageService.getCategoryMessages(groupId, categoryId, status, start, end));
    }

    public int getCategoryMessagesCount(long groupId, long categoryId, int status) {
        return this._mbMessageService.getCategoryMessagesCount(groupId, categoryId, status);
    }

    public String getCategoryMessagesRSS(long groupId, long categoryId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return this._mbMessageService.getCategoryMessagesRSS(groupId, categoryId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public String getCompanyMessagesRSS(long companyId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return this._mbMessageService.getCompanyMessagesRSS(companyId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public int getGroupMessagesCount(long groupId, int status) {
        return this._mbMessageService.getGroupMessagesCount(groupId, status);
    }

    public String getGroupMessagesRSS(long groupId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return this._mbMessageService.getGroupMessagesRSS(groupId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public String getGroupMessagesRSS(long groupId, long userId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return this._mbMessageService.getGroupMessagesRSS(groupId, userId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public MBMessage getMessage(long messageId) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.getMessage(messageId));
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status) throws PortalException {
        return (MBMessageDisplay)ModelAdapterUtil.adapt(MBMessageDisplay.class, (Object)this._mbMessageService.getMessageDisplay(messageId, status));
    }

    public MBMessageDisplay getMessageDisplay(long messageId, int status, String threadView, boolean includePrevAndNext) throws PortalException {
        return super.getMessageDisplay(messageId, status, threadView, includePrevAndNext);
    }

    public String getOSGiServiceIdentifier() {
        return this._mbMessageService.getOSGiServiceIdentifier();
    }

    public int getThreadAnswersCount(long groupId, long categoryId, long threadId) {
        return this._mbMessageService.getThreadAnswersCount(groupId, categoryId, threadId);
    }

    public List<MBMessage> getThreadMessages(long groupId, long categoryId, long threadId, int status, int start, int end) {
        return ModelAdapterUtil.adapt(MBMessage.class, (List)this._mbMessageService.getThreadMessages(groupId, categoryId, threadId, status, start, end));
    }

    public int getThreadMessagesCount(long groupId, long categoryId, long threadId, int status) {
        return this._mbMessageService.getThreadMessagesCount(groupId, categoryId, threadId, status);
    }

    public String getThreadMessagesRSS(long threadId, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException {
        return this._mbMessageService.getThreadMessagesRSS(threadId, status, max, type, version, displayStyle, feedURL, entryURL, themeDisplay);
    }

    public com.liferay.message.boards.kernel.service.MBMessageService getWrappedService() {
        return super.getWrappedService();
    }

    public void restoreMessageAttachmentFromTrash(long messageId, String fileName) throws PortalException {
        this._mbMessageService.restoreMessageAttachmentFromTrash(messageId, fileName);
    }

    public void setWrappedService(com.liferay.message.boards.kernel.service.MBMessageService mbMessageService) {
        super.setWrappedService(mbMessageService);
    }

    public void subscribeMessage(long messageId) throws PortalException {
        this._mbMessageService.subscribeMessage(messageId);
    }

    public void unsubscribeMessage(long messageId) throws PortalException {
        this._mbMessageService.unsubscribeMessage(messageId);
    }

    public void updateAnswer(long messageId, boolean answer, boolean cascade) throws PortalException {
        this._mbMessageService.updateAnswer(messageId, answer, cascade);
    }

    public MBMessage updateDiscussionMessage(String className, long classPK, long messageId, String subject, String body, ServiceContext serviceContext) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.updateDiscussionMessage(className, classPK, messageId, subject, body, serviceContext));
    }

    public MBMessage updateMessage(long messageId, String subject, String body, List<ObjectValuePair<String, InputStream>> inputStreamOVPs, List<String> existingFiles, double priority, boolean allowPingbacks, ServiceContext serviceContext) throws PortalException {
        return (MBMessage)ModelAdapterUtil.adapt(MBMessage.class, (Object)this._mbMessageService.updateMessage(messageId, subject, body, inputStreamOVPs, existingFiles, priority, allowPingbacks, serviceContext));
    }
}

