/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search;

import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class MBThreadIndexer
extends BaseIndexer<MBThread> {
    public static final String CLASS_NAME = MBThread.class.getName();
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected MBCategoryLocalService mbCategoryLocalService;
    @Reference
    protected MBDiscussionLocalService mbDiscussionLocalService;
    @Reference
    protected MBThreadLocalService mbThreadLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBThreadIndexer.class);

    public MBThreadIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"classNameId", "classPK", "companyId", "entryClassName", "entryClassPK", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) {
        return true;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long participantUserId;
        this.addStatus(contextBooleanFilter, searchContext);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"));
        contextBooleanFilter.addRequiredTerm("discussion", discussion);
        long endDate = GetterUtil.getLong((Object)searchContext.getAttribute("endDate"));
        long startDate = GetterUtil.getLong((Object)searchContext.getAttribute("startDate"));
        if (endDate > 0L && startDate > 0L) {
            contextBooleanFilter.addRangeTerm("lastPostDate", startDate, endDate);
        }
        if ((participantUserId = GetterUtil.getLong((Object)searchContext.getAttribute("participantUserId"))) > 0L) {
            contextBooleanFilter.addRequiredTerm("participantUserIds", participantUserId);
        }
    }

    protected void doDelete(MBThread mbThread) throws Exception {
        SearchContext searchContext = new SearchContext();
        searchContext.setSearchEngineId(this.getSearchEngineId());
        this.deleteDocument(mbThread.getCompanyId(), mbThread.getThreadId());
    }

    protected Document doGetDocument(MBThread mbThread) {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)mbThread);
        MBDiscussion discussion = this.mbDiscussionLocalService.fetchThreadDiscussion(mbThread.getThreadId());
        if (discussion == null) {
            document.addKeyword("discussion", false);
        } else {
            document.addKeyword("discussion", true);
        }
        Date lastPostDate = mbThread.getLastPostDate();
        document.addKeyword("lastPostDate", lastPostDate.getTime());
        document.addKeyword("participantUserIds", mbThread.getParticipantUserIds());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(MBThread mbThread) throws Exception {
        Document document = this.getDocument(mbThread);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)mbThread.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBThread thread = this.mbThreadLocalService.getThread(classPK);
        this.doReindex(thread);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexDiscussions(companyId);
        this.reindexRoot(companyId);
    }

    protected void reindexCategories(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.mbCategoryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(category -> this.reindexThreads(companyId, category.getGroupId(), category.getCategoryId()));
        actionableDynamicQuery.performActions();
    }

    protected void reindexDiscussions(long companyId) throws PortalException {
        DynamicQuery countDynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, -1L);
        long distinctGroupIdsCount = this.mbThreadLocalService.dynamicQueryCount(countDynamicQuery);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor((int)distinctGroupIdsCount);
        DynamicQuery dynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, -1L);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List groupIds = this.mbThreadLocalService.dynamicQuery(dynamicQuery, start, end);
            Iterator iterator = groupIds.iterator();
            while (iterator.hasNext()) {
                long groupId = (Long)iterator.next();
                this.reindexThreads(companyId, groupId, -1L);
            }
            intervalActionProcessor.incrementStart(groupIds.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    protected void reindexRoot(long companyId) throws PortalException {
        DynamicQuery countDynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, 0L);
        long distinctGroupIdsCount = this.mbThreadLocalService.dynamicQueryCount(countDynamicQuery);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor((int)distinctGroupIdsCount);
        DynamicQuery dynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, 0L);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List groupIds = this.mbThreadLocalService.dynamicQuery(dynamicQuery, start, end);
            Iterator iterator = groupIds.iterator();
            while (iterator.hasNext()) {
                long groupId = (Long)iterator.next();
                this.reindexThreads(companyId, groupId, 0L);
            }
            intervalActionProcessor.incrementStart(groupIds.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    protected void reindexThreads(long companyId, long groupId, long categoryId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Reindexing message boards threads for message board ", "category ID ", categoryId, " and group ID ", groupId}));
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.mbThreadLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
            dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)0));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod(thread -> {
            block2: {
                try {
                    Document document = this.getDocument(thread);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index message boards thread " + thread.getThreadId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    private DynamicQuery _getDistinctGroupIdDynamicQuery(long companyId, long categoryId) {
        DynamicQuery dynamicQuery = this.mbThreadLocalService.dynamicQuery();
        dynamicQuery.setProjection(ProjectionFactoryUtil.distinct((Projection)ProjectionFactoryUtil.property((String)"groupId")));
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
        dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dynamicQuery.add(statusProperty.eq((Object)0));
        return dynamicQuery;
    }
}

