/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBCategoryService;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"related.entry.indexer.class.name=com.liferay.message.boards.model.MBMessage"}, service={Indexer.class, RelatedEntryIndexer.class})
public class MBMessageIndexer
extends BaseIndexer<MBMessage>
implements RelatedEntryIndexer {
    public static final String CLASS_NAME = MBMessage.class.getName();
    @Reference
    protected CommentManager commentManager;
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected MBCategoryLocalService mbCategoryLocalService;
    @Reference
    protected MBCategoryService mbCategoryService;
    @Reference
    protected MBDiscussionLocalService mbDiscussionLocalService;
    @Reference
    protected MBMessageLocalService mbMessageLocalService;
    @Reference
    protected MBThreadLocalService mbThreadLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBMessageIndexer.class);
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBMessage)")
    private ModelResourcePermission<MBMessage> _messageModelResourcePermission;
    private final RelatedEntryIndexer _relatedEntryIndexer = new BaseRelatedEntryIndexer();
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public MBMessageIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "classNameId", "classPK", "companyId", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedClassNames(BooleanFilter contextFilter, SearchContext searchContext) throws Exception {
        this._relatedEntryIndexer.addRelatedClassNames(contextFilter, searchContext);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        FileEntry fileEntry = (FileEntry)obj;
        MBMessage message = this.mbMessageLocalService.fetchFileEntryMessage(fileEntry.getFileEntryId());
        if (message == null) {
            return;
        }
        document.addKeyword("categoryId", message.getCategoryId());
        document.addKeywordSortable("answer", Boolean.valueOf(message.isAnswer()));
        document.addKeyword("discussion", false);
        document.addKeyword("threadId", message.getThreadId());
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        MBMessage message = this.mbMessageLocalService.getMessage(entryClassPK);
        if (message.isDiscussion()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)message.getClassName());
            return indexer.hasPermission(permissionChecker, message.getClassName(), message.getClassPK(), "VIEW");
        }
        return this._messageModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        MBMessage message = this.mbMessageLocalService.getMessage(classPK);
        return this.isVisible(message.getStatus(), status);
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) {
        try {
            MBMessage message = this.mbMessageLocalService.getMessage(classPK);
            if (message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer((String)message.getClassName());
                return indexer.isVisible(message.getClassPK(), status);
            }
        }
        catch (Exception e) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to get message boards message", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long[] categoryIds;
        long threadId;
        String classNameId;
        this.addStatus(contextBooleanFilter, searchContext);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"));
        contextBooleanFilter.addRequiredTerm("discussion", discussion);
        if (searchContext.isIncludeDiscussions()) {
            this.addRelatedClassNames(contextBooleanFilter, searchContext);
        }
        if (Validator.isNotNull((String)(classNameId = GetterUtil.getString((Object)searchContext.getAttribute("classNameId"))))) {
            contextBooleanFilter.addRequiredTerm("classNameId", classNameId);
        }
        if ((threadId = GetterUtil.getLong((String)((String)((Object)searchContext.getAttribute("threadId"))))) > 0L) {
            contextBooleanFilter.addRequiredTerm("threadId", threadId);
        }
        if ((categoryIds = searchContext.getCategoryIds()) != null && categoryIds.length > 0 && categoryIds[0] != 0L) {
            TermsFilter categoriesTermsFilter = new TermsFilter("categoryId");
            for (long categoryId : categoryIds) {
                try {
                    this.mbCategoryService.getCategory(categoryId);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get message boards category " + categoryId), (Throwable)pe);
                    continue;
                }
                categoriesTermsFilter.addValue(String.valueOf(categoryId));
            }
            if (!categoriesTermsFilter.isEmpty()) {
                contextBooleanFilter.add((Filter)categoriesTermsFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        String[] localizedFieldNames = this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{"content", "title"}, searchContext);
        queryConfig.addHighlightFieldNames(localizedFieldNames);
    }

    public void updateFullQuery(SearchContext searchContext) {
        if (searchContext.isIncludeDiscussions()) {
            searchContext.addFullQueryEntryClassName(MBMessage.class.getName());
            searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
        }
    }

    protected void doDelete(MBMessage mbMessage) throws Exception {
        this.deleteDocument(mbMessage.getCompanyId(), mbMessage.getMessageId());
    }

    protected Document doGetDocument(MBMessage mbMessage) throws Exception {
        List relatedEntryIndexers;
        MBDiscussion discussion;
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)mbMessage);
        document.addKeyword("categoryId", mbMessage.getCategoryId());
        for (Locale locale : LanguageUtil.getAvailableLocales((long)mbMessage.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(LocalizationUtil.getLocalizedName((String)"content", (String)languageId), this.processContent(mbMessage));
            document.addText(LocalizationUtil.getLocalizedName((String)"title", (String)languageId), mbMessage.getSubject());
        }
        document.addKeyword("rootEntryClassPK", mbMessage.getRootMessageId());
        if (mbMessage.isAnonymous()) {
            document.remove("userName");
        }
        if ((discussion = this.mbDiscussionLocalService.fetchThreadDiscussion(mbMessage.getThreadId())) == null) {
            document.addKeyword("discussion", false);
        } else {
            document.addKeyword("discussion", true);
        }
        document.addKeyword("answer", mbMessage.isAnswer());
        document.addKeyword("parentMessageId", mbMessage.getParentMessageId());
        document.addKeyword("threadId", mbMessage.getThreadId());
        if (mbMessage.getMessageId() == mbMessage.getRootMessageId()) {
            MBThread mbThread = this.mbThreadLocalService.fetchMBThread(mbMessage.getThreadId());
            document.addKeyword("question", mbThread.isQuestion());
        }
        if (mbMessage.isDiscussion() && (relatedEntryIndexers = RelatedEntryIndexerRegistryUtil.getRelatedEntryIndexers((String)mbMessage.getClassName())) != null) {
            for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                Comment comment = this.commentManager.fetchComment(mbMessage.getMessageId());
                if (comment == null) continue;
                relatedEntryIndexer.addRelatedEntryFields(document, (Object)comment);
                document.addKeyword("relatedEntry", true);
            }
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        String title = LocalizationUtil.getLocalizedName((String)"title", (String)languageId);
        String content = LocalizationUtil.getLocalizedName((String)"content", (String)languageId);
        Summary summary = this.createSummary(document, title, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(MBMessage mbMessage) throws Exception {
        if (!mbMessage.isApproved() && !mbMessage.isInTrash() || mbMessage.isDiscussion() && mbMessage.isRoot()) {
            return;
        }
        Document document = this.getDocument(mbMessage);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)mbMessage.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        this.reindexAttachments(mbMessage);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBMessage message = this.mbMessageLocalService.getMessage(classPK);
        if (message.isRoot()) {
            for (MBMessage curMessage : this.mbMessageLocalService.getThreadMessages(message.getThreadId(), 0)) {
                this.reindex(curMessage);
            }
            for (MBMessage curMessage : this.mbMessageLocalService.getThreadMessages(message.getThreadId(), 8)) {
                this.reindex(curMessage);
            }
        } else {
            this.reindex(message);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexDiscussions(companyId);
        this.reindexRoot(companyId);
    }

    protected String processContent(MBMessage message) {
        String content = message.getBody();
        try {
            if (message.isFormatBBCode()) {
                content = BBCodeTranslatorUtil.getHTML((String)content);
            }
        }
        catch (Exception e) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to parse message ", message.getMessageId(), ": ", e.getMessage()}), (Throwable)e);
        }
        return HtmlUtil.extractText((String)content);
    }

    protected void reindexAttachments(MBMessage mbMessage) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        for (FileEntry attachmentsFileEntry : mbMessage.getAttachmentsFileEntries()) {
            indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
        }
    }

    protected void reindexCategories(long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.mbCategoryLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(category -> this.reindexMessages(companyId, category.getGroupId(), category.getCategoryId()));
        actionableDynamicQuery.performActions();
    }

    protected void reindexDiscussions(long companyId) throws PortalException {
        DynamicQuery countDynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, -1L);
        long distinctGroupIdsCount = this.mbMessageLocalService.dynamicQueryCount(countDynamicQuery);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor((int)distinctGroupIdsCount);
        DynamicQuery dynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, -1L);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List groupIds = this.mbMessageLocalService.dynamicQuery(dynamicQuery, start, end);
            Iterator iterator = groupIds.iterator();
            while (iterator.hasNext()) {
                long groupId = (Long)iterator.next();
                this.reindexMessages(companyId, groupId, -1L);
            }
            intervalActionProcessor.incrementStart(groupIds.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    protected void reindexMessages(long companyId, long groupId, long categoryId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Reindexing message boards messages for message board ", "category ID ", categoryId, " and group ID ", groupId}));
        }
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.mbMessageLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
            dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            Object[] statuses = new Integer[]{0, 8};
            dynamicQuery.add(statusProperty.in(statuses));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod(message -> {
            block3: {
                if (message.isDiscussion() && message.isRoot()) {
                    return;
                }
                try {
                    Document document = this.getDocument(message);
                    indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index message boards message " + message.getMessageId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexRoot(long companyId) throws PortalException {
        DynamicQuery countDynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, 0L);
        long distinctGroupIdsCount = this.mbMessageLocalService.dynamicQueryCount(countDynamicQuery);
        IntervalActionProcessor intervalActionProcessor = new IntervalActionProcessor((int)distinctGroupIdsCount);
        DynamicQuery dynamicQuery = this._getDistinctGroupIdDynamicQuery(companyId, 0L);
        intervalActionProcessor.setPerformIntervalActionMethod((start, end) -> {
            List groupIds = this.mbMessageLocalService.dynamicQuery(dynamicQuery, start, end);
            Iterator iterator = groupIds.iterator();
            while (iterator.hasNext()) {
                long groupId = (Long)iterator.next();
                this.reindexMessages(companyId, groupId, 0L);
            }
            intervalActionProcessor.incrementStart(groupIds.size());
            return null;
        });
        intervalActionProcessor.performIntervalActions();
    }

    private DynamicQuery _getDistinctGroupIdDynamicQuery(long companyId, long categoryId) {
        DynamicQuery dynamicQuery = this.mbMessageLocalService.dynamicQuery();
        dynamicQuery.setProjection(ProjectionFactoryUtil.distinct((Projection)ProjectionFactoryUtil.property((String)"groupId")));
        Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
        dynamicQuery.add(companyIdProperty.eq((Object)companyId));
        Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
        dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
        Object[] statuses = new Integer[]{0, 8};
        Property statusProperty = PropertyFactoryUtil.forName((String)"status");
        dynamicQuery.add(statusProperty.in(statuses));
        return dynamicQuery;
    }
}

