/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.search;

import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class MBCategoryIndexer
extends BaseIndexer<MBCategory> {
    public static final String CLASS_NAME = MBCategory.class.getName();
    @Reference
    protected GroupLocalService groupLocalService;
    @Reference
    protected MBCategoryLocalService mbCategoryLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MBCategoryIndexer.class);
    @Reference(target="(model.class.name=com.liferay.message.boards.model.MBCategory)")
    private ModelResourcePermission<MBCategory> _categoryModelResourcePermission;

    public MBCategoryIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"classNameId", "classPK", "companyId", "description", "entryClassName", "entryClassPK", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._categoryModelResourcePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        MBCategory mbCategory = this.mbCategoryLocalService.getMBCategory(classPK);
        return this.isVisible(mbCategory.getStatus(), status);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
    }

    protected void doDelete(MBCategory mbCategory) throws Exception {
        this.deleteDocument(mbCategory.getCompanyId(), mbCategory.getCategoryId());
    }

    protected Document doGetDocument(MBCategory mbCategory) {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)mbCategory);
        document.addKeyword("parentCategoryId", mbCategory.getParentCategoryId());
        document.addText("description", mbCategory.getDescription());
        document.addKeyword("name", mbCategory.getName());
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    protected void doReindex(MBCategory mbCategory) throws Exception {
        Document document = this.getDocument(mbCategory);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)mbCategory.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this.mbCategoryLocalService.getMBCategory(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
    }

    protected void reindexCategories(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this.mbCategoryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(mbCategory -> {
            block3: {
                try {
                    Document document = this.getDocument(mbCategory);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to index message boards categories " + mbCategory.getCategoryId()), (Throwable)pe);
                }
            }
        });
        indexableActionableDynamicQuery.performActions();
    }
}

