/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.pop;

import com.liferay.message.boards.constants.MBMessageConstants;
import com.liferay.message.boards.internal.util.MBMailMessage;
import com.liferay.message.boards.internal.util.MBMailUtil;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBCategoryLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.pop.MessageListener;
import com.liferay.portal.kernel.pop.MessageListenerException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.permission.PermissionCheckerUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={MessageListener.class})
public class MessageListenerImpl
implements MessageListener {
    private static final Log _log = LogFactoryUtil.getLog(MessageListenerImpl.class);
    private CompanyLocalService _companyLocalService;
    private MBCategoryLocalService _mbCategoryLocalService;
    private MBMessageLocalService _mbMessageLocalService;
    private MBMessageService _mbMessageService;
    @Reference
    private Portal _portal;
    private UserLocalService _userLocalService;

    public boolean accept(String from, String recipient, Message message) {
        try {
            String pop3User;
            if (this.isAutoReply(message)) {
                return false;
            }
            String messageIdString = this.getMessageIdString(recipient, message);
            if (messageIdString == null || !messageIdString.startsWith("mb_message.", MBMailUtil.getMessageIdStringOffset())) {
                return false;
            }
            Company company = this.getCompany(messageIdString);
            long categoryId = MBMailUtil.getCategoryId(messageIdString);
            MBCategory category = this._mbCategoryLocalService.getCategory(categoryId);
            if (category.getCompanyId() != company.getCompanyId() && !category.isRoot()) {
                return false;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Check to see if user " + from + " exists"));
            }
            if (StringUtil.equalsIgnoreCase((String)from, (String)(pop3User = PrefsPropsUtil.getString((String)"mail.session.mail.pop3.user", (String)PropsValues.MAIL_SESSION_MAIL_POP3_USER)))) {
                return false;
            }
            this._userLocalService.getUserByEmailAddress(company.getCompanyId(), from);
            return true;
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message: " + message), (Throwable)e);
            return false;
        }
    }

    public void deliver(String from, String recipient, Message message) throws MessageListenerException {
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = null;
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Deliver message from ", from, " to ", recipient}));
            }
            String messageIdString = this.getMessageIdString(recipient, message);
            Company company = this.getCompany(messageIdString);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Message id " + messageIdString));
            }
            long parentMessageId = MBMailUtil.getMessageId(messageIdString);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent message id " + parentMessageId));
            }
            MBMessage parentMessage = null;
            if (parentMessageId > 0L) {
                parentMessage = this._mbMessageLocalService.fetchMBMessage(parentMessageId);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Parent message " + parentMessage));
            }
            long groupId = 0L;
            long categoryId = MBMailUtil.getCategoryId(messageIdString);
            MBCategory category = this._mbCategoryLocalService.fetchMBCategory(categoryId);
            if (category == null) {
                categoryId = 0L;
                if (parentMessage != null) {
                    groupId = parentMessage.getGroupId();
                }
            } else {
                groupId = category.getGroupId();
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Group id " + groupId));
                _log.debug((Object)("Category id " + categoryId));
            }
            User user = this._userLocalService.getUserByEmailAddress(company.getCompanyId(), from);
            String subject = null;
            if (parentMessage != null) {
                subject = MBMailUtil.getSubjectForEmail(parentMessage);
            }
            MBMailMessage mbMailMessage = new MBMailMessage();
            MBMailUtil.collectPartContent((Part)message, mbMailMessage);
            inputStreamOVPs = mbMailMessage.getInputStreamOVPs();
            PermissionCheckerUtil.setThreadValues((User)user);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAttribute("propagatePermissions", (Serializable)Boolean.TRUE);
            String portletId = PortletProviderUtil.getPortletId((String)MBMessage.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
            serviceContext.setLayoutFullURL(this._portal.getLayoutFullURL(groupId, portletId, StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL)));
            serviceContext.setScopeGroupId(groupId);
            if (parentMessage == null) {
                this._mbMessageService.addMessage(groupId, categoryId, subject, mbMailMessage.getBody(), MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, true, serviceContext);
            } else {
                this._mbMessageService.addMessage(parentMessage.getMessageId(), subject, mbMailMessage.getBody(), MBMessageConstants.DEFAULT_FORMAT, inputStreamOVPs, false, 0.0, true, serviceContext);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Delivering message takes " + stopWatch.getTime() + " ms"));
            }
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Prevented unauthorized post from " + from));
            }
            throw new MessageListenerException((Throwable)pe);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new MessageListenerException((Throwable)e);
        }
        finally {
            if (inputStreamOVPs != null) {
                for (ObjectValuePair objectValuePair : inputStreamOVPs) {
                    try {
                        InputStream inputStream = (InputStream)objectValuePair.getValue();
                        Throwable throwable = null;
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)ioe, (Throwable)ioe);
                    }
                }
            }
            PermissionCheckerUtil.setThreadValues(null);
        }
    }

    public String getId() {
        return MessageListenerImpl.class.getName();
    }

    protected Company getCompany(String messageIdString) throws Exception {
        int endPos;
        int pos = messageIdString.indexOf(64) + PropsValues.POP_SERVER_SUBDOMAIN.length() + 1;
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            ++pos;
        }
        if ((endPos = messageIdString.indexOf(62, pos)) == -1) {
            endPos = messageIdString.length();
        }
        String mx = messageIdString.substring(pos, endPos);
        return this._companyLocalService.getCompanyByMx(mx);
    }

    protected String getMessageIdString(String recipient, Message message) throws Exception {
        if (PropsValues.POP_SERVER_SUBDOMAIN.length() > 0) {
            return recipient;
        }
        return MBMailUtil.getParentMessageIdString(message);
    }

    protected boolean isAutoReply(Message message) throws MessagingException {
        Object[] autoReply = message.getHeader("X-Autoreply");
        if (ArrayUtil.isNotEmpty((Object[])autoReply)) {
            return true;
        }
        Object[] autoReplyFrom = message.getHeader("X-Autoreply-From");
        if (ArrayUtil.isNotEmpty((Object[])autoReplyFrom)) {
            return true;
        }
        Object[] mailAutoReply = message.getHeader("X-Mail-Autoreply");
        return ArrayUtil.isNotEmpty((Object[])mailAutoReply);
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }

    @Reference(unbind="-")
    protected void setMBCategoryLocalService(MBCategoryLocalService mbCategoryLocalService) {
        this._mbCategoryLocalService = mbCategoryLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageService(MBMessageService mbMessageService) {
        this._mbMessageService = mbMessageService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

