/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.message.boards.model.MBCategory;
import com.liferay.message.boards.model.MBDiscussion;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.model.MBThread;
import com.liferay.message.boards.service.MBDiscussionLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portlet.documentlibrary.lar.FileEntryUtil;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class MBMessageStagedModelDataHandler
extends BaseStagedModelDataHandler<MBMessage> {
    public static final String[] CLASS_NAMES = new String[]{MBMessage.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(MBMessageStagedModelDataHandler.class);
    private MBDiscussionLocalService _mbDiscussionLocalService;
    private MBMessageLocalService _mbMessageLocalService;
    private MBThreadLocalService _mbThreadLocalService;
    private RatingsEntryLocalService _ratingsEntryLocalService;

    public void deleteStagedModel(MBMessage message) throws PortalException {
        this._mbMessageLocalService.deleteMessage(message);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        MBMessage message = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (message != null) {
            this.deleteStagedModel(message);
        }
    }

    public MBMessage fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._mbMessageLocalService.fetchMBMessageByUuidAndGroupId(uuid, groupId);
    }

    public List<MBMessage> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._mbMessageLocalService.getMBMessagesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(MBMessage message) {
        return message.getSubject();
    }

    protected MBMessage addDiscussionMessage(PortletDataContext portletDataContext, long userId, long threadId, long parentMessageId, MBMessage message, ServiceContext serviceContext) throws PortalException {
        MBMessage importedMessage = null;
        if (!message.isRoot()) {
            MBDiscussion discussion = this._mbDiscussionLocalService.getThreadDiscussion(threadId);
            importedMessage = this._mbMessageLocalService.addDiscussionMessage(userId, message.getUserName(), portletDataContext.getScopeGroupId(), discussion.getClassName(), discussion.getClassPK(), threadId, parentMessageId, message.getSubject(), message.getBody(), serviceContext);
        } else {
            MBThread thread = this._mbThreadLocalService.getThread(threadId);
            importedMessage = this._mbMessageLocalService.getMBMessage(thread.getRootMessageId());
        }
        return importedMessage;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        if (message.isDiscussion()) {
            MBDiscussion discussion = this._mbDiscussionLocalService.getDiscussion(message.getClassName(), message.getClassPK());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)discussion, (String)"parent");
            List ratingsEntries = this._ratingsEntryLocalService.getEntries(MBDiscussion.class.getName(), message.getMessageId());
            for (Object ratingsEntry : ratingsEntries) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)ratingsEntry, (String)"weak");
            }
        } else if (message.getCategoryId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)message.getCategory(), (String)"parent");
        }
        if (!message.isRoot()) {
            MBMessage parentMessage = this._mbMessageLocalService.getMessage(message.getParentMessageId());
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)parentMessage, (String)"parent");
        }
        message.setPriority(message.getPriority());
        MBThread thread = message.getThread();
        Element messageElement = portletDataContext.getExportDataElement((ClassedModel)message);
        messageElement.addAttribute("question", String.valueOf(thread.isQuestion()));
        messageElement.addAttribute("threadUuid", thread.getUuid());
        boolean hasAttachmentsFileEntries = false;
        if (message.getAttachmentsFileEntriesCount() > 0) {
            hasAttachmentsFileEntries = true;
        }
        messageElement.addAttribute("hasAttachmentsFileEntries", String.valueOf(hasAttachmentsFileEntries));
        if (hasAttachmentsFileEntries) {
            for (FileEntry fileEntry : message.getAttachmentsFileEntries()) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, (StagedModel)fileEntry, (String)"weak");
            }
            long folderId = message.getAttachmentsFolderId();
            if (folderId != 0L) {
                message.setAttachmentsFolderId(folderId);
            }
        }
        portletDataContext.addClassedModel(messageElement, ExportImportPathUtil.getModelPath((StagedModel)message), (ClassedModel)message);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long messageId) throws Exception {
        MBMessage existingMessage = (MBMessage)this.fetchMissingReference(uuid, groupId);
        if (existingMessage == null) {
            return;
        }
        Map messageIds = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        messageIds.put(messageId, existingMessage.getMessageId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        String threadUuid;
        MBThread thread;
        if (!message.isRoot()) {
            StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)message, MBMessage.class, (long)message.getParentMessageId());
        }
        long userId = portletDataContext.getUserId(message.getUserUuid());
        Map categoryIds = portletDataContext.getNewPrimaryKeysMap(MBCategory.class);
        long parentCategoryId = MapUtil.getLong((Map)categoryIds, (long)message.getCategoryId(), (long)message.getCategoryId());
        Map threadIds = portletDataContext.getNewPrimaryKeysMap(MBThread.class);
        long threadId = MapUtil.getLong((Map)threadIds, (long)message.getThreadId(), (long)0L);
        Element messageElement = portletDataContext.getImportDataStagedModelElement((StagedModel)message);
        if (threadId == 0L && (thread = this._mbThreadLocalService.fetchMBThreadByUuidAndGroupId(threadUuid = messageElement.attributeValue("threadUuid"), portletDataContext.getScopeGroupId())) != null) {
            threadId = thread.getThreadId();
        }
        Map messageIds = portletDataContext.getNewPrimaryKeysMap(MBMessage.class);
        long parentMessageId = MapUtil.getLong((Map)messageIds, (long)message.getParentMessageId(), (long)message.getParentMessageId());
        List<ObjectValuePair<String, InputStream>> inputStreamOVPs = this.getAttachments(portletDataContext, messageElement, message);
        try {
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)message);
            MBMessage importedMessage = null;
            if (portletDataContext.isDataStrategyMirror()) {
                MBMessage existingMessage = this.fetchStagedModelByUuidAndGroupId(message.getUuid(), portletDataContext.getScopeGroupId());
                if (existingMessage == null) {
                    serviceContext.setUuid(message.getUuid());
                    importedMessage = message.isDiscussion() ? this.addDiscussionMessage(portletDataContext, userId, threadId, parentMessageId, message, serviceContext) : this._mbMessageLocalService.addMessage(userId, message.getUserName(), portletDataContext.getScopeGroupId(), parentCategoryId, threadId, parentMessageId, message.getSubject(), message.getBody(), message.getFormat(), inputStreamOVPs, message.isAnonymous(), message.getPriority(), message.isAllowPingbacks(), serviceContext);
                } else if (!message.isRoot() && message.isDiscussion()) {
                    MBDiscussion discussion = this._mbDiscussionLocalService.getThreadDiscussion(threadId);
                    importedMessage = this._mbMessageLocalService.updateDiscussionMessage(userId, existingMessage.getMessageId(), discussion.getClassName(), discussion.getClassPK(), message.getSubject(), message.getBody(), serviceContext);
                } else {
                    Stream objectValuePairStream = inputStreamOVPs.stream();
                    Set incomingFileNames = objectValuePairStream.map(ObjectValuePair::getKey).collect(Collectors.toSet());
                    List portletFileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)existingMessage.getGroupId(), (long)existingMessage.getAttachmentsFolderId());
                    Stream portletFileEntryStream = portletFileEntries.stream();
                    List updatedFileEntryIds = portletFileEntryStream.filter(fileEntry -> incomingFileNames.contains(fileEntry.getFileName())).map(FileEntry::getFileEntryId).collect(Collectors.toList());
                    for (Long fileEntryId : updatedFileEntryIds) {
                        PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntryId);
                    }
                    importedMessage = this._mbMessageLocalService.updateMessage(userId, existingMessage.getMessageId(), message.getSubject(), message.getBody(), inputStreamOVPs, message.getPriority(), message.isAllowPingbacks(), serviceContext);
                }
            } else {
                importedMessage = message.isDiscussion() ? this.addDiscussionMessage(portletDataContext, userId, threadId, parentMessageId, message, serviceContext) : this._mbMessageLocalService.addMessage(userId, message.getUserName(), portletDataContext.getScopeGroupId(), parentCategoryId, threadId, parentMessageId, message.getSubject(), message.getBody(), message.getFormat(), inputStreamOVPs, message.isAnonymous(), message.getPriority(), message.isAllowPingbacks(), serviceContext);
            }
            importedMessage = this._updateAnswer(message, importedMessage);
            if (importedMessage.isRoot() && !importedMessage.isDiscussion()) {
                this._mbThreadLocalService.updateQuestion(importedMessage.getThreadId(), GetterUtil.getBoolean((String)messageElement.attributeValue("question")));
            }
            if (message.isDiscussion()) {
                Map discussionIds = portletDataContext.getNewPrimaryKeysMap(MBDiscussion.class);
                discussionIds.put(message.getMessageId(), importedMessage.getMessageId());
            }
            threadIds.put(message.getThreadId(), importedMessage.getThreadId());
            MBThread thread2 = importedMessage.getThread();
            thread2.setUuid(messageElement.attributeValue("threadUuid"));
            this._mbThreadLocalService.updateMBThread(thread2);
            portletDataContext.importClassedModel((ClassedModel)message, (ClassedModel)importedMessage);
        }
        finally {
            for (ObjectValuePair<String, InputStream> inputStreamOVP : inputStreamOVPs) {
                try {
                    InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                    Throwable throwable = null;
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)ioe, (Throwable)ioe);
                }
            }
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, MBMessage message) throws Exception {
        TrashHandler trashHandler;
        MBMessage existingMessage = this.fetchStagedModelByUuidAndGroupId(message.getUuid(), portletDataContext.getScopeGroupId());
        if (existingMessage == null) {
            return;
        }
        long userId = portletDataContext.getUserId(message.getUserUuid());
        if (existingMessage.isInTrash() && (trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)MBMessage.class.getName())).isRestorable(existingMessage.getMessageId())) {
            trashHandler.restoreTrashEntry(userId, existingMessage.getMessageId());
        }
        if (existingMessage.isInTrashContainer()) {
            MBThread existingThread = existingMessage.getThread();
            TrashHandler trashHandler2 = TrashHandlerRegistryUtil.getTrashHandler((String)MBThread.class.getName());
            if (trashHandler2.isRestorable(existingThread.getThreadId())) {
                trashHandler2.restoreTrashEntry(userId, existingThread.getThreadId());
            }
        }
    }

    protected List<ObjectValuePair<String, InputStream>> getAttachments(PortletDataContext portletDataContext, Element messageElement, MBMessage message) {
        boolean hasAttachmentsFileEntries = GetterUtil.getBoolean((String)messageElement.attributeValue("hasAttachmentsFileEntries"));
        if (!hasAttachmentsFileEntries) {
            return Collections.emptyList();
        }
        ArrayList<ObjectValuePair<String, InputStream>> inputStreamOVPs = new ArrayList<ObjectValuePair<String, InputStream>>();
        List attachmentElements = portletDataContext.getReferenceDataElements(messageElement, DLFileEntry.class, "weak");
        for (Element attachmentElement : attachmentElements) {
            String path = attachmentElement.attributeValue("path");
            FileEntry fileEntry = (FileEntry)portletDataContext.getZipEntryAsObject(path);
            InputStream inputStream = null;
            String binPath = attachmentElement.attributeValue("bin-path");
            if (Validator.isNull((String)binPath) && portletDataContext.isPerformDirectBinaryImport()) {
                try {
                    inputStream = FileEntryUtil.getContentStream((FileEntry)fileEntry);
                }
                catch (Exception exception) {}
            } else {
                inputStream = portletDataContext.getZipEntryAsInputStream(binPath);
            }
            if (inputStream == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to import attachment for file entry " + fileEntry.getFileEntryId()));
                continue;
            }
            ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileEntry.getTitle(), (Object)inputStream);
            inputStreamOVPs.add((ObjectValuePair<String, InputStream>)inputStreamOVP);
        }
        if (inputStreamOVPs.isEmpty()) {
            _log.error((Object)("Could not find attachments for message " + message.getMessageId()));
        }
        return inputStreamOVPs;
    }

    @Reference(unbind="-")
    protected void setMBDiscussionLocalService(MBDiscussionLocalService mbDiscussionLocalService) {
        this._mbDiscussionLocalService = mbDiscussionLocalService;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMBThreadLocalService(MBThreadLocalService mbThreadLocalService) {
        this._mbThreadLocalService = mbThreadLocalService;
    }

    @Reference(unbind="-")
    protected void setRatingsEntryLocalService(RatingsEntryLocalService ratingsEntryLocalService) {
        this._ratingsEntryLocalService = ratingsEntryLocalService;
    }

    private MBMessage _updateAnswer(MBMessage message, MBMessage importedMessage) throws PortalException {
        if (importedMessage.isAnswer() == message.isAnswer()) {
            return importedMessage;
        }
        Date modifiedDate = importedMessage.getModifiedDate();
        this._mbMessageLocalService.updateAnswer(importedMessage, message.isAnswer(), false);
        importedMessage = this._mbMessageLocalService.fetchMBMessage(importedMessage.getMessageId());
        importedMessage.setModifiedDate(modifiedDate);
        this._mbMessageLocalService.updateMBMessage(importedMessage);
        return importedMessage;
    }
}

