/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.internal.util;

import com.liferay.mentions.util.MentionsUserFinder;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.comparator.UserScreenNameComparator;
import com.liferay.social.kernel.service.SocialRelationLocalService;
import com.liferay.social.kernel.util.SocialInteractionsConfiguration;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MentionsUserFinder.class})
public class DefaultMentionsUserFinder
implements MentionsUserFinder {
    private static final int _MAX_USERS = 20;
    private static final int[] _TYPES = new int[]{2};
    private static final Log _log = LogFactoryUtil.getLog(DefaultMentionsUserFinder.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private SocialRelationLocalService _socialRelationLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public List<User> getUsers(long companyId, long userId, String query, SocialInteractionsConfiguration socialInteractionsConfiguration) throws PortalException {
        if (socialInteractionsConfiguration.isSocialInteractionsAnyUserEnabled()) {
            return this._userLocalService.search(companyId, query, 0, LinkedHashMapBuilder.put((Object)"wildcardMode", (Object)WildcardMode.TRAILING).build(), 0, 20, (OrderByComparator)new UserScreenNameComparator());
        }
        User user = this._userLocalService.getUser(userId);
        long[] groupIds = ListUtil.toLongArray((List)this._groupLocalService.getUserSitesGroups(user.getUserId()), (Accessor)Group.GROUP_ID_ACCESSOR);
        if (socialInteractionsConfiguration.isSocialInteractionsFriendsEnabled() && socialInteractionsConfiguration.isSocialInteractionsSitesEnabled()) {
            long currentSiteGroupId = GroupThreadLocal.getGroupId();
            return ListUtil.filter((List)this._userLocalService.searchSocial(groupIds, userId, _TYPES, query, 0, 20), mentionedUser -> {
                try {
                    if (this._socialRelationLocalService.hasRelation(user.getUserId(), mentionedUser.getUserId(), 2)) {
                        return true;
                    }
                    long[] siteGroupIds = ListUtil.toLongArray((List)this._groupLocalService.getUserSitesGroups(mentionedUser.getUserId()), (Accessor)Group.GROUP_ID_ACCESSOR);
                    if (ArrayUtil.contains((long[])siteGroupIds, (long)currentSiteGroupId)) {
                        return true;
                    }
                }
                catch (PortalException portalException) {
                    _log.error((Throwable)portalException);
                    return false;
                }
                return false;
            });
        }
        if (socialInteractionsConfiguration.isSocialInteractionsSitesEnabled()) {
            return this._userLocalService.searchSocial(companyId, groupIds, null, query, 0, 20);
        }
        if (socialInteractionsConfiguration.isSocialInteractionsFriendsEnabled()) {
            return this._userLocalService.searchSocial(userId, _TYPES, query, 0, 20);
        }
        return Collections.emptyList();
    }
}

