/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.internal.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.mentions.internal.util.MentionsMatcherRegistry;
import com.liferay.mentions.matcher.MentionsMatcher;
import com.liferay.mentions.util.MentionsNotifier;
import com.liferay.mentions.util.MentionsUserFinder;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.service.permission.PortletPermission;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.social.kernel.util.SocialInteractionsConfiguration;
import com.liferay.social.kernel.util.SocialInteractionsConfigurationUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MentionsNotifier.class})
public class DefaultMentionsNotifier
implements MentionsNotifier {
    @Reference
    private LayoutPermission _layoutPermission;
    private MentionsMatcherRegistry _mentionsMatcherRegistry;
    private MentionsUserFinder _mentionsUserFinder;
    @Reference
    private PermissionCheckerFactory _permissionCheckerFactory;
    @Reference
    private Portal _portal;
    @Reference
    private PortletPermission _portletPermission;
    private UserLocalService _userLocalService;

    public void notify(long userId, long groupId, String title, String content, String className, long classPK, LocalizedValuesMap subjectLocalizedValuesMap, LocalizedValuesMap bodyLocalizedValuesMap, ServiceContext serviceContext) throws PortalException {
        Object[] mentionedUsersScreenNames = this.getMentionedUsersScreenNames(userId, className, content);
        if (ArrayUtil.isEmpty((Object[])mentionedUsersScreenNames)) {
            return;
        }
        User user = this._userLocalService.getUser(userId);
        String contentURL = (String)((Object)serviceContext.getAttribute("contentURL"));
        String messageUserEmailAddress = this._portal.getUserEmailAddress(userId);
        String messageUserName = this._portal.getUserName(userId, "");
        String fromName = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString((long)user.getCompanyId(), (String)"admin.email.from.address");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setLocalizedBodyMap(LocalizationUtil.getMap((LocalizedValuesMap)bodyLocalizedValuesMap));
        subscriptionSender.setClassName(className);
        subscriptionSender.setClassPK(classPK);
        subscriptionSender.setCompanyId(user.getCompanyId());
        subscriptionSender.setContextAttribute("[$CONTENT$]", (Object)content, false);
        subscriptionSender.setContextAttributes(new Object[]{"[$USER_ADDRESS$]", messageUserEmailAddress, "[$USER_NAME$]", messageUserName, "[$CONTENT_URL$]", contentURL});
        subscriptionSender.setCurrentUserId(userId);
        subscriptionSender.setEntryTitle(title);
        subscriptionSender.setEntryURL(contentURL);
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedContextAttributeWithFunction("[$ASSET_ENTRY_NAME$]", locale -> this.getAssetEntryName(className, (Locale)locale));
        subscriptionSender.setMailId("mb_discussion", new Object[]{classPK});
        subscriptionSender.setNotificationType(0);
        subscriptionSender.setPortletId("com_liferay_mentions_web_portlet_MentionsPortlet");
        subscriptionSender.setScopeGroupId(groupId);
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setLocalizedSubjectMap(LocalizationUtil.getMap((LocalizedValuesMap)subjectLocalizedValuesMap));
        for (Object mentionedUserScreenName : mentionedUsersScreenNames) {
            PermissionChecker permissionChecker;
            Layout layout;
            ThemeDisplay themeDisplay;
            User mentionedUser = this._userLocalService.fetchUserByScreenName(user.getCompanyId(), (String)mentionedUserScreenName);
            if (mentionedUser == null || (themeDisplay = serviceContext.getThemeDisplay()) != null && (layout = themeDisplay.getLayout()) != null && (!this._layoutPermission.contains(permissionChecker = this._permissionCheckerFactory.create(mentionedUser), layout, true, "VIEW") || !this._portletPermission.contains(permissionChecker, layout, themeDisplay.getPpid(), "VIEW"))) continue;
            subscriptionSender.addRuntimeSubscribers(mentionedUser.getEmailAddress(), mentionedUser.getFullName());
        }
        subscriptionSender.flushNotificationsAsync();
    }

    protected String getAssetEntryName(String className, Locale locale) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory != null) {
            return assetRendererFactory.getTypeName(locale);
        }
        return "";
    }

    protected String[] getMentionedUsersScreenNames(long userId, String className, String content) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        SocialInteractionsConfiguration socialInteractionsConfiguration = SocialInteractionsConfigurationUtil.getSocialInteractionsConfiguration((long)user.getCompanyId(), (String)"com_liferay_mentions_web_portlet_MentionsPortlet");
        HashSet<String> mentionedUsersScreenNames = new HashSet<String>();
        MentionsMatcher mentionsMatcher = this._mentionsMatcherRegistry.getMentionsMatcher(className);
        block0: for (String mentionedUserScreenName : mentionsMatcher.match(content)) {
            List users = this._mentionsUserFinder.getUsers(user.getCompanyId(), userId, mentionedUserScreenName, socialInteractionsConfiguration);
            for (User curUser : users) {
                if (!mentionedUserScreenName.equals(curUser.getScreenName())) continue;
                mentionedUsersScreenNames.add(mentionedUserScreenName);
                continue block0;
            }
        }
        return mentionedUsersScreenNames.toArray(new String[0]);
    }

    @Reference(unbind="-")
    protected void setMentionsMatcherRegistry(MentionsMatcherRegistry mentionsMatcherRegistry) {
        this._mentionsMatcherRegistry = mentionsMatcherRegistry;
    }

    @Reference(unbind="-")
    protected void setMentionsUserFinder(MentionsUserFinder mentionsUserFinder) {
        this._mentionsUserFinder = mentionsUserFinder;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

