/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.internal.service;

import com.liferay.mentions.configuration.MentionsGroupServiceConfiguration;
import com.liferay.mentions.util.MentionsNotifier;
import com.liferay.mentions.util.MentionsUtil;
import com.liferay.message.boards.model.MBMessage;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBMessageLocalServiceWrapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class MentionsMessageServiceWrapper
extends MBMessageLocalServiceWrapper {
    private ConfigurationProvider _configurationProvider;
    private MBMessageLocalService _mbMessageLocalService;
    private MentionsNotifier _mentionsNotifier;
    @Reference
    private Portal _portal;

    public MentionsMessageServiceWrapper() {
        super(null);
    }

    public MentionsMessageServiceWrapper(MBMessageLocalService mbMessageLocalService) {
        super(mbMessageLocalService);
    }

    public MBMessage updateStatus(long userId, long messageId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        String contentURL;
        MBMessage message = this._mbMessageLocalService.getMessage(messageId);
        int oldStatus = message.getStatus();
        message = super.updateStatus(userId, messageId, status, serviceContext, workflowContext);
        if (status != 0 || oldStatus == 8) {
            return message;
        }
        if (!MentionsUtil.isMentionsEnabled((long)this._portal.getSiteGroupId(message.getGroupId()))) {
            return message;
        }
        String content = message.getBody();
        if (message.isFormatBBCode()) {
            content = BBCodeTranslatorUtil.getHTML((String)content);
        }
        String title = message.getSubject();
        if (message.isDiscussion()) {
            title = StringUtil.shorten((String)HtmlUtil.extractText((String)content), (int)100);
        }
        MentionsGroupServiceConfiguration mentionsGroupServiceConfiguration = (MentionsGroupServiceConfiguration)this._configurationProvider.getCompanyConfiguration(MentionsGroupServiceConfiguration.class, message.getCompanyId());
        LocalizedValuesMap subjectLocalizedValuesMap = mentionsGroupServiceConfiguration.commentMentionEmailSubject();
        LocalizedValuesMap bodyLocalizedValuesMap = mentionsGroupServiceConfiguration.commentMentionEmailBody();
        if (!message.isDiscussion()) {
            subjectLocalizedValuesMap = mentionsGroupServiceConfiguration.assetEntryMentionEmailSubject();
            bodyLocalizedValuesMap = mentionsGroupServiceConfiguration.assetEntryMentionEmailBody();
        }
        if (Validator.isNull((String)(contentURL = (String)((Object)serviceContext.getAttribute("contentURL"))))) {
            serviceContext.setAttribute("contentURL", workflowContext.get("url"));
        }
        this._mentionsNotifier.notify(userId, message.getGroupId(), title, content, message.getModelClassName(), message.getMessageId(), subjectLocalizedValuesMap, bodyLocalizedValuesMap, serviceContext);
        return message;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setMBMessageLocalService(MBMessageLocalService mbMessageLocalService) {
        this._mbMessageLocalService = mbMessageLocalService;
    }

    @Reference(unbind="-")
    protected void setMentionsNotifier(MentionsNotifier mentionsNotifier) {
        this._mentionsNotifier = mentionsNotifier;
    }
}

