/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mentions.internal.service;

import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryLocalService;
import com.liferay.blogs.service.BlogsEntryLocalServiceWrapper;
import com.liferay.mentions.configuration.MentionsGroupServiceConfiguration;
import com.liferay.mentions.util.MentionsNotifier;
import com.liferay.mentions.util.MentionsUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ServiceWrapper.class})
public class MentionsBlogsEntryServiceWrapper
extends BlogsEntryLocalServiceWrapper {
    private BlogsEntryLocalService _blogsEntryLocalService;
    private ConfigurationProvider _configurationProvider;
    private MentionsNotifier _mentionsNotifier;
    @Reference
    private Portal _portal;

    public MentionsBlogsEntryServiceWrapper() {
        super(null);
    }

    public MentionsBlogsEntryServiceWrapper(BlogsEntryLocalService blogsEntryLocalService) {
        super(blogsEntryLocalService);
    }

    public BlogsEntry updateStatus(long userId, long entryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        BlogsEntry entry = this._blogsEntryLocalService.getEntry(entryId);
        int oldStatus = entry.getStatus();
        entry = super.updateStatus(userId, entryId, status, serviceContext, workflowContext);
        if (status != 0 || oldStatus == 8) {
            return entry;
        }
        if (!MentionsUtil.isMentionsEnabled((long)this._portal.getSiteGroupId(entry.getGroupId()))) {
            return entry;
        }
        String contentURL = (String)((Object)serviceContext.getAttribute("contentURL"));
        if (Validator.isNull((String)contentURL)) {
            serviceContext.setAttribute("contentURL", workflowContext.get("url"));
        }
        MentionsGroupServiceConfiguration mentionsGroupServiceConfiguration = (MentionsGroupServiceConfiguration)this._configurationProvider.getCompanyConfiguration(MentionsGroupServiceConfiguration.class, entry.getCompanyId());
        this._mentionsNotifier.notify(userId, entry.getGroupId(), entry.getTitle(), entry.getContent(), BlogsEntry.class.getName(), entry.getEntryId(), mentionsGroupServiceConfiguration.assetEntryMentionEmailSubject(), mentionsGroupServiceConfiguration.assetEntryMentionEmailBody(), serviceContext);
        return entry;
    }

    @Reference(unbind="-")
    protected void setBlogsEntryLocalService(BlogsEntryLocalService blogsEntryLocalService) {
        this._blogsEntryLocalService = blogsEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setMentionsNotifier(MentionsNotifier mentionsNotifier) {
        this._mentionsNotifier = mentionsNotifier;
    }
}

