/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.internal.bundle;

import com.liferay.marketplace.bundle.BundleManager;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.lpkg.deployer.LPKGVerifier;
import com.liferay.portal.util.ShutdownUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={BundleManager.class, BundleManagerImpl.class})
public class BundleManagerImpl
implements BundleManager {
    private static final int[] _INSTALLED_BUNDLE_STATES = new int[]{32, 2, 4};
    private static final Log _log = LogFactoryUtil.getLog(BundleManagerImpl.class);
    private BundleContext _bundleContext;
    @Reference
    private LPKGVerifier _lpkgVerifier;

    public Bundle getBundle(String symbolicName, String versionString) {
        Version version = Version.parseVersion((String)versionString);
        for (Bundle bundle : this.getBundles()) {
            if (!symbolicName.equals(bundle.getSymbolicName()) || !version.equals((Object)bundle.getVersion())) continue;
            return bundle;
        }
        return null;
    }

    public List<Bundle> getBundles() {
        return ListUtil.fromArray((Object[])this._bundleContext.getBundles());
    }

    public List<Bundle> getInstalledBundles() {
        List<Bundle> bundles = this.getBundles();
        Iterator<Bundle> iterator = bundles.iterator();
        while (iterator.hasNext()) {
            Bundle bundle = iterator.next();
            if (this.isInstalled(bundle)) continue;
            iterator.remove();
        }
        return bundles;
    }

    /*
     * Exception decompiling
     */
    public Manifest getManifest(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void installLPKG(File file) throws Exception {
        File installFile = new File(this.getInstallDirName(), file.getName());
        Files.move(file.toPath(), installFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (this.isRestartRequired(installFile)) {
            ShutdownUtil.shutdown((long)0L);
        }
    }

    public boolean isInstalled(Bundle bundle) {
        return ArrayUtil.contains((int[])_INSTALLED_BUNDLE_STATES, (int)bundle.getState());
    }

    public boolean isInstalled(String symbolicName, String version) {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle == null) {
            return false;
        }
        return this.isInstalled(bundle);
    }

    public void uninstallBundle(Bundle bundle) {
        try {
            bundle.uninstall();
        }
        catch (BundleException bundleException) {
            _log.error((Object)bundleException, (Throwable)bundleException);
        }
    }

    public void uninstallBundle(String symbolicName, String version) {
        Bundle bundle = this.getBundle(symbolicName, version);
        if (bundle == null) {
            return;
        }
        this.uninstallBundle(bundle);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    protected String getInstallDirName() throws Exception {
        Object[] autoDeployDirNames = PropsUtil.getArray((String)"module.framework.auto.deploy.dirs");
        if (ArrayUtil.isEmpty((Object[])autoDeployDirNames)) {
            throw new AutoDeployException("The portal property \"module.framework.auto.deploy.dirs\" is not set");
        }
        Object autoDeployDirName = autoDeployDirNames[0];
        for (Object curDirName : autoDeployDirNames) {
            if (!((String)curDirName).endsWith("/marketplace")) continue;
            autoDeployDirName = curDirName;
            break;
        }
        return autoDeployDirName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isRestartRequired(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry zipEntry = zipFile.getEntry("liferay-marketplace.properties");
            if (zipEntry == null) {
                boolean bl2 = false;
                return bl2;
            }
            Properties properties = new Properties();
            properties.load(zipFile.getInputStream(zipEntry));
            boolean bl = GetterUtil.getBoolean((String)properties.getProperty("restart-required"), (boolean)true);
            return bl;
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return false;
            _log.debug((Object)("Unable to read liferay-marketplace.properties from " + file.getName()));
            return false;
        }
    }
}

