/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.service.AppLocalService;
import com.liferay.marketplace.service.AppService;
import com.liferay.marketplace.service.AppServiceUtil;
import com.liferay.marketplace.service.persistence.AppPersistence;
import com.liferay.marketplace.service.persistence.ModulePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ClassNameService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import java.sql.Connection;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class AppServiceBaseImpl
extends BaseServiceImpl
implements AopService,
AppService,
IdentifiableOSGiService {
    @Reference
    protected AppLocalService appLocalService;
    protected AppService appService;
    @Reference
    protected AppPersistence appPersistence;
    @Reference
    protected ModulePersistence modulePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ClassNameService classNameService;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    @Reference
    protected UserService userService;
    private static final Log _log = LogFactoryUtil.getLog(AppServiceBaseImpl.class);

    @Deactivate
    protected void deactivate() {
        AppServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{AppService.class, IdentifiableOSGiService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.appService = (AppService)aopProxy;
        AppServiceUtil.setService((AppService)this.appService);
    }

    public String getOSGiServiceIdentifier() {
        return AppService.class.getName();
    }

    protected Class<?> getModelClass() {
        return App.class;
    }

    protected String getModelClassName() {
        return App.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.appPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

