/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.marketplace.service.persistence.impl;

import com.liferay.marketplace.exception.NoSuchAppException;
import com.liferay.marketplace.model.App;
import com.liferay.marketplace.model.impl.AppImpl;
import com.liferay.marketplace.model.impl.AppModelImpl;
import com.liferay.marketplace.service.persistence.AppPersistence;
import com.liferay.marketplace.service.persistence.AppUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AppPersistenceImpl
extends BasePersistenceImpl<App>
implements AppPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AppImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "app.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(app.uuid IS NULL OR app.uuid = '')";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "app.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(app.uuid IS NULL OR app.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "app.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "app.companyId = ?";
    private FinderPath _finderPathFetchByRemoteAppId;
    private FinderPath _finderPathCountByRemoteAppId;
    private static final String _FINDER_COLUMN_REMOTEAPPID_REMOTEAPPID_2 = "app.remoteAppId = ?";
    private FinderPath _finderPathWithPaginationFindByCategory;
    private FinderPath _finderPathWithoutPaginationFindByCategory;
    private FinderPath _finderPathCountByCategory;
    private static final String _FINDER_COLUMN_CATEGORY_CATEGORY_2 = "app.category = ?";
    private static final String _FINDER_COLUMN_CATEGORY_CATEGORY_3 = "(app.category IS NULL OR app.category = '')";
    private int _valueObjectFinderCacheListThreshold;
    @ServiceReference(type=EntityCache.class)
    protected EntityCache entityCache;
    @ServiceReference(type=FinderCache.class)
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_APP = "SELECT app FROM App app";
    private static final String _SQL_SELECT_APP_WHERE_PKS_IN = "SELECT app FROM App app WHERE appId IN (";
    private static final String _SQL_SELECT_APP_WHERE = "SELECT app FROM App app WHERE ";
    private static final String _SQL_COUNT_APP = "SELECT COUNT(app) FROM App app";
    private static final String _SQL_COUNT_APP_WHERE = "SELECT COUNT(app) FROM App app WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "app.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No App exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No App exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AppPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});

    public List<App> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<App> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<App> findByUuid(String uuid, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<App> findByUuid(String uuid, int start, int end, OrderByComparator<App> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (uuid.equals(app.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY app.appId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByUuid_First(String uuid, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_First(uuid, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByUuid_First(String uuid, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByUuid_Last(String uuid, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_Last(uuid, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByUuid_Last(String uuid, OrderByComparator<App> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByUuid_PrevAndNext(long appId, String uuid, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        uuid = Objects.toString(uuid, "");
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByUuid_PrevAndNext(session, app, uuid, orderByComparator, true), app, this.getByUuid_PrevAndNext(session, app, uuid, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByUuid_PrevAndNext(Session session, App app, String uuid, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_APP_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY app.appId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)app)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (App app : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<App> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<App> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<App> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<App> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<App> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (uuid.equals(app.getUuid()) && companyId == app.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("app.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY app.appId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByUuid_C_First(String uuid, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByUuid_C_Last(String uuid, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<App> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByUuid_C_PrevAndNext(long appId, String uuid, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        uuid = Objects.toString(uuid, "");
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByUuid_C_PrevAndNext(session, app, uuid, companyId, orderByComparator, true), app, this.getByUuid_C_PrevAndNext(session, app, uuid, companyId, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByUuid_C_PrevAndNext(Session session, App app, String uuid, long companyId, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_APP_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
        }
        sb.append("app.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY app.appId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)app)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (App app : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_APP_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_C_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_C_UUID_2);
            }
            sb.append("app.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<App> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<App> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<App> findByCompanyId(long companyId, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<App> findByCompanyId(long companyId, int start, int end, OrderByComparator<App> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (companyId == app.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_APP_WHERE);
            sb.append("app.companyId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY app.appId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByCompanyId_First(long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByCompanyId_First(long companyId, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByCompanyId_Last(long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByCompanyId_Last(long companyId, OrderByComparator<App> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByCompanyId_PrevAndNext(long appId, long companyId, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByCompanyId_PrevAndNext(session, app, companyId, orderByComparator, true), app, this.getByCompanyId_PrevAndNext(session, app, companyId, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByCompanyId_PrevAndNext(Session session, App app, long companyId, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_APP_WHERE);
        sb.append("app.companyId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY app.appId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)app)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (App app : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_APP_WHERE);
            sb.append("app.companyId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public App findByRemoteAppId(long remoteAppId) throws NoSuchAppException {
        App app = this.fetchByRemoteAppId(remoteAppId);
        if (app == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("remoteAppId=");
            sb.append(remoteAppId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchAppException(sb.toString());
        }
        return app;
    }

    public App fetchByRemoteAppId(long remoteAppId) {
        return this.fetchByRemoteAppId(remoteAppId, true);
    }

    public App fetchByRemoteAppId(long remoteAppId, boolean useFinderCache) {
        App app;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{remoteAppId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByRemoteAppId, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof App && remoteAppId != (app = (App)result).getRemoteAppId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_APP_WHERE);
            sb.append(_FINDER_COLUMN_REMOTEAPPID_REMOTEAPPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(remoteAppId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByRemoteAppId, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{remoteAppId};
                            }
                            _log.warn((Object)("AppPersistenceImpl.fetchByRemoteAppId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    App app2 = (App)list.get(0);
                    result = app2;
                    this.cacheResult(app2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByRemoteAppId, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (App)result;
    }

    public App removeByRemoteAppId(long remoteAppId) throws NoSuchAppException {
        App app = this.findByRemoteAppId(remoteAppId);
        return (App)this.remove((BaseModel)app);
    }

    public int countByRemoteAppId(long remoteAppId) {
        FinderPath finderPath = this._finderPathCountByRemoteAppId;
        Object[] finderArgs = new Object[]{remoteAppId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_APP_WHERE);
            sb.append(_FINDER_COLUMN_REMOTEAPPID_REMOTEAPPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(remoteAppId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<App> findByCategory(String category) {
        return this.findByCategory(category, -1, -1, null);
    }

    public List<App> findByCategory(String category, int start, int end) {
        return this.findByCategory(category, start, end, null);
    }

    public List<App> findByCategory(String category, int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findByCategory(category, start, end, orderByComparator, true);
    }

    public List<App> findByCategory(String category, int start, int end, OrderByComparator<App> orderByComparator, boolean useFinderCache) {
        category = Objects.toString(category, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCategory;
                finderArgs = new Object[]{category};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCategory;
            finderArgs = new Object[]{category, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (App app : list) {
                if (category.equals(app.getCategory())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_APP_WHERE);
            boolean bindCategory = false;
            if (category.isEmpty()) {
                sb.append(_FINDER_COLUMN_CATEGORY_CATEGORY_3);
            } else {
                bindCategory = true;
                sb.append(_FINDER_COLUMN_CATEGORY_CATEGORY_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY app.appId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindCategory) {
                    queryPos.add(category);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public App findByCategory_First(String category, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCategory_First(category, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("category=");
        sb.append(category);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByCategory_First(String category, OrderByComparator<App> orderByComparator) {
        List<App> list = this.findByCategory(category, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App findByCategory_Last(String category, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        App app = this.fetchByCategory_Last(category, orderByComparator);
        if (app != null) {
            return app;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("category=");
        sb.append(category);
        sb.append("}");
        throw new NoSuchAppException(sb.toString());
    }

    public App fetchByCategory_Last(String category, OrderByComparator<App> orderByComparator) {
        int count = this.countByCategory(category);
        if (count == 0) {
            return null;
        }
        List<App> list = this.findByCategory(category, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public App[] findByCategory_PrevAndNext(long appId, String category, OrderByComparator<App> orderByComparator) throws NoSuchAppException {
        category = Objects.toString(category, "");
        App app = this.findByPrimaryKey(appId);
        Session session = null;
        try {
            session = this.openSession();
            App[] array = new AppImpl[]{this.getByCategory_PrevAndNext(session, app, category, orderByComparator, true), app, this.getByCategory_PrevAndNext(session, app, category, orderByComparator, false)};
            App[] appArray = array;
            return appArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App getByCategory_PrevAndNext(Session session, App app, String category, OrderByComparator<App> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_APP_WHERE);
        boolean bindCategory = false;
        if (category.isEmpty()) {
            sb.append(_FINDER_COLUMN_CATEGORY_CATEGORY_3);
        } else {
            bindCategory = true;
            sb.append(_FINDER_COLUMN_CATEGORY_CATEGORY_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY app.appId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindCategory) {
            queryPos.add(category);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)app)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (App)list.get(1);
        }
        return null;
    }

    public void removeByCategory(String category) {
        for (App app : this.findByCategory(category, -1, -1, null)) {
            this.remove((BaseModel)app);
        }
    }

    public int countByCategory(String category) {
        category = Objects.toString(category, "");
        FinderPath finderPath = this._finderPathCountByCategory;
        Object[] finderArgs = new Object[]{category};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_APP_WHERE);
            boolean bindCategory = false;
            if (category.isEmpty()) {
                sb.append(_FINDER_COLUMN_CATEGORY_CATEGORY_3);
            } else {
                bindCategory = true;
                sb.append(_FINDER_COLUMN_CATEGORY_CATEGORY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindCategory) {
                    queryPos.add(category);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AppPersistenceImpl() {
        block2: {
            HashMap<String, String> dbColumnNames = new HashMap<String, String>();
            dbColumnNames.put("uuid", "uuid_");
            try {
                Field field = BasePersistenceImpl.class.getDeclaredField("_dbColumnNames");
                field.setAccessible(true);
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        this.setModelClass(App.class);
    }

    public void cacheResult(App app) {
        this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()), (Serializable)app);
        this.finderCache.putResult(this._finderPathFetchByRemoteAppId, new Object[]{app.getRemoteAppId()}, (Object)app);
        app.resetOriginalValues();
    }

    public void cacheResult(List<App> apps) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && apps.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (App app : apps) {
            if (this.entityCache.getResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey())) == null) {
                this.cacheResult(app);
                continue;
            }
            app.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(AppImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(App app) {
        this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((AppModelImpl)app, true);
    }

    public void clearCache(List<App> apps) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (App app : apps) {
            this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()));
            this.clearUniqueFindersCache((AppModelImpl)app, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(AppModelImpl appModelImpl) {
        Object[] args = new Object[]{appModelImpl.getRemoteAppId()};
        this.finderCache.putResult(this._finderPathCountByRemoteAppId, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByRemoteAppId, args, (Object)appModelImpl, false);
    }

    protected void clearUniqueFindersCache(AppModelImpl appModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{appModelImpl.getRemoteAppId()};
            this.finderCache.removeResult(this._finderPathCountByRemoteAppId, args);
            this.finderCache.removeResult(this._finderPathFetchByRemoteAppId, args);
        }
        if ((appModelImpl.getColumnBitmask() & this._finderPathFetchByRemoteAppId.getColumnBitmask()) != 0L) {
            args = new Object[]{appModelImpl.getOriginalRemoteAppId()};
            this.finderCache.removeResult(this._finderPathCountByRemoteAppId, args);
            this.finderCache.removeResult(this._finderPathFetchByRemoteAppId, args);
        }
    }

    public App create(long appId) {
        AppImpl app = new AppImpl();
        app.setNew(true);
        app.setPrimaryKey(appId);
        String uuid = PortalUUIDUtil.generate();
        app.setUuid(uuid);
        app.setCompanyId(CompanyThreadLocal.getCompanyId());
        return app;
    }

    public App remove(long appId) throws NoSuchAppException {
        return this.remove(Long.valueOf(appId));
    }

    public App remove(Serializable primaryKey) throws NoSuchAppException {
        Session session = null;
        try {
            session = this.openSession();
            App app = (App)session.get(AppImpl.class, primaryKey);
            if (app == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchAppException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            App app2 = (App)this.remove((BaseModel)app);
            return app2;
        }
        catch (NoSuchAppException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected App removeImpl(App app) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)app)) {
                app = (App)session.get(AppImpl.class, app.getPrimaryKeyObj());
            }
            if (app != null) {
                session.delete((Object)app);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (app != null) {
            this.clearCache(app);
        }
        return app;
    }

    public App updateImpl(App app) {
        boolean isNew = app.isNew();
        if (!(app instanceof AppModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(app.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)app);
                throw new IllegalArgumentException("Implement ModelWrapper in app proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom App implementation " + app.getClass());
        }
        AppModelImpl appModelImpl = (AppModelImpl)app;
        if (Validator.isNull((String)app.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            app.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && app.getCreateDate() == null) {
            if (serviceContext == null) {
                app.setCreateDate(date);
            } else {
                app.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!appModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                app.setModifiedDate(date);
            } else {
                app.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)app);
                app.setNew(false);
            } else {
                app = (App)session.merge((Object)app);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!AppModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{appModelImpl.getUuid()};
            this.finderCache.removeResult(this._finderPathCountByUuid, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            args = new Object[]{appModelImpl.getUuid(), appModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            args = new Object[]{appModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{appModelImpl.getCategory()};
            this.finderCache.removeResult(this._finderPathCountByCategory, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCategory, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((appModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
                args = new Object[]{appModelImpl.getUuid()};
                this.finderCache.removeResult(this._finderPathCountByUuid, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid, args);
            }
            if ((appModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUuid_C.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalUuid(), appModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
                args = new Object[]{appModelImpl.getUuid(), appModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByUuid_C, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUuid_C, args);
            }
            if ((appModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{appModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((appModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCategory.getColumnBitmask()) != 0L) {
                args = new Object[]{appModelImpl.getOriginalCategory()};
                this.finderCache.removeResult(this._finderPathCountByCategory, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCategory, args);
                args = new Object[]{appModelImpl.getCategory()};
                this.finderCache.removeResult(this._finderPathCountByCategory, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCategory, args);
            }
        }
        this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, (Serializable)Long.valueOf(app.getPrimaryKey()), (Serializable)app, false);
        this.clearUniqueFindersCache(appModelImpl, false);
        this.cacheUniqueFindersCache(appModelImpl);
        app.resetOriginalValues();
        return app;
    }

    public App findByPrimaryKey(Serializable primaryKey) throws NoSuchAppException {
        App app = this.fetchByPrimaryKey(primaryKey);
        if (app == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchAppException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return app;
    }

    public App findByPrimaryKey(long appId) throws NoSuchAppException {
        return this.findByPrimaryKey(Long.valueOf(appId));
    }

    public App fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        App app = (App)serializable;
        if (app == null) {
            Session session = null;
            try {
                session = this.openSession();
                app = (App)session.get(AppImpl.class, primaryKey);
                if (app != null) {
                    this.cacheResult(app);
                } else {
                    this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception exception) {
                this.entityCache.removeResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, primaryKey);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return app;
    }

    public App fetchByPrimaryKey(long appId) {
        return this.fetchByPrimaryKey(Long.valueOf(appId));
    }

    public Map<Serializable, App> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, App> map = new HashMap<Serializable, App>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            App app = this.fetchByPrimaryKey(primaryKey);
            if (app != null) {
                map.put(primaryKey, app);
            }
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (App)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler sb = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        sb.append(_SQL_SELECT_APP_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            sb.append(((Long)serializable).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String string = sb.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(string);
            for (App app : query.list()) {
                map.put(app.getPrimaryKeyObj(), app);
                this.cacheResult(app);
                uncachedPrimaryKeys.remove(app.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(AppModelImpl.ENTITY_CACHE_ENABLED, AppImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception exception) {
            try {
                throw this.processException(exception);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<App> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<App> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<App> findAll(int start, int end, OrderByComparator<App> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<App> findAll(int start, int end, OrderByComparator<App> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_APP);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_APP;
                sql = sql.concat(" ORDER BY app.appId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (App app : this.findAll()) {
            this.remove((BaseModel)app);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_APP);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return AppModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByUuid = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, 8L);
        this._finderPathCountByUuid = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, 10L);
        this._finderPathCountByUuid_C = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 2L);
        this._finderPathCountByCompanyId = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathFetchByRemoteAppId = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByRemoteAppId", new String[]{Long.class.getName()}, 4L);
        this._finderPathCountByRemoteAppId = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByRemoteAppId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCategory = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCategory", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCategory = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, AppImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCategory", new String[]{String.class.getName()}, 1L);
        this._finderPathCountByCategory = new FinderPath(AppModelImpl.ENTITY_CACHE_ENABLED, AppModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCategory", new String[]{String.class.getName()});
        AppUtil.setPersistence((AppPersistence)this);
    }

    public void destroy() {
        AppUtil.setPersistence(null);
        this.entityCache.removeCache(AppImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

