Liferay.Loader.define("map-openstreetmap@5.0.29/js/OpenStreetMapGeoJSON.es", ['module', 'exports', 'require', 'map-common/js/GeoJSONBase.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.OpenStreetMapGeoJSONBase = exports.default = void 0;

    var _GeoJSONBase2 = _interopRequireDefault(require("map-common/js/GeoJSONBase.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * OpenStreetMapGeoJSONBase
     * @review
     */
    var OpenStreetMapGeoJSONBase = /*#__PURE__*/function (_GeoJSONBase) {
      _inherits(OpenStreetMapGeoJSONBase, _GeoJSONBase);

      /**
       * Creates a new map geojson parser using OpenStreetMap's API
       * @param {Array} args List of arguments to be passed to State
       * @review
       */
      function OpenStreetMapGeoJSONBase() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, OpenStreetMapGeoJSONBase);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(OpenStreetMapGeoJSONBase)).call.apply(_getPrototypeOf2, [this].concat(args)));
        _this._handleFeatureClicked = _this._handleFeatureClicked.bind(_assertThisInitialized(_this));
        return _this;
      }
      /**
       * @inheritDoc
       * @review
       */

      _createClass(OpenStreetMapGeoJSONBase, [{
        key: "_getNativeFeatures",
        value: function _getNativeFeatures(geoJSONData) {
          var _this2 = this;

          var features = [];
          L.geoJson(geoJSONData, {
            onEachFeature: function onEachFeature(feature, layer) {
              layer.on('click', _this2._handleFeatureClicked);
              features.push(feature);
            }
          }).addTo(this.map);
          return features;
        }
        /**
         * @inheritDoc
         * @review
         */

      }, {
        key: "_wrapNativeFeature",
        value: function _wrapNativeFeature(nativeFeature) {
          var feature = nativeFeature.geometry ? nativeFeature : nativeFeature.target.feature;
          var geometry = feature.geometry;
          return {
            getGeometry: function getGeometry() {
              return {
                get: function get() {
                  return L.latLng(geometry.coordinates[1], geometry.coordinates[0]);
                }
              };
            },
            getMarker: function getMarker() {
              return nativeFeature.target;
            },
            getProperty: function getProperty(prop) {
              return feature.properties[prop];
            }
          };
        }
      }]);

      return OpenStreetMapGeoJSONBase;
    }(_GeoJSONBase2.default);

    exports.OpenStreetMapGeoJSONBase = OpenStreetMapGeoJSONBase;
    var _default = OpenStreetMapGeoJSONBase;
    exports.default = _default;
    //# sourceMappingURL=OpenStreetMapGeoJSON.es.js.map
  }
});
//# sourceMappingURL=OpenStreetMapGeoJSON.es.js.map