Liferay.Loader.define("map-openstreetmap@5.0.29/js/OpenStreetMapDialog.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.OpenStreetMapDialog = exports.default = void 0;

    var _metalState = _interopRequireWildcard(require("frontend-js-metal-web$metal-state"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * OpenStreetMapDialog
     * @review
     */
    var OpenStreetMapDialog = /*#__PURE__*/function (_State) {
      _inherits(OpenStreetMapDialog, _State);

      /**
       * Creates a new map dialog using OpenStreetMap's API
       * @param  {Array} args List of arguments to be passed to State
       * @review
       */
      function OpenStreetMapDialog() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, OpenStreetMapDialog);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(OpenStreetMapDialog)).call.apply(_getPrototypeOf2, [this].concat(args)));
        _this._dialog = L.popup({
          className: 'leaflet-popup',
          minWidth: 400
        });
        return _this;
      }
      /**
       * Opens the dialog with the given map attribute and passes
       * the given configuration to the dialog object.
       * @param {Object} cfg
       * @review
       */

      _createClass(OpenStreetMapDialog, [{
        key: "open",
        value: function open(cfg) {
          this._dialog.setContent(cfg.content);

          this._dialog.setLatLng(cfg.position);

          this._dialog.options.offset = cfg.marker.options.icon.options.popupAnchor || [0, 0];

          this._dialog.openOn(this.map);
        }
      }]);

      return OpenStreetMapDialog;
    }(_metalState.default);
    /**
     * State definition.
     * @review
     * @static
     * @type {!Object}
     */

    exports.OpenStreetMapDialog = OpenStreetMapDialog;
    OpenStreetMapDialog.STATE = {
      /**
       * Map used for creating the dialog content
       * @review
       * @type {Object}
       */
      map: _metalState.Config.object()
    };
    var _default = OpenStreetMapDialog;
    exports.default = _default;
    //# sourceMappingURL=OpenStreetMapDialog.es.js.map
  }
});
//# sourceMappingURL=OpenStreetMapDialog.es.js.map