Liferay.Loader.define("map-openstreetmap@5.0.29/js/MapOpenStreetMap.es", ['module', 'exports', 'require', 'map-common/js/MapBase.es', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-state', './OpenStreetMapDialog.es', './OpenStreetMapGeoJSON.es', './OpenStreetMapGeocoder.es', './OpenStreetMapMarker.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.MapOpenStreetMap = exports.default = void 0;

    var _MapBase2 = _interopRequireDefault(require("map-common/js/MapBase.es"));

    var _metalDom = require("frontend-js-metal-web$metal-dom");

    var _metalState = require("frontend-js-metal-web$metal-state");

    var _OpenStreetMapDialog = _interopRequireDefault(require("./OpenStreetMapDialog.es"));

    var _OpenStreetMapGeoJSON = _interopRequireDefault(require("./OpenStreetMapGeoJSON.es"));

    var _OpenStreetMapGeocoder = _interopRequireDefault(require("./OpenStreetMapGeocoder.es"));

    var _OpenStreetMapMarker = _interopRequireDefault(require("./OpenStreetMapMarker.es"));

    var _MapOpenStreetMap$CON, _MapOpenStreetMap$POS;

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    function _possibleConstructorReturn(self, call) {
      if (call && (_typeof(call) === "object" || typeof call === "function")) {
        return call;
      }return _assertThisInitialized(self);
    }

    function _assertThisInitialized(self) {
      if (self === void 0) {
        throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
      }return self;
    }

    function _getPrototypeOf(o) {
      _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
        return o.__proto__ || Object.getPrototypeOf(o);
      };return _getPrototypeOf(o);
    }

    function _inherits(subClass, superClass) {
      if (typeof superClass !== "function" && superClass !== null) {
        throw new TypeError("Super expression must either be null or a function");
      }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
    }

    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
        o.__proto__ = p;return o;
      };return _setPrototypeOf(o, p);
    }

    /**
     * MapOpenStreetMap
     * @review
     */
    var MapOpenStreetMap = /*#__PURE__*/function (_MapBase) {
      _inherits(MapOpenStreetMap, _MapBase);

      /**
       * Creates a new map using OpenStreetMap's API
       * @param  {Array} args List of arguments to be passed to State
       * @review
       */
      function MapOpenStreetMap() {
        var _getPrototypeOf2;

        var _this;

        _classCallCheck(this, MapOpenStreetMap);

        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }

        _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(MapOpenStreetMap)).call.apply(_getPrototypeOf2, [this].concat(args)));
        _this._map = null;
        return _this;
      }
      /**
       * @inheritDoc
       * @review
       */

      _createClass(MapOpenStreetMap, [{
        key: "_createMap",
        value: function _createMap(location, controlsConfig) {
          var mapConfig = {
            center: location,
            layers: [L.tileLayer(this.tileURI)],
            zoom: this.zoom
          };
          var map = L.map((0, _metalDom.toElement)(this.boundingBox), Object.assign(mapConfig, controlsConfig));

          if (this.data && this.data.features) {
            var bounds = new L.LatLngBounds();
            this.data.features.forEach(function (feature) {
              return bounds.extend(new L.LatLng(feature.geometry.coordinates[1], feature.geometry.coordinates[0]));
            });
            map.fitBounds(bounds);
          }

          return map;
        }
        /**
         * @inheritDoc
         * @review
         */

      }, {
        key: "addControl",
        value: function addControl(control, position) {
          var LeafLetControl = L.Control.extend({
            onAdd: function onAdd() {
              return (0, _metalDom.toElement)(control);
            },
            options: {
              position: MapOpenStreetMap.POSITION_MAP[position]
            }
          });

          this._map.addControl(new LeafLetControl());
        }
        /**
         * @inheritDoc
         * @review
         */

      }, {
        key: "getBounds",
        value: function getBounds() {
          return this._map.getBounds();
        }
        /**
         * @inheritDoc
         * @review
         */

      }, {
        key: "setCenter",
        value: function setCenter(location) {
          if (this._map) {
            this._map.panTo(location);
          }

          if (this._geolocationMarker) {
            this._geolocationMarker.setPosition(location);
          }
        }
      }]);

      return MapOpenStreetMap;
    }(_MapBase2.default);

    exports.MapOpenStreetMap = MapOpenStreetMap;
    _MapBase2.default.DialogImpl = _OpenStreetMapDialog.default;
    _MapBase2.default.GeocoderImpl = _OpenStreetMapGeocoder.default;
    _MapBase2.default.GeoJSONImpl = _OpenStreetMapGeoJSON.default;
    _MapBase2.default.MarkerImpl = _OpenStreetMapMarker.default;
    _MapBase2.default.SearchImpl = null;
    MapOpenStreetMap.CONTROLS_MAP = (_MapOpenStreetMap$CON = {}, _defineProperty(_MapOpenStreetMap$CON, _MapBase2.default.CONTROLS.ATTRIBUTION, 'attributionControl'), _defineProperty(_MapOpenStreetMap$CON, _MapBase2.default.CONTROLS.ZOOM, 'zoomControl'), _MapOpenStreetMap$CON);
    MapOpenStreetMap.POSITION_MAP = (_MapOpenStreetMap$POS = {}, _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.BOTTOM, 'bottomleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.BOTTOM_CENTER, 'bottomleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.BOTTOM_LEFT, 'bottomleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.BOTTOM_RIGHT, 'bottomright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.CENTER, 'topleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.LEFT, 'topleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.LEFT_BOTTOM, 'bottomleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.LEFT_CENTER, 'topleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.LEFT_TOP, 'topleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.RIGHT, 'bottomright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.RIGHT_BOTTOM, 'bottomright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.RIGHT_CENTER, 'bottomright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.RIGHT_TOP, 'topright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.TOP, 'topright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.TOP_CENTER, 'topright'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.TOP_LEFT, 'topleft'), _defineProperty(_MapOpenStreetMap$POS, _MapBase2.default.POSITION.TOP_RIGHT, 'topright'), _MapOpenStreetMap$POS);
    /**
     * State definition.
     * @type {!Object}
     * @static
     */

    MapOpenStreetMap.STATE = _objectSpread(_objectSpread({}, _MapBase2.default.STATE), {}, {
      /**
       * Url used for fetching map tile information
       * @type {string}
       */
      tileURI: _metalState.Config.string().value('//{s}.tile.openstreetmap.org/{z}/{x}/{y}.png')
    });
    var _default = MapOpenStreetMap;
    exports.default = _default;
    //# sourceMappingURL=MapOpenStreetMap.es.js.map
  }
});
//# sourceMappingURL=MapOpenStreetMap.es.js.map