/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.mailbox;

import com.liferay.mail.reader.exception.MailException;
import com.liferay.mail.reader.exception.NoSuchAccountException;
import com.liferay.mail.reader.mailbox.Mailbox;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.service.AccountLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;

public abstract class BaseMailbox
implements Mailbox {
    protected Account account;
    protected User user;

    public Account addAccount(String address, String personalName, String protocol, String incomingHostName, int incomingPort, boolean incomingSecure, String outgoingHostName, int outgoingPort, boolean outgoingSecure, String login, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, boolean defaultSender) throws PortalException {
        this.validateAccount(incomingHostName, incomingPort, incomingSecure, outgoingHostName, outgoingPort, outgoingSecure, login, password);
        try {
            AccountLocalServiceUtil.getAccount((long)this.user.getUserId(), (String)address);
            throw new MailException(1);
        }
        catch (NoSuchAccountException noSuchAccountException) {
            long inboxFolderId = 0L;
            long draftFolderId = 0L;
            long sentFolderId = 0L;
            long trashFolderId = 0L;
            return AccountLocalServiceUtil.addAccount((long)this.user.getUserId(), (String)address, (String)personalName, (String)protocol, (String)incomingHostName, (int)incomingPort, (boolean)incomingSecure, (String)outgoingHostName, (int)outgoingPort, (boolean)outgoingSecure, (String)login, (String)password, (boolean)savePassword, (String)signature, (boolean)useSignature, (String)folderPrefix, (long)inboxFolderId, (long)draftFolderId, (long)sentFolderId, (long)trashFolderId, (boolean)defaultSender);
        }
    }

    public void deleteAccount() throws PortalException {
        AccountLocalServiceUtil.deleteAccount((long)this.account.getAccountId());
    }

    public Account getAccount() {
        return this.account;
    }

    public User getUser() {
        return this.user;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Account updateAccount(long accountId, String personalName, String password, boolean savePassword, String signature, boolean useSignature, String folderPrefix, boolean defaultSender) throws PortalException {
        Account account = AccountLocalServiceUtil.getAccount((long)accountId);
        this.validateAccount(account.getIncomingHostName(), account.getIncomingPort(), account.isIncomingSecure(), account.getOutgoingHostName(), account.getOutgoingPort(), account.isOutgoingSecure(), account.getLogin(), password);
        return AccountLocalServiceUtil.updateAccount((long)accountId, (String)personalName, (String)password, (boolean)savePassword, (String)signature, (boolean)useSignature, (String)folderPrefix, (boolean)defaultSender);
    }

    public void updateFolders(long inboxFolderId, long draftFolderId, long sentFolderId, long trashFolderId) throws PortalException {
        AccountLocalServiceUtil.updateFolders((long)this.account.getAccountId(), (long)inboxFolderId, (long)draftFolderId, (long)sentFolderId, (long)trashFolderId);
    }
}

