/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.internal.imap;

import com.liferay.mail.reader.exception.MailException;
import com.liferay.mail.reader.internal.imap.IMAPAccessor;
import com.liferay.mail.reader.model.Account;
import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.service.FolderLocalServiceUtil;
import com.liferay.mail.reader.service.MessageLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;

public class IMAPMessageCountListener
implements MessageCountListener {
    private static final Log _log = LogFactoryUtil.getLog(IMAPMessageCountListener.class);
    private final Account _account;
    private final IMAPAccessor _imapAccessor;

    public IMAPMessageCountListener(User user, Account account, String password) {
        this._account = account;
        this._imapAccessor = new IMAPAccessor(user, account, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagesAdded(MessageCountEvent messageCountEvent) {
        javax.mail.Message[] jxMessages = messageCountEvent.getMessages();
        javax.mail.Folder jxFolder = null;
        try {
            jxFolder = this._imapAccessor.openFolder(jxMessages[0].getFolder());
            Folder folder = FolderLocalServiceUtil.getFolder((long)this._account.getAccountId(), (String)jxFolder.getFullName());
            this._imapAccessor.storeEnvelopes(folder.getFolderId(), jxFolder, jxMessages);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to add messages", (Throwable)exception);
        }
        finally {
            try {
                this._imapAccessor.closeFolder(jxFolder, false);
            }
            catch (MailException mailException) {
                _log.error((Object)mailException, (Throwable)mailException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagesRemoved(MessageCountEvent messageCountEvent) {
        javax.mail.Message[] jxMessages = messageCountEvent.getMessages();
        javax.mail.Folder jxFolder = null;
        try {
            long[] remoteMessageUIds;
            jxFolder = this._imapAccessor.openFolder(jxMessages[0].getFolder());
            Folder folder = FolderLocalServiceUtil.getFolder((long)this._account.getAccountId(), (String)jxFolder.getFullName());
            for (long remoteMessageUId : remoteMessageUIds = this._imapAccessor.getMessageUIDs(jxFolder, jxMessages)) {
                Message message = MessageLocalServiceUtil.getMessage((long)folder.getFolderId(), (long)remoteMessageUId);
                MessageLocalServiceUtil.deleteMessage((long)message.getMessageId());
            }
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to delete messages", (Throwable)exception);
        }
        finally {
            try {
                this._imapAccessor.closeFolder(jxFolder, false);
            }
            catch (MailException mailException) {
                _log.error((Object)mailException, (Throwable)mailException);
            }
        }
    }
}

