/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.reader.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.mail.reader.model.Message;
import com.liferay.mail.reader.service.MessageLocalService;
import com.liferay.mail.reader.service.MessageLocalServiceUtil;
import com.liferay.mail.reader.service.persistence.AccountPersistence;
import com.liferay.mail.reader.service.persistence.AttachmentPersistence;
import com.liferay.mail.reader.service.persistence.FolderPersistence;
import com.liferay.mail.reader.service.persistence.MessagePersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class MessageLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
MessageLocalService {
    @Reference
    protected AccountPersistence accountPersistence;
    @Reference
    protected AttachmentPersistence attachmentPersistence;
    @Reference
    protected FolderPersistence folderPersistence;
    protected MessageLocalService messageLocalService;
    @Reference
    protected MessagePersistence messagePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ClassNameLocalService classNameLocalService;
    @Reference
    protected ResourceLocalService resourceLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(MessageLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Message addMessage(Message message) {
        message.setNew(true);
        return (Message)this.messagePersistence.update((BaseModel)message);
    }

    @Transactional(enabled=false)
    public Message createMessage(long messageId) {
        return this.messagePersistence.create(messageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Message deleteMessage(long messageId) throws PortalException {
        return this.messagePersistence.remove(messageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Message deleteMessage(Message message) throws PortalException {
        return (Message)this.messagePersistence.remove((BaseModel)message);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Message.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.messagePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.messagePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.messagePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.messagePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.messagePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Message fetchMessage(long messageId) {
        return this.messagePersistence.fetchByPrimaryKey(messageId);
    }

    public Message getMessage(long messageId) throws PortalException {
        return this.messagePersistence.findByPrimaryKey(messageId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.messageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Message.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("messageId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.messageLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Message.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("messageId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.messageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Message.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("messageId");
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.messageLocalService.deleteMessage((Message)persistedModel);
    }

    public BasePersistence<Message> getBasePersistence() {
        return this.messagePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.messagePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Message> getMessages(int start, int end) {
        return this.messagePersistence.findAll(start, end);
    }

    public int getMessagesCount() {
        return this.messagePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Message updateMessage(Message message) {
        return (Message)this.messagePersistence.update((BaseModel)message);
    }

    @Deactivate
    protected void deactivate() {
        MessageLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{MessageLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.messageLocalService = (MessageLocalService)aopProxy;
        MessageLocalServiceUtil.setService((MessageLocalService)this.messageLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return MessageLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Message.class;
    }

    protected String getModelClassName() {
        return Message.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.messagePersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

