/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.mail.reader.model.impl;

import com.liferay.mail.reader.model.Folder;
import com.liferay.mail.reader.service.FolderLocalServiceUtil;

/**
 * The extended model base implementation for the Folder service. Represents a row in the &quot;Mail_Folder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link FolderImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FolderImpl
 * @see Folder
 * @generated
 */
public abstract class FolderBaseImpl extends FolderModelImpl implements Folder {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a folder model instance should use the <code>Folder</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			FolderLocalServiceUtil.addFolder(this);
		}
		else {
			FolderLocalServiceUtil.updateFolder(this);
		}
	}

}