/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.service.impl;

import com.liferay.layout.model.LayoutLocalization;
import com.liferay.layout.service.base.LayoutLocalizationLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.layout.model.LayoutLocalization"}, service={AopService.class})
public class LayoutLocalizationLocalServiceImpl
extends LayoutLocalizationLocalServiceBaseImpl {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;

    public LayoutLocalization addLayoutLocalization(long groupId, String content, String languageId, long plid, ServiceContext serviceContext) {
        long layoutLocalizationId = this.counterLocalService.increment();
        LayoutLocalization layoutLocalization = this.layoutLocalizationPersistence.create(layoutLocalizationId);
        layoutLocalization.setUuid(serviceContext.getUuid());
        layoutLocalization.setGroupId(groupId);
        long companyId = serviceContext.getCompanyId();
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group != null) {
            companyId = group.getCompanyId();
        }
        layoutLocalization.setCompanyId(companyId);
        layoutLocalization.setContent(content);
        layoutLocalization.setLanguageId(languageId);
        layoutLocalization.setPlid(plid);
        return (LayoutLocalization)this.layoutLocalizationPersistence.update((BaseModel)layoutLocalization);
    }

    public LayoutLocalization fetchLayoutLocalization(long groupId, String languageId, long plid) {
        return this.layoutLocalizationPersistence.fetchByG_L_P(groupId, languageId, plid);
    }

    public LayoutLocalization getLayoutLocalization(String languageId, long plid) throws PortalException {
        return this.layoutLocalizationPersistence.findByL_P(languageId, plid);
    }

    public List<LayoutLocalization> getLayoutLocalizations(long plid) {
        return this.layoutLocalizationPersistence.findByPlid(plid);
    }

    public LayoutLocalization updateLayoutLocalization(String content, String languageId, long plid, ServiceContext serviceContext) {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        LayoutLocalization layoutLocalization = this.layoutLocalizationPersistence.fetchByG_L_P(layout.getGroupId(), languageId, layout.getPlid());
        if (layoutLocalization == null) {
            return this.addLayoutLocalization(layout.getGroupId(), content, languageId, plid, serviceContext);
        }
        layoutLocalization.setContent(content);
        return (LayoutLocalization)this.layoutLocalizationPersistence.update((BaseModel)layoutLocalization);
    }
}

