/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.upgrade.v1_2_3;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.GroupTable;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutSetBranchTable;
import com.liferay.portal.kernel.model.LayoutTable;
import com.liferay.portal.kernel.service.LayoutBranchLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutRevisionLocalService;
import com.liferay.portal.kernel.service.LayoutSetBranchLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.util.Iterator;
import java.util.List;

public class LayoutRevisionUpgradeProcess
extends UpgradeProcess {
    private final LayoutBranchLocalService _layoutBranchLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutRevisionLocalService _layoutRevisionLocalService;
    private final LayoutSetBranchLocalService _layoutSetBranchLocalService;

    public LayoutRevisionUpgradeProcess(LayoutBranchLocalService layoutBranchLocalService, LayoutLocalService layoutLocalService, LayoutRevisionLocalService layoutRevisionLocalService, LayoutSetBranchLocalService layoutSetBranchLocalService) {
        this._layoutBranchLocalService = layoutBranchLocalService;
        this._layoutLocalService = layoutLocalService;
        this._layoutRevisionLocalService = layoutRevisionLocalService;
        this._layoutSetBranchLocalService = layoutSetBranchLocalService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUpgrade() throws PortalException {
        boolean stagingAdvicesThreadLocalEnabled = StagingAdvicesThreadLocal.isEnabled();
        try {
            StagingAdvicesThreadLocal.setEnabled((boolean)false);
            for (Layout layout : (List)this._layoutLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)LayoutTable.INSTANCE).from((Table)LayoutTable.INSTANCE).where(LayoutTable.INSTANCE.groupId.in(this._getBranchingEnabledStagingGroupIdsDSLQuery()).and((Expression)LayoutTable.INSTANCE.hidden.eq((Object)false)).and((Expression)LayoutTable.INSTANCE.system.eq((Object)false)).and((Expression)LayoutTable.INSTANCE.type.eq((Object)"content"))))) {
                this._createInitialContentLayoutRevisions(layout);
            }
        }
        finally {
            StagingAdvicesThreadLocal.setEnabled((boolean)stagingAdvicesThreadLocalEnabled);
        }
    }

    private void _createInitialContentLayoutRevisions(Layout layout) throws PortalException {
        int layoutRevisionsCount = this._layoutRevisionLocalService.getLayoutRevisionsCount(layout.getPlid());
        if (layoutRevisionsCount > 0) {
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setUserId(layout.getUserId());
        Iterator iterator = ((List)this._layoutSetBranchLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{LayoutSetBranchTable.INSTANCE.layoutSetBranchId}).from((Table)LayoutSetBranchTable.INSTANCE).where(LayoutSetBranchTable.INSTANCE.groupId.eq((Object)layout.getGroupId()).and((Expression)LayoutSetBranchTable.INSTANCE.privateLayout.eq((Object)layout.isPrivateLayout()))))).iterator();
        while (iterator.hasNext()) {
            long layoutSetBranchId = (Long)iterator.next();
            LayoutBranch layoutBranch = this._layoutBranchLocalService.getMasterLayoutBranch(layoutSetBranchId, layout.getPlid(), serviceContext);
            this._layoutRevisionLocalService.addLayoutRevision(layout.getUserId(), layoutSetBranchId, layoutBranch.getLayoutBranchId(), 0L, true, layout.getPlid(), 0L, layout.isPrivateLayout(), layout.getName(), layout.getTitle(), layout.getDescription(), layout.getKeywords(), layout.getRobots(), layout.getTypeSettings(), layout.getIconImage(), layout.getIconImageId(), layout.getThemeId(), layout.getColorSchemeId(), layout.getCss(), serviceContext);
        }
    }

    private DSLQuery _getBranchingEnabledStagingGroupIdsDSLQuery() {
        return DSLQueryFactoryUtil.select((Expression[])new Expression[]{GroupTable.INSTANCE.groupId}).from((Table)GroupTable.INSTANCE).where(Predicate.withParentheses((Predicate)GroupTable.INSTANCE.typeSettings.like("%stagedRemotely=true%").and((Expression)Predicate.withParentheses((Predicate)GroupTable.INSTANCE.typeSettings.like("%branchingPrivate=true%").or((Expression)GroupTable.INSTANCE.typeSettings.like("%branchingPublic=true%"))))).or((Expression)GroupTable.INSTANCE.liveGroupId.gt((Object)0L).and((Expression)GroupTable.INSTANCE.liveGroupId.in((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{GroupTable.INSTANCE.groupId}).from((Table)GroupTable.INSTANCE).where(GroupTable.INSTANCE.typeSettings.like("%branchingPrivate=true%").or((Expression)GroupTable.INSTANCE.typeSettings.like("%branchingPublic=true%")))))));
    }
}

